/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.judan;

import jp.go.ipa.jgcl.JgclBoundedCurve2D;
import jp.go.ipa.jgcl.JgclBoundedCurve3D;
import jp.go.ipa.jgcl.JgclBoundedSurface3D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclConicalSurface3D;
import jp.go.ipa.jgcl.JgclCylindricalSurface3D;
import jp.go.ipa.jgcl.JgclEllipse2D;
import jp.go.ipa.jgcl.JgclEllipse3D;
import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclHyperbola2D;
import jp.go.ipa.jgcl.JgclHyperbola3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclParabola2D;
import jp.go.ipa.jgcl.JgclParabola3D;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve;
import jp.go.ipa.jgcl.JgclParametricSurface;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclSphericalSurface3D;
import jp.go.ipa.jgcl.JgclSurfaceCurve3D;
import jp.go.ipa.jgcl.JgclSurfaceOfLinearExtrusion3D;
import jp.go.ipa.jgcl.JgclSurfaceOfRevolution3D;

public class JudanSuitableParameterSection {
    private static final double INFINITE_LIMIT = 1.0;

    public static JgclParameterSection asCurve(JgclGeometry geometry) {
        double increase;
        double start;
        JgclParametricCurve curve = (JgclParametricCurve)geometry;
        if (geometry instanceof JgclLine2D || geometry instanceof JgclLine3D) {
            start = -1.0;
            increase = 2.0;
        } else if (geometry instanceof JgclCircle2D || geometry instanceof JgclCircle3D || geometry instanceof JgclEllipse2D || geometry instanceof JgclEllipse3D) {
            start = 0.0;
            increase = Math.PI * 2;
        } else if (geometry instanceof JgclHyperbola2D || geometry instanceof JgclHyperbola3D || geometry instanceof JgclParabola2D || geometry instanceof JgclParabola3D) {
            start = -3.0;
            increase = 6.0;
        } else {
            if (geometry instanceof JgclBoundedCurve2D || geometry instanceof JgclBoundedCurve3D) {
                return curve.parameterDomain().section();
            }
            if (geometry instanceof JgclSurfaceCurve3D) {
                JgclSurfaceCurve3D surfaceCurve = (JgclSurfaceCurve3D)geometry;
                if (surfaceCurve.masterRepresentation() == 0) {
                    return JudanSuitableParameterSection.asCurve((JgclGeometry)surfaceCurve.curve3d());
                }
                throw new JgclNotSupported();
            }
            System.out.println(geometry.getClass().getName());
            throw new JgclInvalidArgumentValue();
        }
        return new JgclParameterSection(start, increase);
    }

    public static JgclParameterSection[] asSurface(JgclGeometry geometry) {
        double uIncrease;
        double vIncrease;
        double uStart;
        double vStart;
        JgclParametricSurface surface = (JgclParametricSurface)geometry;
        if (geometry instanceof JgclPlane3D) {
            vStart = -1.0;
            uStart = -1.0;
            vIncrease = 2.0;
            uIncrease = 2.0;
        } else if (geometry instanceof JgclCylindricalSurface3D) {
            uStart = 0.0;
            uIncrease = Math.PI * 2;
            vStart = -1.0;
            vIncrease = 2.0;
        } else if (geometry instanceof JgclConicalSurface3D) {
            JgclConicalSurface3D con = (JgclConicalSurface3D)surface;
            uStart = 0.0;
            uIncrease = Math.PI * 2;
            double vLength = con.radius() / Math.tan(con.semiAngle());
            vStart = -vLength * 2.0;
            vIncrease = vLength * 2.0;
        } else if (geometry instanceof JgclSphericalSurface3D) {
            uStart = 0.0;
            uIncrease = Math.PI * 2;
            vStart = -1.5707963267948977;
            vIncrease = 3.1415926535897922;
        } else if (geometry instanceof JgclBoundedSurface3D) {
            uStart = surface.uParameterDomain().section().start();
            uIncrease = surface.uParameterDomain().section().increase();
            vStart = surface.vParameterDomain().section().start();
            vIncrease = surface.vParameterDomain().section().increase();
        } else if (geometry instanceof JgclSurfaceOfRevolution3D) {
            JgclSurfaceOfRevolution3D rvs = (JgclSurfaceOfRevolution3D)geometry;
            JgclParameterSection vsec = JudanSuitableParameterSection.asCurve((JgclGeometry)rvs.sweptCurve());
            uStart = 0.0;
            uIncrease = Math.PI * 2;
            vStart = vsec.start();
            vIncrease = vsec.increase();
        } else if (geometry instanceof JgclSurfaceOfLinearExtrusion3D) {
            JgclSurfaceOfLinearExtrusion3D les = (JgclSurfaceOfLinearExtrusion3D)geometry;
            JgclParameterSection vsec = JudanSuitableParameterSection.asCurve((JgclGeometry)les.sweptCurve());
            uStart = vsec.start();
            uIncrease = vsec.increase();
            vStart = -1.0;
            vIncrease = 2.0;
        } else {
            System.out.println(geometry.getClass().getName());
            throw new JgclNotSupported();
        }
        JgclParameterSection[] sol = new JgclParameterSection[]{new JgclParameterSection(uStart, uIncrease), new JgclParameterSection(vStart, vIncrease)};
        return sol;
    }
}

