/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.judan;

import java.util.Hashtable;
import java.util.Vector;
import jp.co.sra.judan.JudanMethodWrapper;
import jp.go.ipa.jgcl.JgclGeometry;

public class JudanParsedInfo {
    private Vector nameList = new Vector();
    private Hashtable entityTable = new Hashtable();
    private Hashtable propertyTable = new Hashtable();
    private Vector commandTable = new Vector();

    public JudanParsedInfo(Vector nameList, Hashtable entityTable, Hashtable propertyTable, Vector commandTable) {
        this.nameList = nameList;
        this.entityTable = entityTable;
        this.propertyTable = propertyTable;
        this.commandTable = commandTable;
    }

    private JudanMethodWrapper makeMethod(Vector command) {
        String geometryName = (String)command.elementAt(0);
        JgclGeometry geometry = (JgclGeometry)this.entityTable.get(geometryName);
        int nArgument = command.size() - 2;
        Class[] argClasses = new Class[nArgument];
        Object[] argEntities = new Object[nArgument];
        int j = 0;
        while (j < nArgument) {
            String argName = (String)command.elementAt(j + 2);
            Object obj = this.propertyTable.get(argName);
            if (obj == null) {
                obj = this.entityTable.get(argName);
            }
            if (obj == null) {
                System.out.println("No such Goemetry associated with " + argName);
            }
            argEntities[j] = obj;
            argClasses[j] = argEntities[j].getClass();
            ++j;
        }
        String methodName = (String)command.elementAt(1);
        return new JudanMethodWrapper(geometry, methodName, argClasses, argEntities);
    }

    public void execute(boolean isOutputCharacter, boolean isOutputLispSExpression, boolean isOutputVisual) {
        int i = 0;
        while (i < this.commandTable.size()) {
            Vector command = (Vector)this.commandTable.elementAt(i);
            JudanMethodWrapper method = this.makeMethod(command);
            method.invoke();
            if (isOutputCharacter) {
                method.output();
            } else if (isOutputLispSExpression) {
                method.toLispSExpression();
            }
            if (isOutputVisual) {
                method.view();
            }
            ++i;
        }
    }
}

