#include "font_renderer.h"

void save_image(font_renderer &ft, char *filename){
	FILE *fp = fopen(filename, "wb");
	fprintf(fp, "P6\n%d %d\n255\n", ft.get_width(), ft.get_height());
	fwrite(ft.get_image(), ft.get_width()*ft.get_height()*3, 1, fp);
	fclose(fp);
}

void resize(int &width, int &height){
	width /= 2, height /= 2;
}

int main(void){
	char *text = "Hello, world!ɂ!";
	font_renderer ft(text, 16);
	save_image(ft, "hoge1.ppm");
	ft.render(text, 20, true, true, true);
	save_image(ft, "hoge2.ppm");
	ft.render(text, 80, false, false, true, font_renderer::rgb_type(255,255,0));
	save_image(ft, "hoge3.ppm");
}
