// LRU container Template Library version 1.00
//
// Copylight (C) 2006 mocchi
//
//  This software is provided 'as-is', without any express or implied
//  warranty.  In no event will the authors be held liable for any damages
//  arising from the use of this software.
//
//  Permission is granted to anyone to use this software for any purpose,
//  including commercial applications, and to alter it and redistribute it
//  freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//     claim that you wrote the original software. If you use this software
//     in a product, an acknowledgment in the product documentation would be
//     appreciated but is not required.
//  2. Altered source versions must be plainly marked as such, and must not be
//     misrepresented as being the original software.
//  3. This notice may not be removed or altered from any source distribution.
//
// mocchi mocchi_2003@yahoo.co.jp
//

#ifndef IRU_CONTAINER_H_
#define IRU_CONTAINER_H_

#include <list>
#include <map>

namespace lru{
	template <typename T> class lru{
		std::list<T> sequence;
		std::map<T, typename std::list<T>::iterator> map;
		size_t buffer_size_;
	public:
		typedef typename std::list<T>::iterator iterator;
		typedef typename std::list<T>::reverse_iterator reverse_iterator;
		lru(size_t buffer_size = 100) : buffer_size_(buffer_size){
		}
		bool add(T t, T &removed){
			if (map.count(t)){
				sequence.erase(map[t]);
				sequence.push_front(t);
				map[t] = sequence.begin();
				return false;
			}else{
				sequence.push_front(t);
				map[t] = sequence.begin();
				if (sequence.size() > buffer_size_){
					removed = sequence.back();
					sequence.pop_back();
					map.erase(removed);
					return true;
				}
			}
			return false;
		}
		iterator begin(){
			return sequence.begin();
		}
		iterator end(){
			return sequence.end();
		}
		reverse_iterator rbegin(){
			return sequence.rbegin();
		}
		reverse_iterator rend(){
			return sequence.rend();
		}
	};
}

#endif // IRU_CONTAINER_H_
