/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.stats2excel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.omegat.util.LFileCopy;
import org.omegat.util.Log;
import org.omegat.util.StaticUtils;

public class ExcelModel {
    private static final String CONFIG_DIR_NAME = "stats2excel";
    private static final String WSF_NAME = "Stats2Excel.wsf";
    private static final String LEGACY_STANDARD_TEMPLATE_NAME = "StandardTemplate.xlt";
    private static final String STANDARD_TEMPLATE_NAME = "StandardTemplate.xltx";
    private static final String TXT_NAME = "Stats2Excel.txt";
    private static final File _wsf;
    private static final File _txt;
    private static String windowTitle;
    private static int installedExcelVersion;
    public static final int INSTALLED_VERSION_NOT_FOUND = -1;

    private ExcelModel() {
    }

    public static int getInstalledExcelVersion() {
        return installedExcelVersion;
    }

    public static void setWindowTitle(String title) {
        windowTitle = title;
    }

    private static void initInstalledExcelVersion() {
        boolean RET_OK = false;
        int ver = -1;
        try {
            String s;
            String EXCEL_VER_KEY = "Excel.Application\\CurVer";
            Command command = new Command();
            if (0 == command.execDOS("assoc", "Excel.Application\\CurVer") && (s = command.getStdout()).startsWith("Excel.Application\\CurVer=Excel.Application.")) {
                String versionString = s.substring("Excel.Application\\CurVer=Excel.Application.".length()).replaceAll("\\r\\n", "");
                ver = Integer.parseInt(versionString);
            }
        }
        catch (Exception ex) {
            Log.log(ex);
        }
        installedExcelVersion = ver;
    }

    public static void display(String text) throws IOException, InterruptedException {
        final File txt = ExcelModel.createTxt(text);
        final File template = ExcelModel.getTemplate();
        boolean succeed = ExcelModel.activate();
        if (!succeed) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        Command command = new Command();
                        String dataFilePath = txt.getCanonicalPath();
                        String templateFilePath = template.getCanonicalPath();
                        String job = "launch";
                        int ret = command.execWSF(job, dataFilePath, templateFilePath, windowTitle);
                        if (!command.stderr.isEmpty()) {
                            Log.log("Fail to launch Excel. error(" + ret + "): " + command.stderr);
                        } else {
                            ExcelModel.onExcelApplicationQuit(ret);
                        }
                    }
                    catch (IOException ex) {
                        Log.log(ex);
                    }
                    catch (InterruptedException ex) {
                        Log.log(ex);
                    }
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getTemplate() throws IOException {
        String templateName;
        File template;
        File parent = new File(StaticUtils.getConfigDir(), CONFIG_DIR_NAME);
        if (!parent.isDirectory()) {
            parent.mkdirs();
        }
        if (!(template = new File(parent, templateName = installedExcelVersion >= 12 ? STANDARD_TEMPLATE_NAME : LEGACY_STANDARD_TEMPLATE_NAME)).exists()) {
            InputStream in = ExcelModel.class.getResourceAsStream(templateName);
            try {
                LFileCopy.copy(in, template);
            }
            finally {
                in.close();
            }
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getWSF() throws IOException {
        if (!_wsf.exists()) {
            InputStream in = ExcelModel.class.getResourceAsStream(WSF_NAME);
            try {
                LFileCopy.copy(in, _wsf);
            }
            finally {
                in.close();
            }
        }
        _wsf.deleteOnExit();
        return _wsf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createTxt(String content) throws IOException {
        String LINE_BREAK = "\r\n";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(255);
        out.write(254);
        out.write(content.replaceAll("\n", LINE_BREAK).getBytes("UTF-16LE"));
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        try {
            LFileCopy.copy((InputStream)in, _txt);
        }
        finally {
            ((InputStream)in).close();
        }
        _txt.deleteOnExit();
        return _txt;
    }

    public static boolean activate() throws IOException, InterruptedException {
        Command command = new Command();
        String job = "activate";
        int ret = command.execWSF("activate", windowTitle);
        return ret == 0;
    }

    private static void onExcelApplicationQuit(int returnCode) {
        ExcelModel.deleteDataFile();
        ExcelModel.deleteWSF();
    }

    public static void close() {
        ExcelModel.deleteDataFile();
    }

    private static void deleteDataFile() {
        if (_txt.exists()) {
            _txt.delete();
        }
    }

    private static void deleteWSF() {
        if (_wsf.exists()) {
            _wsf.delete();
        }
    }

    static {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        _wsf = new File(tempDir, WSF_NAME);
        _txt = new File(tempDir, TXT_NAME);
        ExcelModel.initInstalledExcelVersion();
    }

    protected static class Command {
        private int exitCode = 0;
        private String stdout = "";
        private String stderr = "";

        protected Command() {
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getStdout() {
            return this.stdout;
        }

        public String getStderr() {
            return this.stderr;
        }

        public int exec(String ... command) throws IOException, InterruptedException {
            return this.startProcessAndWait(Arrays.asList(command));
        }

        public int execDOS(String ... command) throws IOException, InterruptedException {
            ArrayList<String> commands = new ArrayList<String>(command.length + 2);
            commands.add("cmd.exe");
            commands.add("/c");
            commands.addAll(Arrays.asList(command));
            return this.startProcessAndWait(commands);
        }

        public int execWSF(String job, String ... command) throws IOException, InterruptedException {
            String script = ExcelModel.getWSF().getCanonicalPath();
            ArrayList<String> commands = new ArrayList<String>(command.length + 4);
            commands.add("cscript.exe");
            commands.add("//nologo");
            commands.add("//Job:" + job);
            commands.add(script);
            commands.addAll(Arrays.asList(command));
            return this.startProcessAndWait(commands);
        }

        private int startProcessAndWait(List<String> command) throws IOException, InterruptedException {
            ProcessBuilder pb = new ProcessBuilder(command);
            Process process = pb.start();
            this.exitCode = process.waitFor();
            this.stdout = this.getString(process.getInputStream());
            this.stderr = this.getString(process.getErrorStream());
            return this.exitCode;
        }

        private String getString(InputStream is) throws IOException {
            byte[] b = new byte[1024];
            int size = is.read(b);
            if (size > 0) {
                return new String(b, 0, size);
            }
            return "";
        }
    }
}

