/*
 * base16k encoder / decoder
 * Copylight (C) 2013 mocchi
 * mocchi_2003@yahoo.co.jp
 * License: Boost ver.1
 */

#include <cstdio>
#include <cstdlib>
#include <cmath>

#include <vector>
#include <string>


#ifdef _WIN32
#include <windows.h>
typedef USHORT UTF16Char;
typedef BYTE Byte;
#else
#include <cstdint>
typedef uint16_t UTF16Char;
typedef uint8_t Byte;
#endif

// [Reference]
// Base16k
// Efficient Binary Data Encoding in Unicode Text
// Markus Scherer, 2004-may-28
// https://sites.google.com/site/markusicu/unicode/base16k

int Base16kEncodeSize(int lenData){
	if (lenData == 0) return 1;
	int numDeg = static_cast<int>(std::log10(static_cast<double>(lenData)))+1;
	int numStrMain = (lenData / 7) * 4;
	int numStrR = ((lenData % 7) * 4 + 6) / 7;
	return (numDeg + numStrMain + numStrR);
}

/// oCiɑ΂ABase16kGR[h{AGR[hꂽo͂B
/// @param [in] data oCi
/// @param [in] lenData oCĩTCY
/// @param [i/o] str Ăяo Base16kEncodeSize(lenData) ȏ̗̈mۂ邱ƁBGR[hꂽ񂪏o͂B 
/// @return o
int Base16kEncode(const Byte *data, int lenData, UTF16Char *str){
	int numChar;

	if (lenData == 0){
		*str = '0';
		return 1;
	}

	// ŏɃf[^
	int numDeg = 0;
	UTF16Char *s = str;
	std::vector<UTF16Char> rs;
	{
		int l = lenData;
		while(l){
			div_t v = div(l, 10);
			l = v.quot;
			rs.push_back(v.rem + 0x30);
		}
		for (int i = static_cast<int>(rs.size() - 1); i >= 0; --i){
			(*s++) = rs[i];
		}
	}

	// {̂̏
	int numStrMain = (lenData / 7) * 4;
	int lenDataR = lenData % 7;
	int numstrR = (lenDataR * 4 + 6) / 7;

	UTF16Char *s4 = s, *s4l = s + numStrMain, *s4e;
	const Byte *d7 = data;
	// Ō̔[ȕ̏Ɏgp
	UTF16Char s4r[4] = {0};
	Byte d7r[7] = {0};

	//    b0       b1       b2       b3       b4       b5       b6
	// 01234567 01234567 01234567 01234567 01234567 01234567 01234567
	// => c0:01234567012345
	//    c1:67012345670123
	//    c2:45670123456701
	//    c3:23456701234567

	s4e = s4l;
	for (int j = 0; j < 2; ++j){
		// j0Ŕ[ɂȂ܂ł̕A1Ŕ[ȕ
		for (; s4 < s4e; s4 += 4, d7 += 7){
			s4[0] = 0x5000 + (static_cast<UTF16Char>(d7[0]      ) <<  6) + (static_cast<UTF16Char>(d7[1]) >> 2);
			s4[1] = 0x5000 + (static_cast<UTF16Char>(d7[1] &   3) << 12) + (static_cast<UTF16Char>(d7[2]) << 4) + (static_cast<UTF16Char>(d7[3]) >> 4);
			s4[2] = 0x5000 + (static_cast<UTF16Char>(d7[3] &  15) << 10) + (static_cast<UTF16Char>(d7[4]) << 2) + (static_cast<UTF16Char>(d7[5]) >> 6);
			s4[3] = 0x5000 + (static_cast<UTF16Char>(d7[5] &  63) <<  8) + (static_cast<UTF16Char>(d7[6]));
		}

		if (j == 1) break;

		// [ȕ̃f[^pӂB
		for (int i = 0; i < lenDataR; ++i) d7r[i] = d7[i];
		for (int i = 0; i < numstrR; ++i) s4r[i] = s4[i];
		s4 = s4r;
		s4e = s4 + 4;
		d7 = d7r;
	}

	// [ȕ߂B
	for (int i = 0; i < numstrR; ++i) s4l[i] = s4r[i];

	return static_cast<int>(s4l - str) + numstrR;
}

int Base16kDecodeSize(const UTF16Char *str, int numStr, const UTF16Char **strMain = 0){
	int num = 0;
	const UTF16Char *se = str + numStr;
	if (*str == 0xfeff) ++str;
	while(str < se && 0x30 <= *str && *str <= 0x39){
		num *= 10;
		num += *str - 0x30;
		++str;
	}
	if (strMain) *strMain = str;
	return num;
}

/// Base16kɑ΂AoCiւ̃fR[h{B
/// @param [in] str Base16k
/// @param [in] lenData 
/// @param [i/o] data Ăяo Base16kDecodeSize oCgȏ̗̈mۂ邱ƁBfR[hꂽoCi񂪏o͂B 
/// @return oꂽoCif[^TCY
int Base16kDecode(const UTF16Char *str, int numStr, Byte *data){
	const UTF16Char *se = str + numStr;
	if (*str == 0xfeff) ++str;

	//       c0             c1             c2             c3
	// 0123456789abcd 0123456789abcd 0123456789abcd 0123456789abcd
	// =>    b0       b1
	//    01234567 89abcdxx           phase:0
    //       b1       b2       b3
	//    xxxxxx01 23456789 abcdxxxx  phase:1
    //       b3       b4       b5
	//    xxxx0123 456789ab cdxxxxxx  phase:2
    //       b5       b6
	//    xx012345 6789abcd           phase:3

	Byte *d = data;
	int lenData = Base16kDecodeSize(str, numStr, &str);
	for (int i = 0; i < lenData; ++i) d[i] = 0;
	int lenRem = lenData;

	int ofs1[] = {6, 12, 10, 8}, ofs2[] = {-2, 4, 2, 0}, ofs3[] = {0, 4, 6, 0};
	int dcnt[] = {1, 2, 2, 2};
	int phase = 0;
	for (const UTF16Char *s = str; lenRem && s < se; ++s){
		if (*s < 0x5000 || *s > 0x8fff) continue;
		UTF16Char c = *s - 0x5000;
		d[0] |= static_cast<Byte>(c >> ofs1[phase]);
		if (phase == 0 && lenRem >= 2) d[1] |= static_cast<Byte>((c << 2) & 0xff);
		else{
			if (lenRem >= 2) d[1] |= static_cast<Byte>((c >> ofs2[phase]) & 0xff);
			if ((phase == 1 || phase == 2) && (lenRem >= 3)) d[2] |= static_cast<Byte>((c << ofs3[phase]) & 0xff);
		}

		d += dcnt[phase];
		lenRem -= dcnt[phase];

		++phase;
		phase = phase & 3;
	}
	return lenData;
}

int main(int argc, char *argv[]){
	if (argc < 4) return 0;
	FILE *fpi = 0, *fpo = 0;
	fpi = fopen(argv[2], "rb");
	fseek(fpi, 0, SEEK_END);
	size_t szi = ftell(fpi);
	rewind(fpi);
	fpo = fopen(argv[3], "wb");
	if (strcmp(argv[1], "-e") == 0){
		if (szi == 0){
		}else{
			std::vector<Byte> bytes(szi);
			fread(&bytes[0], 1, bytes.size(), fpi);
			std::vector<UTF16Char> str(Base16kEncodeSize(szi));
			int numStr = Base16kEncode(&bytes[0], static_cast<int>(bytes.size()), &str[0]);
			UTF16Char bom = 0xfeff, cr = 0x0a;
			fwrite(&bom, 1, 2, fpo);
			int cnt = 0;
			while(numStr > 0){
				fwrite(&str[cnt], 1, (numStr >= 200 ? 200 : numStr) * 2, fpo);
				cnt += 200;
				numStr -= 200;
				fwrite(&cr, 1, 2, fpo);
			}
		}
	}else if (strcmp(argv[1], "-d") == 0){
		std::vector<UTF16Char> str(szi/2);
		fread(&str[0], 1, str.size()*2, fpi);
		std::vector<Byte> bytes(Base16kDecodeSize(&str[0], szi / 2));
		int lenData = Base16kDecode(&str[0], static_cast<int>(str.size()), &bytes[0]);
		fwrite(&bytes[0], 1, lenData, fpo);
	}
	fclose(fpi);
	fclose(fpo);
	return 0;
}
