/*
 *  The MIT License
 *
 *  Copyright 2013 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.dropbox_uploader;

import org.routine_work.simple_battery_logger.util.CsvFilenameFilter;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.TextView;
import java.io.File;
import org.routine_work.util.Log;

public class UploadNewCsvFilesActivity extends Activity
	implements OnClickListener
{

	public static final String LOG_TAG = "simple-battery-logger-dropbox";

	@Override
	public void onClick(View view)
	{
		int id = view.getId();
		switch (id)
		{
			case R.id.ok_button:
				uploadAllCsvData();
				setResult(RESULT_OK);
				finish();
				break;
			case R.id.cancel_button:
				setResult(RESULT_CANCELED);
				finish();
				break;
		}
	}

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.upload_all_csv_file_activity);

		Button okButton = (Button) findViewById(R.id.ok_button);
		okButton.setOnClickListener(this);
		Button cancelButton = (Button) findViewById(R.id.cancel_button);
		cancelButton.setOnClickListener(this);
	}

	@Override
	protected void onResume()
	{
		super.onResume();

		boolean canUpload = false;
		int csvFileCount = UploadServiceUtils.getCsvUploadStatusList(this).size();
		if (csvFileCount > 0)
		{
			// init confirm message
			String confirmMessage = getResources().getQuantityString(
				R.plurals.upload_csv_file_confirm_message, csvFileCount);
			Log.d(LOG_TAG, "delete csv confirm message => " + confirmMessage);

			TextView confirmMessageTextView = (TextView) findViewById(R.id.upload_csv_file_confirm_message_textview);
			confirmMessageTextView.setText(confirmMessage);
			canUpload = true;
		}

		Button okButton = (Button) findViewById(R.id.ok_button);
		okButton.setEnabled(canUpload);

		CheckBox forceUploadCheckBox = (CheckBox) findViewById(R.id.force_upload_checkbox);
		forceUploadCheckBox.setEnabled(canUpload);

	}

	private void uploadAllCsvData()
	{
		CheckBox forceUploadCheckBox = (CheckBox) findViewById(R.id.force_upload_checkbox);
		boolean forceUpload = forceUploadCheckBox.isChecked();

		Intent intent = new Intent(this, UploadNewCsvFilesService.class);
		intent.putExtra(BatteryConstants.EXTRA_FORCE_UPLOAD, forceUpload);
		startService(intent);
	}

	private int getCsvFileCount()
	{
		int csvFileCount = -1;
		Log.v(LOG_TAG, "Hello");

		String externalStorageState = Environment.getExternalStorageState();
		if (externalStorageState.equalsIgnoreCase(Environment.MEDIA_MOUNTED))
		{
			String csvExportDirectoryName = PreferenceUtils.getCsvExportDirectoryName(this);
			Log.i(LOG_TAG, "csvExportDirectoryName => " + csvExportDirectoryName);

			File externalStorageDirectory = Environment.getExternalStorageDirectory();
			File exportDir = new File(externalStorageDirectory, csvExportDirectoryName);
			if (exportDir.exists())
			{
				File[] csvFiles = exportDir.listFiles(new CsvFilenameFilter());
				csvFileCount = csvFiles.length;
			}
			else
			{
				csvFileCount = 0;
			}
		}

		Log.d(LOG_TAG, "csvFileCount => " + csvFileCount);
		Log.v(LOG_TAG, "Bye");
		return csvFileCount;
	}
}
