/*
 *  The MIT License
 *
 *  Copyright 2013 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.dropbox_uploader;

import android.app.Activity;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.dropbox.client2.DropboxAPI;
import com.dropbox.client2.android.AndroidAuthSession;
import com.dropbox.client2.exception.DropboxException;
import com.dropbox.client2.session.AccessTokenPair;
import org.routine_work.util.Log;
import org.routine_work.util.SystemResourceUtils;

public class SetupAccountActivity extends Activity implements View.OnClickListener
{

	private static final String LOG_TAG = "simple-battery-logger-dropbox";
	private DropboxAPI<AndroidAuthSession> dropboxAPI;

	public void onClick(View v)
	{
		Log.v(LOG_TAG, "Hello");
		switch (v.getId())
		{
			case R.id.link_account_button:
				Log.d(LOG_TAG, "onClick() : link_account_button is clicked.");
				dropboxAPI.getSession().startAuthentication(this);
				break;
			case R.id.unlink_account_button:
				Log.d(LOG_TAG, "onClick() : unlink_account_button is clicked.");
				unlinkAccount();
				break;
		}
		Log.v(LOG_TAG, "Bye");
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item)
	{
		boolean result = true;
		Log.v(LOG_TAG, "Hello");

		int itemId = item.getItemId();
		if (itemId == SystemResourceUtils.getResourceId("android.R$id.home"))
		{
			setResult(RESULT_CANCELED);
			finish();
		}
		else
		{
			result = super.onOptionsItemSelected(item);
		}

		Log.v(LOG_TAG, "Bye");
		return result;
	}

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		Log.v(LOG_TAG, "Hello");
		super.onCreate(savedInstanceState);
		setContentView(R.layout.setup_account_activity);
		dropboxAPI = DropboxAppConfig.getDropboxAPI(this);

		Button linkButton = (Button) findViewById(R.id.link_account_button);
		linkButton.setOnClickListener(this);
		Button unlinkButton = (Button) findViewById(R.id.unlink_account_button);
		unlinkButton.setOnClickListener(this);

		setResult(RESULT_CANCELED);

		Log.v(LOG_TAG, "Bye");
	}

	@Override
	protected void onResume()
	{
		Log.v(LOG_TAG, "Hello");
		super.onResume();

		AndroidAuthSession session = dropboxAPI.getSession();
		Log.d(LOG_TAG, "isLinked() => " + session.isLinked());
		if (session.isLinked() == false && session.authenticationSuccessful())
		{
			Log.d(LOG_TAG, "authenticationSuccessful!");
			try
			{
				// Required to complete auth, sets the access token on the session
				session.finishAuthentication();
				AccessTokenPair tokens = session.getAccessTokenPair();
				PreferenceUtils.putAccessTokenPair(this, tokens);

				UpdateAccountInfoTask updateAccountInfoTask = new UpdateAccountInfoTask();
				updateAccountInfoTask.execute();
			}
			catch (IllegalStateException e)
			{
				Log.e(LOG_TAG, "Error authenticating", e);
			}
		}

		updateViews();

		Log.v(LOG_TAG, "Bye");
	}

	private void unlinkAccount()
	{
		PreferenceUtils.putAccessTokenPair(this, null);
		PreferenceUtils.putDropboxAccountName(this, null);
		dropboxAPI.getSession().unlink();
		updateViews();
	}

	private void updateViews()
	{
		Log.v(LOG_TAG, "Hello");
		Button linkAccountButton = (Button) findViewById(R.id.link_account_button);
		Button unlinkAccountButton = (Button) findViewById(R.id.unlink_account_button);
		Log.d(LOG_TAG, "isLinked => " + dropboxAPI.getSession().isLinked());
		if (dropboxAPI.getSession().isLinked())
		{
			linkAccountButton.setVisibility(View.GONE);
			unlinkAccountButton.setVisibility(View.VISIBLE);
			linkAccountButton.setEnabled(true);
		}
		else
		{
			linkAccountButton.setVisibility(View.VISIBLE);
			linkAccountButton.setEnabled(true);
			unlinkAccountButton.setVisibility(View.GONE);
		}
		updateAccountNmaeView();

		Log.v(LOG_TAG, "Bye");
	}

	private void updateAccountNmaeView()
	{
		Log.v(LOG_TAG, "Hello");
		String dropboxAccountName = PreferenceUtils.getDropboxAccountName(this);
		if (dropboxAccountName == null)
		{
			dropboxAccountName = getString(R.string.no_account);
		}
		TextView textView = (TextView) findViewById(R.id.dropbox_account_name_textview);
		textView.setText(dropboxAccountName);
		Log.v(LOG_TAG, "Bye");
	}

	class UpdateAccountInfoTask extends AsyncTask<Void, Void, Boolean>
	{

		private DropboxAPI.Account accountInfo;

		@Override
		protected Boolean doInBackground(Void... paramss)
		{
			boolean result = false;
			Log.d(LOG_TAG, "Hello");

			try
			{
				accountInfo = dropboxAPI.accountInfo();
				result = true;
			}
			catch (DropboxException ex)
			{
				Log.e(LOG_TAG, "Error getting account info.", ex);
			}

			Log.d(LOG_TAG, "Bye");
			return result;
		}

		@Override
		protected void onPostExecute(Boolean result)
		{
			Log.d(LOG_TAG, "Hello");
			if (result)
			{
				PreferenceUtils.putDropboxAccountName(SetupAccountActivity.this, accountInfo.displayName);
				updateAccountNmaeView();
			}
			Log.d(LOG_TAG, "Bye");
		}
	}
}