/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.plugin.foldermenu.filepreview;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.omegat.plugin.foldermenu.L10n;
import org.omegat.plugin.foldermenu.filepreview.FilePreview;
import org.omegat.plugin.foldermenu.filepreview.IPreview;
import org.omegat.util.LFileCopy;
import org.omegat.util.Log;
import org.omegat.util.Platform;
import org.omegat.util.StaticUtils;

public class WordPreview
implements IPreview {
    private static final String WSF_NAME = "WordPreview.wsf";
    private static boolean _isMSWordAvailable;
    private static File _wsf;
    private final File originalFile;
    private long originalFileLastModified;
    private final String windowTitle;
    private final File temporaryFile;
    private final File temporaryFile2;

    public WordPreview(File originalFile) throws IOException {
        this.originalFile = originalFile;
        this.originalFileLastModified = originalFile.lastModified();
        this.temporaryFile = this.getTempFile(originalFile);
        this.windowTitle = StaticUtils.format(L10n.getWordWindowCaption(), originalFile.getName());
        this.temporaryFile2 = this.getTempFile2(this.temporaryFile);
    }

    public static boolean isAvailable(File file) {
        return WordPreview.isAvailable() && file.isFile() && file.getName().toLowerCase().endsWith(".docx");
    }

    public static boolean isAvailable() {
        return _isMSWordAvailable;
    }

    public static void init() {
    }

    private static boolean getMSWordAvailable() {
        boolean RET_OK = false;
        try {
            String s;
            Command command = new Command();
            if (0 == command.execDOS("assoc", ".docx") && (s = command.getStdout()).toLowerCase().startsWith(".docx=word.document.")) {
                String classString = s.substring(".docx=".length()).replaceAll("\\r\\n", "");
                if (0 == command.exec("reg", "query", "HKCR\\" + classString + "\\shell\\open\\command", "/ve")) {
                    s = command.getStdout();
                    return s.toUpperCase().indexOf("\\WINWORD.EXE") > -1;
                }
            }
        }
        catch (Exception ex) {
            Log.log(ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getWSF() throws IOException {
        if (!_wsf.exists()) {
            InputStream in = WordPreview.class.getResourceAsStream(WSF_NAME);
            try {
                LFileCopy.copy(in, _wsf);
            }
            finally {
                in.close();
            }
            _wsf.deleteOnExit();
        }
        return _wsf;
    }

    @Override
    public String[] getTempFiles() {
        String[] paths = new String[3];
        try {
            paths[0] = this.temporaryFile.getCanonicalPath();
            paths[1] = this.temporaryFile2.getCanonicalPath();
            String PREFIX = "~$";
            String parent = this.temporaryFile.getParent();
            String name = this.temporaryFile.getName();
            paths[2] = new File(parent, "~$" + name.substring(2)).getCanonicalPath();
        }
        catch (IOException ex) {
            Log.log(ex);
        }
        return paths;
    }

    @Override
    public void activate() {
        try {
            Command command = new Command();
            String job = "activate";
            int n = command.execWSF("activate", this.windowTitle);
        }
        catch (IOException ex) {
            Log.log(ex);
        }
        catch (InterruptedException ex) {
            Log.log(ex);
        }
    }

    @Override
    public void open() {
        new Thread(){

            @Override
            public void run() {
                try {
                    LFileCopy.copy(WordPreview.this.originalFile, WordPreview.this.temporaryFile);
                    WordPreview.this.addHiddenFileAttribute(WordPreview.this.temporaryFile);
                    Command command = new Command();
                    String document = WordPreview.this.temporaryFile.getCanonicalPath();
                    String document2 = WordPreview.this.temporaryFile2.getCanonicalPath();
                    String job = "open";
                    int ret = command.execWSF(job, document, document2, WordPreview.this.windowTitle);
                    if (!command.stderr.isEmpty()) {
                        Log.log("Word error(" + ret + "): " + command.stderr);
                    }
                    WordPreview.this.onWordApplicationQuit(ret);
                }
                catch (IOException ex) {
                    Log.log(ex);
                }
                catch (InterruptedException ex) {
                    Log.log(ex);
                }
            }
        }.start();
    }

    private File getTempFile(File originalFile) throws IOException {
        String prefix = "_WordPreview";
        String name = originalFile.getName();
        String suffix = name.substring(name.lastIndexOf("."));
        File parentFolder = originalFile.getParentFile();
        File tempFile = File.createTempFile(prefix, suffix, parentFolder);
        tempFile.deleteOnExit();
        return tempFile;
    }

    private File getTempFile2(File primaryTempFile) throws IOException {
        String name = primaryTempFile.getName();
        int lastDotPos = name.lastIndexOf(".");
        String baseName = name.substring(0, lastDotPos);
        String extension = name.substring(lastDotPos);
        String fileName = baseName + "(2)" + extension;
        File parentFolder = primaryTempFile.getParentFile();
        File tempFile2 = new File(parentFolder, fileName);
        tempFile2.deleteOnExit();
        return tempFile2;
    }

    private void addHiddenFileAttribute(File file) {
        try {
            new ProcessBuilder("attrib", "+H", file.getCanonicalPath()).start();
        }
        catch (IOException ex) {
            Log.log(ex);
        }
    }

    private void onWordApplicationQuit(int returnCode) {
        try {
            FilePreview.delete(this.originalFile);
            this.temporaryFile.delete();
            if (FilePreview.size(WordPreview.class) == 0) {
                _wsf.delete();
            }
        }
        catch (IOException ex) {
            Log.log(ex);
        }
    }

    @Override
    public void close() {
        try {
            Command command = new Command();
            String job = "close";
            String document = this.temporaryFile.getCanonicalPath();
            command.execWSF("close", document);
        }
        catch (IOException ex) {
            Log.log(ex);
        }
        catch (InterruptedException ex) {
            Log.log(ex);
        }
    }

    @Override
    public void reload() {
        if (!this.isOriginalFileUpdated()) {
            return;
        }
        try {
            File temp = this.getTempFile(this.originalFile);
            LFileCopy.copy(this.originalFile, temp);
            temp.renameTo(this.temporaryFile2);
            this.addHiddenFileAttribute(this.temporaryFile2);
            this.originalFileLastModified = this.originalFile.lastModified();
        }
        catch (IOException ex) {
            Log.log(ex);
        }
    }

    private boolean isOriginalFileUpdated() {
        return this.originalFileLastModified != this.originalFile.lastModified();
    }

    static {
        switch (Platform.getOsType()) {
            case WIN64: 
            case WIN32: {
                new Thread(){

                    @Override
                    public void run() {
                        _isMSWordAvailable = WordPreview.getMSWordAvailable();
                        Log.log("_isMSWordAvailable = " + _isMSWordAvailable);
                    }
                }.start();
                break;
            }
            default: {
                _isMSWordAvailable = false;
            }
        }
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        _wsf = new File(tempDir, WSF_NAME);
    }

    protected static class Command {
        private int exitCode = 0;
        private String stdout = "";
        private String stderr = "";

        protected Command() {
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getStdout() {
            return this.stdout;
        }

        public String getStderr() {
            return this.stderr;
        }

        public int exec(String ... command) throws IOException, InterruptedException {
            return this.startProcessAndWait(Arrays.asList(command));
        }

        public int execDOS(String ... command) throws IOException, InterruptedException {
            ArrayList<String> commands = new ArrayList<String>(command.length + 2);
            commands.add("cmd.exe");
            commands.add("/c");
            commands.addAll(Arrays.asList(command));
            return this.startProcessAndWait(commands);
        }

        public int execWSF(String job, String ... command) throws IOException, InterruptedException {
            String script = WordPreview.getWSF().getCanonicalPath();
            ArrayList<String> commands = new ArrayList<String>(command.length + 4);
            commands.add("cscript.exe");
            commands.add("//nologo");
            commands.add("//Job:" + job);
            commands.add(script);
            commands.addAll(Arrays.asList(command));
            return this.startProcessAndWait(commands);
        }

        private int startProcessAndWait(List<String> command) throws IOException, InterruptedException {
            ProcessBuilder pb = new ProcessBuilder(command);
            Process process = pb.start();
            this.exitCode = process.waitFor();
            this.stdout = this.getString(process.getInputStream());
            this.stderr = this.getString(process.getErrorStream());
            return this.exitCode;
        }

        private String getString(InputStream is) throws IOException {
            byte[] b = new byte[1024];
            int size = is.read(b);
            if (size > 0) {
                return new String(b, 0, size);
            }
            return "";
        }
    }
}

