/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.plugin.foldermenu;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import org.omegat.plugin.foldermenu.MenuHelper;
import org.omegat.plugin.foldermenu.ShellLinkMenuItem;
import org.omegat.util.Log;
import org.openide.awt.Mnemonics;

public class ShellLinkMenu
extends ShellLinkMenuItem {
    public ShellLinkMenu(JMenu m) {
        super(m);
    }

    public ShellLinkMenu(File folder) throws IOException {
        this(folder, null);
    }

    public ShellLinkMenu(String label) throws IOException {
        this(null, label);
    }

    public ShellLinkMenu(File folder, String label) throws IOException {
        JMenu m;
        if (label == null) {
            m = new JMenu(folder.getName());
        } else {
            m = new JMenu();
            Mnemonics.setLocalizedText((AbstractButton)m, (String)label);
        }
        m.addMenuListener(MenuHelper.getMenuListener());
        m.addMouseListener(MenuHelper.getMouseListener());
        if (folder != null) {
            m.setIcon(MenuHelper.getIcon(folder));
            m.setActionCommand(folder.getCanonicalPath());
        } else {
            m.setEnabled(false);
        }
        this.menuItem = m;
    }

    public void createChildren() {
        JMenu menu = (JMenu)this.menuItem;
        if (menu.isEnabled() && menu.getItemCount() == 0) {
            File folder = new File(menu.getActionCommand());
            File[] filteredListFiles = MenuHelper.getFilteredListFiles(folder);
            Arrays.sort(filteredListFiles, MenuHelper.getComparator());
            for (File file : filteredListFiles) {
                try {
                    if (file.isDirectory() && this.hasChildren(file)) {
                        menu.add(new ShellLinkMenu(file).getMenuItem());
                        continue;
                    }
                    menu.add(new ShellLinkMenuItem(file).getMenuItem());
                }
                catch (IOException ex) {
                    Log.log(ex);
                }
            }
        }
    }

    public JMenu getMenu() {
        return (JMenu)this.menuItem;
    }

    public void link(File folder) throws IOException {
        JMenu menu = (JMenu)this.menuItem;
        menu.setActionCommand(folder.getCanonicalPath());
        menu.setIcon(MenuHelper.getIcon(folder));
        menu.setEnabled(true);
    }

    public void unlink() {
        JMenu menu = (JMenu)this.menuItem;
        menu.setEnabled(false);
        menu.removeAll();
        menu.setActionCommand("");
        menu.setIcon(null);
    }

    private boolean hasChildren(File folder) {
        return MenuHelper.getFilteredListFiles(folder).length > 0;
    }
}

