/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.plugin.foldermenu;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.omegat.core.Core;
import org.omegat.plugin.foldermenu.L10n;
import org.omegat.plugin.foldermenu.MenuHelper;
import org.omegat.plugin.foldermenu.ShellLinkMenu;
import org.omegat.util.Log;
import org.omegat.util.StaticUtils;
import org.openide.awt.Mnemonics;

public class MenuManager {
    private JMenu root = this.createLocalizedMenu(L10n.getFoldersMenuLabel());
    private JMenu currentProject;
    private JMenu userConfig;

    public MenuManager() {
        this.root.addMenuKeyListener(MenuHelper.getMenuKeyListener());
        this.root.addMenuListener(MenuHelper.getRootMenuListener());
        try {
            this.currentProject = new ShellLinkMenu(L10n.getProjectRootMenuLabel()).getMenu();
            this.root.add(this.currentProject);
        }
        catch (IOException ex) {
            Log.log(ex);
            return;
        }
        try {
            File confDir = new File(StaticUtils.getConfigDir());
            this.userConfig = new ShellLinkMenu(confDir, L10n.getUserConfigMenuLabel()).getMenu();
            this.root.add(this.userConfig);
        }
        catch (IOException ex) {
            Log.log(ex);
        }
        JMenuBar mainMenuBar = (JMenuBar)Core.getMainWindow().getMainMenu().getOptionsMenu().getParent();
        mainMenuBar.add((Component)this.root, mainMenuBar.getMenuCount() - 1);
    }

    public void createProjectItems() {
        File rootDir = new File(Core.getProject().getProjectProperties().getProjectRoot());
        try {
            new ShellLinkMenu(this.currentProject).link(rootDir);
        }
        catch (IOException ex) {
            Log.log(ex);
        }
    }

    public void removeAllProjectItems() {
        new ShellLinkMenu(this.currentProject).unlink();
    }

    private JMenu createLocalizedMenu(String labelString) {
        JMenu m = new JMenu();
        Mnemonics.setLocalizedText((AbstractButton)m, (String)labelString);
        return m;
    }
}

