#!/cygdrive/c/Perl/bin/perl
#
# ./diff.pl [file1 [file2]]
#   nicoStat.pl で保存した２つのcsvファイルの差を出力する
#   file2の方をより新しいcsvファイルにすること
#
#   file2 を省略した場合、Statディレクトリ内の最新のファイルが適用される。
#
#   file1, file2 を省略した場合、Statディレクトリから
#   最新ファイルをfile2、２番目に新しいファイルをfile1とする。
#
# ＜更新履歴＞

# ver.0.19 (2012/11/01)
#   - 音DL数に対応した。
#   - データ取得日をファイルスタンプからではなくファイル名から求めるようにした
#     $getDateFromFName = 0;にすれば以前の状態に戻る
#
# 2011/06/24
#   - 再生、コメント、マイリストの総数を最後に出力するようにした。
#
# ver.0.13 (2010/11/03)
#   - ppを通すためスクリプトの漢字コードをutf-8にした。
# ver.0.12 (2010/05/07)
#   - 動画ID(nicoStat-0.12～)でdiffを取るようにした。

# 結果ファイルのあるディレクトリを指定
our $resultDir = "./Stat";

# 1...ファイル名からデータ取得日を得る(ver0.19以降)
# 0...ファイルスタンプの日付からデータ取得日を得る(ver.0.19以前)
our $getDateFromFName = 1;

# useID=0...ver.0.11以前と互換(動画タイトルをdiffのIDとして使う)
# useID=1...ver.0.12以降。動画のID番号をdiffのIDとして使う。
our $useID = 1;

# 引数処理。入力ファイル指定
my @file = @ARGV;
if (@ARGV == 0){
  @file = setInFile (2);
} elsif (@ARGV == 1){
  $file[0] = setInFile (1);
  $file[1] = $ARGV[0];
} elsif (@ARGV > 2){
  print STDERR "usage: $0 [file1 [file2]]\n";
  exit 1;
}
print "from: $file[1]\n";
print "to  : $file[0]\n";

# file1をハッシュに読み込む
open (F1, $file[1]) || die "error: $file[1]: $!";
my %data1 = ();
while (<F1>){
  s/(\r|\n)//g;
  my @d = split /,/;  # 再生数,コメント数,マイリスト数,タイトル,(ID,音DL数)

  $useID = 0 if @d == 4;  # ver.0.11以前のcsvファイルだった場合

  if ($useID) {
    # （ver.0.12以降）動画IDをkeyにする
    $key = $d[4];
  } else {
    # （ver.0.11以前）動画タイトルをkeyにする

    # タイトル重複への対応
    my $c = 2;
    if (exists $data1{$d[3]}) {
      while (exists $data1{"$d[3]-$c"}) {
        $c++;
      }
      $d[3] = "$d[3]-$c";
    }
    $key = $d[3];
  }

  $data1{$key}{'playNum'}   = $d[0];
  $data1{$key}{'commNum'}   = $d[1];
  $data1{$key}{'mylistNum'} = $d[2];
  $data1{$key}{'title'}     = $d[3];
  if (@d >= 6){
    $data1{$key}{'dlNum'} = $d[5];
  } else {
    $data1{$key}{'dlNum'} = 0;
  }
}
close F1;

# file2を読んでfile1と違うもののみ表示する
open (F2, $file[0]) || die "error: $file[0]: $!";
my %data2 = ();
my ($playSum, $commSum, $mylistSum, $dlSum) = (0,0,0,0);
my ($playDiffSum, $commDiffSum, $mylistDiffSum, $dlDiffSum) = (0,0,0,0);
print "play\t(diff)\tcomment\t(diff)\tmylist\t(diff)\tdownld\t(diff)\ttitle\n";
while (<F2>){
  s/(\r|\n)//g;
  my @d = split /,/;  # 再生数,コメント数,マイリスト数,タイトル,(ID,音DL数)
  $d[5] = 0 unless (@d >= 6);   # もし音DL数のエントリがなければ0を入れる

  if ($useID){
    # （ver.0.12以降）動画IDをkeyにする
    $key = $d[4];
  } else {
    # （ver.0.11以前）動画タイトルをkeyにする
    # タイトル重複
    my $c = 2;
    if (exists $data2{$d[3]}) {
      while (exists $data2{"$d[3]-$c"}) {
        $c++;
      }
      $d[3] = "$d[3]-$c";
    }
    $data2{$d[3]} = 1;
    $key = $d[3];
  }

  my $play   = $d[0] - $data1{$key}{'playNum'};
  my $comm   = $d[1] - $data1{$key}{'commNum'};
  my $mylist = $d[2] - $data1{$key}{'mylistNum'};
  my $dl     = $d[5] - $data1{$key}{'dlNum'};

  $playSum   += $d[0];
  $commSum   += $d[1];
  $mylistSum += $d[2];
  $dlSum     += $d[5];

  #出力
  if ($play || $comm || $mylist){
    my $out = '';
    $out .= sprintf("%7d\t", $d[0]);
    $out .= sprintf("%+d", $play) if ($play != 0);
    $playDiffSum += $play;

    $out .= sprintf("\t%7d\t", $d[1]);
    $out .= sprintf("%+d", $comm) if ($comm != 0);
    $commDiffSum += $comm;

    $out .= sprintf("\t%7d\t", $d[2]);
    $out .= sprintf("%+d", $mylist) if ($mylist != 0);
    $mylistDiffSum += $mylist;

    $out .= sprintf("\t%7d\t", $d[5]);
    $out .= sprintf("%+d", $dl) if ($dl != 0);
    $dlDiffSum += $dl;

    $out = "$out\t$d[3]\n";

    print $out;
  }
}
close F2;

# 合計出力
printf("%7d\t%+d\t%7d\t%+d\t%7d\t%+d\t%7d\t%+d\n",
  $playSum, $playDiffSum, $commSum, $commDiffSum, 
  $mylistSum, $mylistDiffSum, $dlSum, $dlDiffSum);


#---------------------------
# 引数でファイル指定が無い場合、Statディレクトリ下の
# 更新日付の新しいファイルを入力ファイルとする
#
sub setInFile {
  my ($fileNum) = @_;

  opendir (DIR, $resultDir) || die "error: can not open $resultDir\n";
  my @allFiles = grep {/.(csv|CSV)$/} (readdir DIR);
  closedir DIR;
 
  my %new1 = ('file' => '', 'mtime' => 0);
  my %new2 = ('file' => '', 'mtime' => 0);
  foreach my $file (@allFiles) {
    if ($getDateFromFName){
      if ($new1{'file'} lt $file){
        $new2{'file'}  = $new1{'file'};
        $new1{'file'}  = $file;
      }
      elsif ($new2{'file'} lt $file){
        $new2{'file'}  = $file;
      }
    } else {
      $mtime = (stat "$resultDir/$file")[9];
      if ($new1{'mtime'} < $mtime){
        $new2{'mtime'} = $new1{'mtime'};
        $new2{'file'}  = $new1{'file'};
        $new1{'mtime'} = $mtime;
        $new1{'file'}  = $file;
      }
      elsif ($new2{'mtime'} < $mtime){
        $new2{'mtime'} = $mtime;
        $new2{'file'}  = $file;
      }
    }
  }

  if ($fileNum == 2){
    return ("$resultDir/$new1{'file'}", "$resultDir/$new2{'file'}");
  } else {
    return "$resultDir/$new1{'file'}";
  }
}
