/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.awt.GraphicsEnvironment;
import java.awt.event.KeyEvent;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.util.Log;

public class StaticUtils {
    private static final String WINDOWS_CONFIG_DIR = "\\OmegaT\\";
    private static final String UNIX_CONFIG_DIR = "/.omegat/";
    private static final String OSX_CONFIG_DIR = "/Library/Preferences/OmegaT/";
    private static final String SCRIPT_DIR = "script";
    public static final char TAG_REPLACEMENT = '\b';
    private static String m_configDir = null;
    private static String m_scriptDir = null;
    private static final String CVS_SVN_FOLDERS = "(CVS)|(.svn)|(_svn)";
    private static final Pattern IGNORED_FOLDERS = Pattern.compile("(CVS)|(.svn)|(_svn)");
    private static String INSTALLDIR = null;

    public static boolean isKey(KeyEvent e, int code, int modifiers) {
        return e.getKeyCode() == code && e.getModifiers() == modifiers;
    }

    public static void buildFileList(List<String> lst, File rootDir, boolean recursive) {
        File[] flist = null;
        try {
            flist = rootDir.listFiles();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (flist == null) {
            return;
        }
        for (File file : flist) {
            if (file.isDirectory()) continue;
            lst.add(file.getAbsolutePath());
        }
        if (recursive) {
            for (File file : flist) {
                if (!StaticUtils.isProperDirectory(file)) continue;
                StaticUtils.buildFileList(lst, file, true);
            }
        }
    }

    public static void buildDirList(List<String> lst, File rootDir) {
        File[] flist;
        for (File file : flist = rootDir.listFiles()) {
            if (!StaticUtils.isProperDirectory(file)) continue;
            lst.add(file.getAbsolutePath());
            StaticUtils.buildDirList(lst, file);
        }
    }

    public static String[] getFontNames() {
        GraphicsEnvironment graphics = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphics.getAvailableFontFamilyNames();
    }

    private static boolean isProperDirectory(File file) {
        if (file.isDirectory()) {
            Matcher directoryMatch = IGNORED_FOLDERS.matcher(file.getName());
            return !directoryMatch.matches();
        }
        return false;
    }

    public static String makeValidXML(char c) {
        switch (c) {
            case '&': {
                return "&amp;";
            }
            case '>': {
                return "&gt;";
            }
            case '<': {
                return "&lt;";
            }
            case '\"': {
                return "&quot;";
            }
        }
        return String.valueOf(c);
    }

    public static String entitiesToCharacters(String text) {
        if (text.indexOf("&gt;") >= 0) {
            text = text.replaceAll("&gt;", ">");
        }
        if (text.indexOf("&lt;") >= 0) {
            text = text.replaceAll("&lt;", "<");
        }
        if (text.indexOf("&quot;") >= 0) {
            text = text.replaceAll("&quot;", "\"");
        }
        if (text.indexOf("&amp;") >= 0) {
            text = text.replaceAll("&amp;", "&");
        }
        return text;
    }

    public static String makeValidXML(String plaintext) {
        StringBuffer out = new StringBuffer();
        String text = StaticUtils.fixChars(plaintext);
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            out.append(StaticUtils.makeValidXML(c));
        }
        return out.toString();
    }

    public static String compressSpaces(String str) {
        int strlen = str.length();
        StringBuffer res = new StringBuffer(strlen);
        boolean wasspace = true;
        for (int i = 0; i < strlen; ++i) {
            char ch = str.charAt(i);
            boolean space = Character.isWhitespace(ch);
            if (space) {
                if (wasspace) continue;
                wasspace = true;
                continue;
            }
            if (wasspace && res.length() > 0) {
                res.append(' ');
            }
            res.append(ch);
            wasspace = false;
        }
        return res.toString();
    }

    private static String classPathElement(String fullcp, int posInsideElement) {
        int semicolon1 = fullcp.lastIndexOf(File.pathSeparatorChar, posInsideElement);
        int semicolon2 = fullcp.indexOf(File.pathSeparatorChar, posInsideElement);
        if (semicolon1 < 0) {
            semicolon1 = -1;
        }
        if (semicolon2 < 0) {
            semicolon2 = fullcp.length();
        }
        return fullcp.substring(semicolon1 + 1, semicolon2);
    }

    private static String tryThisClasspathElement(String cp, String ending) {
        try {
            int pos = cp.indexOf(ending);
            if (pos >= 0) {
                String path = StaticUtils.classPathElement(cp, pos);
                path = path.substring(0, path.indexOf(ending));
                return path;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String installDir() {
        return "";
    }

    public static String getConfigDir() {
        return m_configDir;
    }

    public static String getScriptDir() {
        if (m_scriptDir != null) {
            return m_scriptDir;
        }
        m_scriptDir = StaticUtils.getConfigDir() + SCRIPT_DIR + File.separator;
        try {
            boolean created;
            File dir = new File(m_scriptDir);
            if (!dir.exists() && !(created = dir.mkdirs())) {
                Log.logErrorRB("SU_SCRIPT_DIR_CREATE_ERROR", new Object[0]);
                m_scriptDir = StaticUtils.getConfigDir();
            }
        }
        catch (SecurityException e) {
            m_scriptDir = StaticUtils.getConfigDir();
            Log.logErrorRB("SU_SCRIPT_DIR_CREATE_ERROR", new Object[0]);
            Log.log(e.toString());
        }
        return m_scriptDir;
    }

    public static boolean onMacOSX() {
        String os;
        try {
            os = System.getProperty("os.name");
        }
        catch (SecurityException e) {
            return false;
        }
        return os.equals("Mac OS X");
    }

    public static String stripProtectedParts(String str, SourceTextEntry ste) {
        return "";
    }

    public static String stripXmlTags(String xml) {
        return "";
    }

    public static boolean equal(String one, String two) {
        return one == null && two == null || one != null && one.equals(two);
    }

    public static String uuencode(byte[] buf) {
        if (buf.length <= 0) {
            return new String();
        }
        StringBuffer res = new StringBuffer();
        res.append(buf[0]);
        for (int i = 1; i < buf.length; ++i) {
            res.append('#');
            res.append(buf[i]);
        }
        return res.toString();
    }

    public static byte[] uudecode(String buf) {
        String[] bytes = buf.split("#");
        byte[] res = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            try {
                res[i] = Byte.parseByte(bytes[i]);
                continue;
            }
            catch (NumberFormatException e) {
                res[i] = 0;
            }
        }
        return res;
    }

    public static String makeFilenameRelative(String filename, String path) {
        if (filename.toLowerCase().startsWith(path.toLowerCase())) {
            return filename.substring(path.length());
        }
        return filename;
    }

    public static String escapeNonRegex(String text) {
        return StaticUtils.escapeNonRegex(text, true);
    }

    public static String escapeNonRegex(String text, boolean escapeWildcards) {
        text = text.replaceAll("\\\\", "\\\\\\\\");
        text = text.replace("$", "\\$");
        String escape = "^.+[]{}()&|-:=!<>";
        for (int i = 0; i < escape.length(); ++i) {
            text = text.replaceAll("\\" + escape.charAt(i), "\\\\" + escape.charAt(i));
        }
        if (escapeWildcards) {
            text = text.replaceAll("\\?", "\\\\?");
            text = text.replaceAll("\\*", "\\\\*");
        } else {
            text = text.replaceAll("\\?", "\\\\S");
            text = text.replaceAll("\\*", "\\\\S*");
        }
        return text;
    }

    public static String format(String str, Object ... arguments) {
        str = str.replaceAll("'", "''");
        return MessageFormat.format(str, arguments);
    }

    public static String downloadFileToString(String urlString) throws IOException {
        URLConnection urlConn = null;
        InputStream in = null;
        URL url = new URL(urlString);
        urlConn = url.openConnection();
        urlConn.setConnectTimeout(10000);
        in = urlConn.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        return new String(out.toByteArray(), "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFileToDisk(String address, String filename) throws MalformedURLException {
        URLConnection urlConn = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            int numRead;
            URL url = new URL(address);
            urlConn = url.openConnection();
            in = urlConn.getInputStream();
            out = new BufferedOutputStream(new FileOutputStream(filename));
            byte[] byteBuffer = new byte[1024];
            while ((numRead = in.read(byteBuffer)) != -1) {
                out.write(byteBuffer, 0, numRead);
            }
        }
        catch (IOException ex) {
            Log.logErrorRB("IO exception", new Object[0]);
            Log.log(ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public static void extractFileFromJar(String archive, List<String> filenames, String destination) throws IOException {
        JarFile jar = new JarFile(archive);
        Enumeration<JarEntry> entryEnum = jar.entries();
        while (entryEnum.hasMoreElements()) {
            JarEntry file = entryEnum.nextElement();
            if (!filenames.contains(file.getName())) continue;
            File f = new File(destination + File.separator + file.getName());
            InputStream in = jar.getInputStream(file);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
            byte[] byteBuffer = new byte[1024];
            int numRead = 0;
            while ((numRead = in.read(byteBuffer)) != -1) {
                out.write(byteBuffer, 0, numRead);
            }
            in.close();
            out.close();
        }
        jar.close();
    }

    public static String fixChars(String str) {
        char[] result = new char[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            int c = str.charAt(i);
            if (c < 32) {
                if (c != 9 && c != 10 && c != 13) {
                    c = 32;
                }
            } else if (!(c >= 32 && c <= 55295 || c >= 57344 && c <= 65533 || c >= 65536 && c <= 0x10FFFF)) {
                c = 32;
            }
            result[i] = c;
        }
        return new String(result);
    }

    public static String[] parseCLICommand(String cmd) {
        if ((cmd = cmd.trim()).length() == 0) {
            return new String[]{""};
        }
        StringBuilder arg = new StringBuilder();
        ArrayList<String> result = new ArrayList<String>();
        boolean noQuote = false;
        int currentQuote = 0;
        for (int i = 0; i < cmd.length(); ++i) {
            int c = cmd.charAt(i);
            if (c == currentQuote) {
                currentQuote = 0;
                continue;
            }
            if (c == 34 && currentQuote == 0) {
                currentQuote = 34;
                continue;
            }
            if (c == 39 && currentQuote == 0) {
                currentQuote = 39;
                continue;
            }
            if (c == 92 && i + 1 < cmd.length()) {
                char next = cmd.charAt(i + 1);
                if (currentQuote == 0 && Character.isWhitespace(next) || currentQuote == 34 && next == '\"') {
                    arg.append(next);
                    ++i;
                    continue;
                }
                arg.append((char)c);
                continue;
            }
            if (Character.isWhitespace((char)c) && currentQuote == 0) {
                if (arg.length() <= 0) continue;
                result.add(arg.toString());
                arg = new StringBuilder();
                continue;
            }
            arg.append((char)c);
        }
        if (arg.length() > 0) {
            result.add(arg.toString());
        }
        return result.toArray(new String[0]);
    }

    public static class TagComparator
    implements Comparator<String> {
        private final String source;

        public TagComparator(String source) {
            this.source = source;
        }

        @Override
        public int compare(String tag1, String tag2) {
            int index2;
            if (tag1.equals(tag2)) {
                return 0;
            }
            if (tag1.startsWith(tag2)) {
                return -1;
            }
            if (tag2.startsWith(tag1)) {
                return 1;
            }
            int index1 = this.source.indexOf(tag1);
            if (index1 == (index2 = this.source.indexOf(tag2))) {
                int len2;
                int len1 = tag1.length();
                if (len1 > (len2 = tag2.length())) {
                    return -1;
                }
                if (len2 > len1) {
                    return 1;
                }
                return tag1.compareTo(tag2);
            }
            return index1 > index2 ? 1 : -1;
        }
    }
}

