require 'rake/clean'
require 'yaml'

CLOBBER.include 'rumix.{exe,exy}'

task :default => 'rumix.exe'

rule '.exe' => '.exy' do |task|
	sh "exerb -v #{task.source}"
end

file "rumix.exy" => (FileList['*.rb'] + FileList['lib/**/*.rb'] + ['__wxautoload.rb'] + FileList['*.xrc']) do |task|
	sh "ruby -Ku -r exerb/mkexy rumix.rb --test-run"

	data = YAML.load_file(task.name)
	data['general']['core'] = 'gui'
	data['file']['msvcr71.dll'] = {'type' => 'dynamic-library'}
	data['file']['msvcp71.dll'] = {'type' => 'dynamic-library'}
	data['file']['zlib1.dll'] = {'type' => 'dynamic-library'}
	
	data['resource'] ||= {}
	data['resource']['icon'] = []
	[4, 8].each do |color|
		[48, 36, 32, 16].each do |size|
			data['resource']['icon'] << {'file' => 'res/image/ce_jacas/ruby_ns.ico', 'width' => size, 'height' => size, 'color' => color}
		end
	end
	
	open(task.name, 'w'){|f| f.write(data.to_yaml)}
end


# This file is generated because Exerb and WxRuby are not friendly.
# (refer to 'Load in all the class extension methods' in lib/wx.rb)
file '__wxautoload.rb' do |task|
	list = nil
	cd 'lib' do
		list = Dir.glob('wx/**/*.rb')
	end
		
	open(task.name, 'w'){|f|
		f.puts "# This file was generated by Rake."
		f.puts "require 'wx'"
		list.each do |name|
			f.puts "require '#{name}'"
		end
	}
	
	puts "#{task.name} maked."
end
