require 'rake/clean'

CLEAN.include 'intermediates'
CLEAN.include 'zip_archives_info.yml'
CLOBBER.include '*.zip'
CLOBBER.include '*.gem'

SEVEN_ZIP_COMMAND = '7z'
SVN_COMMAND = 'svn'
WGET_COMMAND = 'wget'

DOWNLOAD_DIR = 'downloaded/'
DEVKIT_OUTPUT_DIR = File.join(DOWNLOAD_DIR, 'devkit/')
CLOBBER.include DOWNLOAD_DIR

DOWNLOAD_TARGETS = []
DOWNLOAD_TARGETS << ['ruby-2.0.0-x64.7z', 'http://cdn.rubyinstaller.org/archives/2.0.0-p0/ruby-2.0.0-p0-x64-mingw32.7z']
DOWNLOAD_TARGETS << ['ruby-2.0.0-i386.7z', 'http://cdn.rubyinstaller.org/archives/2.0.0-p0/ruby-2.0.0-p0-i386-mingw32.7z']
DOWNLOAD_TARGETS << ['ruby-1.9.3.7z', 'http://rubyforge.org/frs/download.php/76055/ruby-1.9.3-p194-i386-mingw32.7z']
DOWNLOAD_TARGETS << ['ruby-1.8.7.7z', 'http://rubyforge.org/frs/download.php/76278/ruby-1.8.7-p370-i386-mingw32.7z']

DOWNLOAD_TARGETS << ['nyaos.zip', 'http://www.nyaos.org/index.cgi?p=DOWNLOAD;f=nyaos-3.3.6_1-win.zip']
DOWNLOAD_TARGETS << ['exerb.zip', 'http://sourceforge.jp/frs/redir.php?m=iij&f=%2Fexerb%2F54369%2Fexerb-5.4.0.zip']
#DOWNLOAD_TARGETS << ['visualuruby.zip', 'ftp://ftp.ruby-lang.org/pub/ruby/binaries/mswin32/ext/vruby-061102-i386-mswin32-1.8.zip']
#DOWNLOAD_TARGETS << ['swin.zip', 'ftp://ftp.ruby-lang.org/pub/ruby/binaries/mswin32/ext/vrswin-060205-i386-mswin32-1.8.zip']
DOWNLOAD_TARGETS << ['ckw-mod.zip', 'http://www.vesta.dti.ne.jp/~tsato/arc/ckw64_110422.zip']
DOWNLOAD_TARGETS << ['devkit-tdm32.exe', 'https://github.com/downloads/oneclick/rubyinstaller/DevKit-tdm-32-4.5.2-20111229-1559-sfx.exe']
DOWNLOAD_TARGETS << ['devkit-mingw64-32.exe', 'http://cdn.rubyinstaller.org/archives/devkits/DevKit-mingw64-32-4.7.2-20130224-1151-sfx.exe']
DOWNLOAD_TARGETS << ['devkit-mingw64-64.exe', 'http://cdn.rubyinstaller.org/archives/devkits/DevKit-mingw64-64-4.7.2-20130224-1432-sfx.exe']
DOWNLOAD_TARGETS << ['sqlite3.zip', 'http://www.sqlite.org/sqlite-dll-win32-x86-3071300.zip', nil, true]
#DOWNLOAD_TARGETS << ['ansicon.zip', 'http://adoxa.110mb.com/ansicon/dl.php?f=ansicon']

DOWNLOAD_TARGETS << ['rubyrefm-remix-1.9.3.zip', 'http://sourceforge.jp/frs/redir.php?m=iij&f=%2Fruby-refm-remix%2F56391%2Frubyrefm-remix-1.9.3.zip', nil, true]
#DOWNLOAD_TARGETS << ['rubyrefm-remix-1.9.3-secondlife_blue.zip', 'http://sourceforge.jp/frs/redir.php?m=iij&f=%2Fruby-refm-remix%2F55903%2Frubyrefm-remix-1.9.3-secondlife_blue.zip', nil, true]
#DOWNLOAD_TARGETS << ['rubyrefm-remix-1.9.3-secondlife_blue_plus_blank.zip', 'http://sourceforge.jp/frs/redir.php?m=iij&f=%2Fruby-refm-remix%2F55903%2Frubyrefm-remix-1.9.3-secondlife_blue_plus_blank.zip', nil, true]
DOWNLOAD_TARGETS << ['rubyrefm-remix-1.8.7.zip', 'http://sourceforge.jp/frs/redir.php?m=iij&f=%2Fruby-refm-remix%2F56391%2Frubyrefm-remix-1.8.7.zip', nil, true]
#DOWNLOAD_TARGETS << ['rubyrefm-remix-1.8.7-secondlife_blue.zip', 'http://sourceforge.jp/frs/redir.php?m=iij&f=%2Fruby-refm-remix%2F55903%2Frubyrefm-remix-1.8.7-secondlife_blue.zip', nil, true]
#DOWNLOAD_TARGETS << ['rubyrefm-remix-1.8.7-secondlife_blue_plus_blank.zip', 'http://sourceforge.jp/frs/redir.php?m=iij&f=%2Fruby-refm-remix%2F55903%2Frubyrefm-remix-1.8.7-secondlife_blue_plus_blank.zip', nil, true]
DOWNLOAD_TARGETS << ['rubyrefm-1.9.3.chm', 'http://doc.okkez.net/archives/201208/ruby-refm-1.9.3-20120829.chm']
DOWNLOAD_TARGETS << ['rubyrefm-1.8.7.chm', 'http://doc.okkez.net/archives/201208/ruby-refm-1.8.7-20120829.chm']

DOWNLOAD_TARGETS << ['bitclust', 'http://jp.rubyist.net/svn/rurema/bitclust/trunk', :svn]
DOWNLOAD_TARGETS << ['doctree', 'http://jp.rubyist.net/svn/rurema/doctree/trunk', :svn]
#DOWNLOAD_TARGETS << ['bitclust', 'http://jp.rubyist.net/svn/rurema/bitclust/trunk@5159', :svn]
#DOWNLOAD_TARGETS << ['doctree', 'http://jp.rubyist.net/svn/rurema/doctree/trunk@5437', :svn]

DOWNLOAD_GEMS = %w(pik rake facets sqlite3 ocra rdoc-data bundler bitclust-core refe2 rack)
#DOWNLOAD_GEMS = %w(rdoc json pik rake facets nokogiri sqlite3 ocra rdoc-data win32console tenjin progressbar wxruby rack msgpack bundler bitclust-core refe2)



directory DOWNLOAD_DIR
directory DEVKIT_OUTPUT_DIR

build_targets = []
download_dests = []
DOWNLOAD_TARGETS.each do |dest_name, url, using_tool, download_only|
	if download_only then
		dest_path = dest_name
		build_targets << dest_path
	else
		dest_path = File.join(DOWNLOAD_DIR, dest_name)
		download_dests << dest_path
	end
	
	desc "download #{dest_path} by wget"
	file dest_path => DOWNLOAD_DIR do
		case using_tool
		when :svn
			# by svn export
			sh %Q|#{SVN_COMMAND} export #{url} #{dest_path}|
		else
			# by wget
			user_agent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; ja) Opera 9.26"
			
			begin
				sh %Q|#{WGET_COMMAND} --no-check-certificate -O #{dest_path} -U "#{user_agent}" "#{url}"|
			ensure
				if File.exist?(dest_path) and File.size(dest_path) == 0 then
					File.unlink(dest_path)
				end
			end
		end
	end
end

download_gem_task_names = []
DOWNLOAD_GEMS.each do |gem_name|
	found_gem_paths = Dir.glob("#{gem_name}-*.gem")
	if not found_gem_paths.empty? then
		# if found, use file task
		desc "fetch gem, #{found_gem_paths.first}"
		file found_gem_paths.first do
			sh "gem fetch #{gem_name}"
		end 
		download_gem_task_names << found_gem_paths.first
	else
		# if not found, use standard rake task
		task_name = "gem_#{gem_name}".to_sym
		desc "fetch gem, #{gem_name}"
		task task_name do
			sh "gem fetch -V #{gem_name}"
		end 
		download_gem_task_names << task_name
	end
end

desc "download all base packages"
task :download => [DEVKIT_OUTPUT_DIR] + download_dests + download_gem_task_names


refmdb_targets = []
ruby_versions = ['2.0.0', '1.9.3', '1.8.7']
ruby_versions.each do |ver|
	db_dir_name = "downloaded/refmdb-#{ver}"
	
	desc "build refm doc-db"
	file db_dir_name => ['downloaded/bitclust', 'downloaded/doctree'] do
		sh "ruby -I downloaded/bitclust/lib downloaded/bitclust/bin/bitclust -d #{db_dir_name} init version=#{ver} encoding=utf-8"
		sh "ruby -I downloaded/bitclust/lib downloaded/bitclust/bin/bitclust -d #{db_dir_name} update --stdlibtree=downloaded/doctree/refm/api/src"
		sh "ruby -I downloaded/bitclust/lib downloaded/bitclust/bin/bitclust -d #{db_dir_name} --capi update downloaded/doctree/refm/capi/src/*"
	end
	
	file "refmdb-#{ver}.zip" => db_dir_name do |task|
		src_dir = task.prerequisites.first
		dest_abs_path = File.expand_path(task.name)
		cd src_dir do
			sh "#{SEVEN_ZIP_COMMAND} a #{dest_abs_path} ."
		end
	end
	refmdb_targets << "refmdb-#{ver}.zip"
	build_targets << "refmdb-#{ver}.zip"
end


ruby_types = ['2.0.0-i386', '2.0.0-x64', '1.9.3', '1.8.7']
ruby_types.each do |type|

	desc "-"
	file "downloaded/ruby-#{type}" => "downloaded/ruby-#{type}.7z" do |task|
		sh "#{SEVEN_ZIP_COMMAND} x #{task.prerequisites.first} -o#{task.name}"
	end
	
	desc "-"
	file "ruby-#{type}.zip" => "downloaded/ruby-#{type}" do |task|
		src_dir = Dir.glob(File.join(task.prerequisites.first, "ruby-*-mingw32")).first
		dest_abs_path = File.expand_path(task.name)
		cd src_dir do
			sh "#{SEVEN_ZIP_COMMAND} a #{dest_abs_path} ."
		end
	end

	build_targets << "ruby-#{type}.zip"

end

desc "-"
task :db => refmdb_targets

devkit_editions = %w(tdm32 mingw64-32 mingw64-64)
devkit_editions.each do |edition|
	desc "-"
	file "devkit-#{edition}.zip" => "downloaded/devkit-#{edition}" do |task|
			dest_abs_path = File.expand_path(task.name)
			cd task.prerequisites.first do
				sh "#{SEVEN_ZIP_COMMAND} a #{dest_abs_path} ."
			end
	end

	build_targets << "devkit-#{edition}.zip"
end

Target = Struct.new(:name, :src_archive_name, :compress_root_dir_pattern, :compress_target_list, :exclude_target_list, :extra_compress_files)
TARGET_DATA = []
TARGET_DATA << Target.new('exerb',               'exerb.zip',              'exerb-*',   nil)
TARGET_DATA << Target.new('nyaos',               'nyaos.zip',              nil,         nil,       nil, ['intermediates/nyaos/_nya_rumix'])
TARGET_DATA << Target.new('ckw-mod',             'ckw-mod.zip',            nil,         'ckw.cfg', nil, ['downloaded/ckw-mod/x86/ckw.exe'])
TARGET_DATA << Target.new('ckw-mod-document',    'ckw-mod.zip',            nil,         '*.txt', nil)
#TARGET_DATA << Target.new('rubyrefm-old-1.8.7',  'rubyrefm-old-1.8.7.zip', nil,         nil)
TARGET_DATA << Target.new('bitclust')
#TARGET_DATA << Target.new('ansicon',         'ansicon.zip', 'x86')

file 'downloaded/ckw-mod/x86/ckw.exe' => 'downloaded/ckw-mod'

TARGET_DATA.each do |target|
	if target.src_archive_name then
		desc "-"
		file "downloaded/#{target.name}" => "downloaded/#{target.src_archive_name}" do |task|
			# delete if already exists
			rm task.name if File.exist?(task.name)
			sh "#{SEVEN_ZIP_COMMAND} x #{task.prerequisites.first} -o#{task.name}"
		end
	end
	
	desc "-"
	file "#{target.name}.zip" => ["downloaded/#{target.name}"] + (target.extra_compress_files || []) do |task|
		# delete if already exists
		rm task.name if File.exist?(task.name)
		
		# decide src dir
		if target.compress_root_dir_pattern then
			src_dir = Dir.glob(File.join(task.prerequisites.first, target.compress_root_dir_pattern)).first
		else
			src_dir = task.prerequisites.first
		end
		
		# archiving
		dest_abs_path = File.expand_path(task.name)
		cd src_dir do
			excluding_opt = (target.exclude_target_list ? "-x!#{target.exclude_target_list}" : '')
			sh "#{SEVEN_ZIP_COMMAND} a #{excluding_opt} #{dest_abs_path} #{target.compress_target_list || '.'}"
		end
		
		# add extra files to archive
		(target.extra_compress_files || []).each do |extra_src|
			cd File.dirname(extra_src) do
				sh "#{SEVEN_ZIP_COMMAND} a #{dest_abs_path} #{File.basename(extra_src)}"
			end
		end
	end
	
	build_targets << "#{target.name}.zip"
end


# generate nya configs
directory 'intermediates/nyaos'
file 'intermediates/nyaos/_nya_rumix' => ['nyaconfig/_nya_rumix', 'intermediates/nyaos'] do |task|
	cp 'nyaconfig/_nya_rumix', task.name
end


def get_zip_info(zip_path)
	require 'zipruby'
	re = {}
	re['file_count'] = 0
	re['size'] = 0
	re['comp_size'] = 0

	Zip::Archive.open(zip_path){|zip|
		
		zip.each do |file|
			re['file_count'] += 1
			re['size'] += file.size
			re['comp_size'] += file.comp_size
		end
	}
	
	re
end

def get_gem_info(gem_path)
	require 'rubygems/package'
	re = {}
	re['file_count'] = 0

	open(gem_path, 'rb'){|f|
		Gem::Package::TarReader.new(f){|tar_input|
			tar_input.each do |ent|
				re['file_count'] += 1
			end
		}
	}
	
	re
end

desc 'scan zip and gem archives file info'
task :scan => 'archives_info.yml'
file 'archives_info.yml' => FileList['*.{zip,gem}'] do |t|
	require 'yaml'
	re = {}
	t.prerequisites.each do |arc_path|
		puts "scanning #{arc_path}..."
		if arc_path =~ /\.gem$/ then
			re[arc_path] = get_gem_info(arc_path)
		else
			re[arc_path] = get_zip_info(arc_path)
		end
	end

	open(t.name, 'w:utf-8'){|f|
		f.write(re.to_yaml)
	}
	puts "create: #{t.name}"
end

desc "-"
task :build => build_targets + [:download, :scan]
task :default => :build
