require 'wx'

class MyApp < Wx::App
  private

  def on_init
    MyFrame.new.show
  end
end

class MyFrame < Wx::Frame
  private

  def initialize
    super(nil, -1, 'Frame sample')
    create_menu
    create_status_bar
    set_status_text('Welcome!')
    toolbar = create_tool_bar
    #toolbar.add_tool(Wx::ID_ABOUT, 'About', nil,'About this application')
    # ID_ABOUTcreate_menuŃCxgo^ς
    set_background_colour(Wx::LIGHT_GREY)
  end

  def create_menu
    menu_bar = Wx::MenuBar.new

    file_menu = Wx::Menu.new
    file_menu.append(Wx::ID_EXIT, '&Quit', 'Exit application')
    evt_menu Wx::ID_EXIT, :close
    menu_bar.append(file_menu, '&File')

    help_menu = Wx::Menu.new
    help_menu.append(Wx::ID_ABOUT, "&About...\tCtrl-A", 'Show about dialog')
    evt_menu Wx::ID_ABOUT, :on_about
    menu_bar.append(help_menu, '&Help')

    set_menu_bar(menu_bar)
  end

  def on_about
    about_info = Wx::AboutDialogInfo.new
    about_info.set_name('Frame sample')
    about_info.set_version('1.0.0')
    about_info.set_description('How to use Wx::Frame class')
    about_info.set_copyright('Copyright(C) 2008 Keigo Nakatani')
    about_info.add_developer('Keigo Nakatani')
    Wx::about_box(about_info)
  end
end

MyApp.new.main_loop