# encoding: utf-8

require 'rumix/registry'
include Rumix

describe Registry do
	TEMP_KEY = 'Software\\Rumix-RSP\\Temp'

	before do
		@reg = Registry.new(TEMP_KEY)
	end
	
	after do
		Registry::PRIMARY_KEY.create(TEMP_KEY) do |reg|
			reg.each do |name, type, value|
				reg.delete(name)
			end
		end
		
		Registry::PRIMARY_KEY.open(Registry::SUB_KEY) do |reg|
			reg.each_key do |name, wtime|
				if name == 'Temp' then
					reg.delete_key(name, true)
				end
			end
		end
	end
	
	it "::SUB_KEY == Software\\Rumix-RSP" do
		Registry::SUB_KEY.should == 'Software\\Rumix-RSP'
	end

	it "loads and stores." do
		@reg.install_path = 'c:\\rumix\\'
		@reg.store.should be_true
		
		@reg.clear.should be_equal(@reg)
		@reg.install_path.should be_nil
		
		@reg.load.should be_equal(@reg)
		@reg.install_path.should == 'c:\\rumix\\'
	end
	
	it "returns self after to clear, if no value." do
		@reg.load.should be_equal(@reg)
		@reg.install_path.should be_nil
	end
	
	it "failure if @install_path is nil."do
		@reg.store.should be_false
	end
end