# encoding: utf-8
#---------------------------------------------------------
# Rumix GUI Installer
#
# Author:   Dice
# License:  NYSL 0.9982 (http://www.kmonos.net/nysl/)
# URL:      http://ruby.morphball.net/rumix/
#-----------------------------------------------------------

$LOAD_PATH.unshift File.join(File.dirname(__FILE__), 'lib')

require 'win32ole'

def show_message_box(msg, title)
  wsh = WIN32OLE.new('WScript.Shell')
  wsh.Popup(msg, 0, title, 0 + 64 + 0x40000)
end

begin
	require 'rumix/config'
	require 'rumix/wx'

	if $LOADED_FEATURES.include?('exerb/mkexy.rb') then
		require 'uconv'
		Uconv.u8tosjis('test str')
		puts "- test run for Exerb -"
	else
		parsed_gui_options = Rumix::Widget::Wizard.parse_options(ARGV)

		Wx::App.run do
			wizard = Rumix::Widget::Wizard.new(parsed_gui_options, nil, :title => "Rumix #{Rumix::VERSION}")
			wizard.show_modal
			return false
		end
	end
rescue Exception
	open(File.join(File.dirname(ENV['OCRA_EXECUTABLE'], __FILE__), 'rumix_error.log'), 'w'){|f|
		f.puts $!.to_s
		f.puts $!.backtrace
	}


	show_message_box("システムエラーが発生しました。ご迷惑をおかけして申し訳ありません。\n実行ファイルと同じフォルダに出力されたrumix_error.logの内容を参照してください。", '内部エラー')


	
	raise $!
	
end
