module Rumix
	# タスクのグループ
	class TaskGroup
		attr_accessor :title, :child_tasks
		def initialize(title)
			@title = title
			@child_tasks = []
		end

		def weight
			@child_tasks.inject(0){|x, i| x + i}
		end

		def running_caption
			@child_tasks.first.running_caption
		end

		def run
			@child_tasks.each{|x| x.run}
		end
	end

	# タスク。インストール時に実行する処理を抽象化している
	class TaskBase
	end

	# zipファイルから必要なファイルをインストールするタスク
	class ZipInstallTask < TaskBase
		def initialize(software_title, arc_info, zip_file_name)
			super()
			@software_title = software_title
			@zip_file_name = zip_file_name
			@weight = get_zip_file_number(arc_info, zip_file_name)
		end

		def run(config, log_io, os_interface)
			os_interface.install_from_zip(@zip_file_name, config.dest_dir)
		end

		def task_title
			"#{@software_title}のインストール"
		end

		def running_caption
			"#{@software_title}をインストール中..."
		end

		private
		# 対象のzipファイル内のファイル数を取得
		def get_zip_file_number(arc_info, zip_file_name)
			n = (arc_info[zip_file_name] || {})['file_count'] 
			unless n then
				Kernel.raise "zip file not found - #{zip_file_name}"
			end

			return n
		end
	end

	# gem（複数）をインストールするタスク
	class GemInstallTask < TaskBase
		def initialize(gem_names, weight)
			super()
			@gem_names = gem_names
			@zip_file_name = zip_file_name
			@weight = get_zip_file_number(arc_info, zip_file_name)
		end

		def run(config, log_io, os_interface)
			osi.install_gems(@gem_names, :pik_enabled => true, &block)
		end

		def task_title
			"#{@software_title}のインストール"
		end

		def running_caption
			"#{@software_title}をインストール中..."
		end
	end


	# gem（複数）をインストールするタスク
	class GemInstallTask < TaskBase
		def initialize(gem_names, weight)
			super()
			@gem_names = gem_names
			@zip_file_name = zip_file_name
			@weight = get_zip_file_number(arc_info, zip_file_name)
		end

		def run(config, log_io, os_interface)
			osi.install_gems(@gem_names, :pik_enabled => true, &block)
		end

		def task_title
			"#{@software_title}のインストール"
		end

		def running_caption
			"#{@software_title}をインストール中..."
		end
	end

	# フリータスク。任意の処理を含めることができる
	class FreeTask < TaskBase
		attr_accessor :title, :running_caption, :weight

		def initialize(title, running_caption, weight, &proc)
			super(title, running_caption)
			@weight, @proc = weight, proc
		end

		def run
			@proc.call
		end
	end

end