package landminecraft.api.util;

import net.minecraft.block.Block;
import net.minecraft.world.World;

public class BlockSupporter
{
	private static BlockSupporter instance = new BlockSupporter();

	public boolean isBasicBlock(int par1)
	{
		if (par1 <= 0) {
			return false;
		} else {
			Block block = Block.blocksList[par1];
			return block != null && block.blockMaterial.isOpaque() && block.renderAsNormalBlock();
		}
	}

	public boolean hasSurroundedBlock(World par1World, int par2PosX, int par3PosY, int par4PosZ)
	{

		for(int i = 0;i < 6;i++){
			int var5 = par2PosX;
			int var6 = par3PosY;
			int var7 = par4PosZ;

			switch (i){
			case 0:
				--var6;
				break;
			case 1:
				++var6;
				break;
			case 2:
				--var7;
				break;
			case 3:
				++var7;
				break;
			case 4:
				--var5;
				break;
			case 5:
				++var5;
				break;
			}

			if(!this.isBasicBlock(par1World.getBlockId(var5, var6, var7))){
				return false;
			}
		}
		return true;
	}

	public static BlockSupporter instance(){
		return instance;
	}
}
