package landminecraft.api.tileentity;

import landminecraft.api.util.BlockSupporter;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileEntityLandMine extends TileEntity {

	public short id;
	public short metadata;

	@Override
	public void updateEntity() {
		int nx = 0;
		int ny = 0;
		int nz = 0;
		for (int var7 = 0; var7 < 6; var7++) {
			nx = this.xCoord;
			ny = this.yCoord;
			nz = this.zCoord;
			switch (var7)
			{
			case 0:
				nz--;
				break;
			case 1:
				nz++;
				break;
			case 2:
				nx--;
				break;
			case 3:
				nx++;
				break;
			case 4:
				ny--;
				break;
			case 5:
				ny++;
				break;
			}

			int id = this.worldObj.getBlockId(nx, ny, nz);
			TileEntity tileentity = this.worldObj.getBlockTileEntity(nx, ny, nz);
			if (tileentity != null && tileentity instanceof TileEntityLandMine) {
				this.id = ((TileEntityLandMine) tileentity).id;
				this.metadata = ((TileEntityLandMine) tileentity).metadata;
			} else if (BlockSupporter.instance().isBasicBlock(id)) {
				this.id = (short) id;
				this.metadata = (short) this.worldObj.getBlockMetadata(nx, ny, nz);
			}

			if (Block.blocksList[this.id] != null) {
				break;
			}
		}
	}

	@Override
	public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
		super.readFromNBT(par1NBTTagCompound);
		this.id = par1NBTTagCompound.getShort("ID");
		this.metadata = par1NBTTagCompound.getShort("Metadata");
	}

	@Override
	public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
		super.writeToNBT(par1NBTTagCompound);
		par1NBTTagCompound.setShort("ID", this.id);
		par1NBTTagCompound.setShort("Metadata", this.metadata);
	}

}
