package landminecraft.api.block;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class LandMineRidden extends LandMineBase
{

	public LandMineRidden(int id) {
		super(id);
	}

	public LandMineRidden(int id, Material material) {
		super(id, material);
	}

	@Override
	public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4)
	{
		float var5 = 0.005F;
		return AxisAlignedBB.getAABBPool().getAABB((double) par2, (double) par3, (double) par4, (double) (par2 + 1), (double) ((float) (par3 + 1) - var5), (double) (par4 + 1));
	}

	@Override
	public void onEntityCollidedWithBlock(World par1World, int par2, int par3, int par4, Entity par5Entity)
	{
		if (!par1World.isRemote) {
			this.onWalked(par1World, par2, par3, par4, par5Entity, par1World.getBlockMetadata(par2, par3, par4));
		}
	}

	protected abstract void onWalked(World par1World, int par2, int par3, int par4, Entity par5Entity, int par6);

}
