/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.plugin.moenizer.imageloader;

import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.omegat.plugin.moenizer.MoeConfig;
import org.omegat.plugin.moenizer.imageloader.IImageLoader;
import org.omegat.util.Log;

public class DefaultImageLoader
implements IImageLoader {
    private static final Pattern RE_HAS_IMAGE_EXTENSION = Pattern.compile(".+\\.(?:bmp|png|jpg|jpeg|gif)");
    private long interval = MoeConfig.getInterval();
    private Object[] sources = MoeConfig.getSources();
    private Object currentSource = null;
    private int sourceIndex = -1;
    protected BufferedImage image = null;

    public static boolean isAcceptable(Object source) {
        String name;
        if (source instanceof URL) {
            return true;
        }
        return source instanceof File && RE_HAS_IMAGE_EXTENSION.matcher(name = ((File)source).getName().toLowerCase()).matches();
    }

    @Override
    public boolean availableNext() {
        boolean ret = false;
        if (this.sources.length != 0) {
            if (this.sources.length == 1) {
                if (this.currentSource == null || this.interval > 0L) {
                    this.currentSource = this.sources[0];
                    ret = true;
                }
            } else {
                this.currentSource = this.getCircularNextSource();
                ret = true;
            }
        }
        return ret;
    }

    @Override
    public BufferedImage getNextImage() {
        return this.image;
    }

    @Override
    public void readyForNextImage() {
        this.image = null;
        try {
            if (this.currentSource != null) {
                if (this.currentSource instanceof File) {
                    this.image = ImageIO.read((File)this.currentSource);
                } else if (this.currentSource instanceof URL) {
                    this.image = ImageIO.read((URL)this.currentSource);
                } else {
                    this.removeCurrentSource();
                }
            }
        }
        catch (Exception ex) {
            Log.log((Throwable)ex);
            this.removeCurrentSource();
        }
    }

    @Override
    public long getNextInterval() {
        return this.interval;
    }

    private Object getCircularNextSource() {
        ++this.sourceIndex;
        if (this.sourceIndex >= this.sources.length) {
            this.sourceIndex = 0;
        }
        return this.sources[this.sourceIndex];
    }

    private void removeCurrentSource() {
        if (this.sourceIndex >= 0 && this.sourceIndex < this.sources.length) {
            this.sourceIndex = 0;
        } else {
            Object[] newSources = new Object[this.sources.length - 1];
            for (int i = 0; i < this.sources.length; ++i) {
                if (i == this.sourceIndex) continue;
                if (i < this.sourceIndex) {
                    newSources[i] = this.sources[i];
                    continue;
                }
                newSources[i - 1] = this.sources[i];
            }
            this.sources = newSources;
            if (this.sourceIndex >= this.sources.length) {
                this.sourceIndex = 0;
            }
        }
    }
}

