/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.plugin.moenizer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.util.LFileCopy;
import org.omegat.util.Log;

public class MoeUtil {
    private static final Pattern RE_URL_IN_SHORTCUT = Pattern.compile("\\[InternetShortcut\\]\\s+URL=(.+)\\b");
    private static final Pattern RE_URL_IN_WEBLOC = Pattern.compile("<key>URL</key>\\s+<string>(.+)</string>");
    private static File pluginJarFile = null;

    public static File getPluginJarFile() throws URISyntaxException {
        if (pluginJarFile == null) {
            CodeSource codeSource = MoeUtil.class.getProtectionDomain().getCodeSource();
            pluginJarFile = new File(codeSource.getLocation().toURI().getPath());
        }
        return pluginJarFile;
    }

    public static File getPluginJarDir() throws URISyntaxException {
        File jarFile = MoeUtil.getPluginJarFile();
        return new File(jarFile.getParentFile().getPath());
    }

    public static URL getURL(File file) {
        String fileName = file.getName().toLowerCase();
        try {
            if (fileName.endsWith(".url") || fileName.endsWith(".website")) {
                String text = MoeUtil.readTextFile(file, System.getProperty("sun.jnu.encoding"));
                Matcher matcher = RE_URL_IN_SHORTCUT.matcher(text);
                if (matcher.find()) {
                    return new URL(matcher.group(1));
                }
                Log.log((String)("Could not find valid URL in internet shortcut file '" + file.getCanonicalPath() + "'"));
            } else if (fileName.endsWith(".webloc")) {
                String text = MoeUtil.readTextFile(file, "UTF-8");
                Matcher matcher = RE_URL_IN_WEBLOC.matcher(text);
                if (matcher.find()) {
                    return new URL(matcher.group(1));
                }
                Log.log((String)("Could not find valid URL in website location file '" + file.getCanonicalPath() + "'"));
            }
        }
        catch (IOException ex) {
            Log.log((Throwable)ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file, String encoding) throws IOException {
        BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
        try {
            StringWriter out = new StringWriter();
            LFileCopy.copy((Reader)rd, (Writer)out);
            String string = out.toString();
            return string;
        }
        finally {
            rd.close();
        }
    }
}

