/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.plugin.moenizer;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.plugin.moenizer.MoeUtil;
import org.omegat.util.FileUtil;
import org.omegat.util.Log;

public class MoeConfig {
    private static final String CONFIG_FILE_NAME = "moenizer.conf";
    private static final String SCRIPT_FILE_NAME = "moenizer.groovy";
    private static final float DEFAULT_OPACITY = 0.5f;
    private static final int MAX_OPACITY_IN_PERCENTAGE = 100;
    private static final int MIN_OPACITY_IN_PERCENTAGE = 0;
    private static final long DEFAULT_INTERVAL = 60000L;
    private static final long MAX_INTERVAL = 86400000L;
    private static final long MIN_INTERVAL = 3000L;
    private static final Pattern RE_LINEBREAK = Pattern.compile("[\\n\\r]+");
    private static final Pattern RE_OPACITY = Pattern.compile("(\\d+)\\s*%$");
    private static final Pattern RE_INTERVAL = Pattern.compile("(\\d+)\\s*([msh])", 2);
    private static final Pattern RE_SCRIPT = Pattern.compile("(?:/|\\\\\\\\[^\\\\]|[a-zA-Z]:\\\\).+\\.groovy");
    private static final Pattern RE_SOURCE = Pattern.compile("(?:http://|https://|/|\\\\\\\\[^\\\\]|[a-zA-Z]:\\\\).+");
    private static final Pattern RE_HAS_IMAGE_EXTENSION = Pattern.compile(".+\\.(?:bmp|png|jpg|jpeg|gif)");
    private static final Pattern RE_HAS_INTERNET_SHORTCUT_EXTENSION = Pattern.compile(".+\\.(?:url|website|webloc)");
    private static final Pattern RE_HTTP_OR_HTTPS_PROTOCOL = Pattern.compile("(?:http://|https://).+");
    private static final Pattern RE_SOURCE_IN_PLUGIN_DIR = Pattern.compile(".+\\.(?:bmp|png|jpg|jpeg|gif|url|website|webloc)");
    private static ConfigData data;
    private static HashSet<Object> sources;

    public static long getInterval() {
        return MoeConfig.data.interval;
    }

    public static float getOpacity() {
        return MoeConfig.data.opacity;
    }

    public static File getScript() {
        return MoeConfig.data.script.isEmpty() ? null : new File(MoeConfig.data.script);
    }

    public static Object[] getSources() {
        return sources.toArray();
    }

    private static ConfigData loadConfig() {
        ConfigData data = MoeConfig.getDefaultConfig();
        try {
            File file = new File(MoeUtil.getPluginJarDir(), CONFIG_FILE_NAME);
            if (file.isFile()) {
                String[] lines;
                String text = FileUtil.readTextFile((File)file);
                for (String line : lines = RE_LINEBREAK.split(text)) {
                    if (!line.isEmpty() && !MoeConfig.setOpacity(data, line) && !MoeConfig.setInterval(data, line) && !MoeConfig.setScript(data, line) && !MoeConfig.addSource(data, line)) continue;
                }
            }
        }
        catch (Exception ex) {
            Log.log((Throwable)ex);
        }
        return data;
    }

    private static ConfigData getDefaultConfig() {
        ConfigData cd = new ConfigData();
        cd.opacity = 0.5f;
        cd.interval = 0L;
        cd.script = "";
        cd.source = new HashSet<String>();
        return cd;
    }

    private static boolean setOpacity(ConfigData data, String line) {
        Matcher matcher = RE_OPACITY.matcher(line);
        if (matcher.matches()) {
            float f;
            String num = matcher.group(1);
            int i = Integer.parseInt(num);
            data.opacity = i > 100 ? 100.0f : (i < 0 ? 0.0f : (f = (float)i / 100.0f));
            return true;
        }
        return false;
    }

    private static boolean setInterval(ConfigData data, String line) {
        Matcher matcher = RE_INTERVAL.matcher(line);
        if (matcher.matches()) {
            String num = matcher.group(1);
            String unit = matcher.group(2).toLowerCase();
            long i = Long.parseLong(num);
            if (unit.equals("s")) {
                i *= 1000L;
            } else if (unit.equals("m")) {
                i = i * 60L * 1000L;
            } else if (unit.equals("h")) {
                i = i * 60L * 60L * 1000L;
            }
            data.interval = i > 86400000L ? 86400000L : (i < 3000L ? 3000L : i);
            return true;
        }
        return false;
    }

    private static boolean setScript(ConfigData data, String line) {
        Matcher matcher = RE_SCRIPT.matcher(line);
        if (matcher.matches()) {
            data.script = line;
            return true;
        }
        return false;
    }

    private static boolean addSource(ConfigData data, String line) {
        Matcher matcher = RE_SOURCE.matcher(line);
        if (matcher.matches()) {
            data.source.add(line);
            return true;
        }
        return false;
    }

    private static HashSet<Object> getFlattenSources(Set<String> source) {
        HashSet<Object> newSource = new HashSet<Object>();
        for (String s : source) {
            try {
                File[] listFiles;
                if (RE_HTTP_OR_HTTPS_PROTOCOL.matcher(s.toLowerCase()).matches()) {
                    newSource.add(new URL(s));
                    continue;
                }
                File file = new File(s);
                if (file.isFile() && RE_HAS_IMAGE_EXTENSION.matcher(s.toLowerCase()).matches()) {
                    newSource.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                for (File f : listFiles = file.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        if (f.isFile()) {
                            String fileName = f.getName().toLowerCase();
                            if (RE_HAS_IMAGE_EXTENSION.matcher(fileName).matches() || RE_HAS_INTERNET_SHORTCUT_EXTENSION.matcher(fileName).matches()) {
                                return true;
                            }
                        }
                        return false;
                    }
                })) {
                    URL url;
                    String fileName = f.getName().toLowerCase();
                    if (RE_HAS_IMAGE_EXTENSION.matcher(fileName).matches()) {
                        newSource.add(file);
                        continue;
                    }
                    if (!RE_HAS_INTERNET_SHORTCUT_EXTENSION.matcher(fileName).matches() || (url = MoeUtil.getURL(file)) == null) continue;
                    newSource.add(url);
                }
            }
            catch (Exception ex) {
                Log.log((Throwable)ex);
            }
        }
        return newSource;
    }

    private static String getScriptInPluginDir() {
        try {
            File file = new File(MoeUtil.getPluginJarDir(), SCRIPT_FILE_NAME);
            if (file.isFile()) {
                return file.getCanonicalPath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private static HashSet<Object> getSourcesInPluginDir() {
        HashSet<Object> newSource = new HashSet<Object>();
        try {
            File[] listFiles;
            File dir = MoeUtil.getPluginJarDir();
            for (File f : listFiles = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isFile()) {
                        String fileName = f.getName().toLowerCase();
                        if (RE_SOURCE_IN_PLUGIN_DIR.matcher(fileName).matches()) {
                            return true;
                        }
                    }
                    return false;
                }
            })) {
                URL url;
                String fileName = f.getName().toLowerCase();
                if (RE_HAS_IMAGE_EXTENSION.matcher(fileName).matches()) {
                    newSource.add(f);
                    continue;
                }
                if (!RE_HAS_INTERNET_SHORTCUT_EXTENSION.matcher(fileName).matches() || (url = MoeUtil.getURL(f)) == null) continue;
                newSource.add(url);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newSource;
    }

    static {
        ConfigData cd = MoeConfig.loadConfig();
        HashSet<Object> flattenSources = MoeConfig.getFlattenSources(cd.source);
        if (flattenSources.isEmpty() && cd.script.isEmpty()) {
            cd.script = MoeConfig.getScriptInPluginDir();
            flattenSources = MoeConfig.getSourcesInPluginDir();
        }
        if (cd.interval == 0L && flattenSources.size() > 1) {
            cd.interval = 60000L;
        }
        data = cd;
        sources = flattenSources;
    }

    private static class ConfigData {
        protected float opacity;
        protected long interval;
        protected String script;
        protected Set<String> source;

        private ConfigData() {
        }
    }
}

