/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.plugin.matchesbeeper;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledEditorKit;
import org.omegat.plugin.matchesbeeper.Beeper;
import org.omegat.util.Log;

public class MatchesEditorKit
extends StyledEditorKit {
    private final Pattern RE_DOUBLE_BREAK = Pattern.compile("\\n\\n");

    @Override
    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        super.read(in, doc, pos);
        StringReader reader = (StringReader)in;
        String content = this.getString(reader);
        int count = this.RE_DOUBLE_BREAK.split(content).length;
        Log.log("in: " + count + " matches found.");
        new Thread(new Beeper(count)).start();
    }

    private String getString(StringReader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        char[] b = new char[1024];
        int offset = 0;
        reader.reset();
        int len = reader.read(b);
        while (len != -1) {
            sb.append(b, offset, len);
            len = reader.read(b);
        }
        return sb.toString();
    }
}

