/*
First author tiritomato 2013.

mqsdx is distributed under the GNU Lesser General Public License 3.0(LGPLv3).

support blog (Japanese only)
http://d.hatena.ne.jp/tiri_tomato/
*/

#ifndef __MQSDKPlugIn0x_11_h__
#define __MQSDKPlugIn0x_11_h__

#define _USE_MATH_DEFINES
#include <math.h>
#include <stdint.h>
#include <string.h>

#include <algorithm>
#include <cmath>
#include <functional>
#include <iomanip>
#include <regex>
#include <sstream>
#include <utility>
#include <vector>

#define NOMINMAX
#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#include <MQSetting.h>
#include <MQBasePlugin.h>
#include <MQPlugin.h>
#include <MQ3DLib.h>

#include "impl/MQ0x_11.hpp"

// Plugin Version Checker
#ifdef MQPLUGIN_VERSION
	#if MQPLUGIN_VERSION < 0x0300
	"MQx" need newer than mqsdk300
	#endif
#else
	"MQx" need newer than mqsdk300
#endif

namespace MQ0x {
	
/*!	@addtogroup MQ0ẍꗗ
	@{
*/

	/*!
@brief g^z񂩂nbVR[h𐶐NX

@tparam T_OUT nbVR[h̖߂l^w
@tparam default_seed nbVR[h̃ftHg̏lwBȗ͐17gp܂B

@code
	// ̃nbVR[h擾
	DWORD hashOfString = CollectionHashCode<DWORD>("\[Xzij");
	
	// shortz̃nbVR[h擾
	const short array[] = { 0, 1, 2, 3 };
	unsigned int hashOfString = CollectionHashCode<unsigned int>(array, sizeof(array)/sizeof(array[0]));
@endcode

z̊evfɑ΂Ď̂悤ȌvZJԂănbVR[h𐶐܂BlZɑΉg^ŁAƂɕ_ł͂Ȃn̏Ɍ܂B
@code
	T_OUT hashCode = seed;

	(zvf胋[v) {
		hashCode = hashCode * ((sizeof(T_IN)*8)-1) ^ zvf;
	}
	return hashCode;
@endcode
	*/
	template <typename T_OUT, const size_t default_seed = 17> struct CollectionHashCode {
	public:
		///@brief T_OUTɃLXgꂽftHg̏l
		static const T_OUT defaultSeed = (T_OUT)default_seed;
		///@brief ftHgRXgN^
		CollectionHashCode( const T_OUT seed = defaultSeed ) : m_val( seed ) {}
		/*!
		@brief z̐擪|C^ƌw肵ănbVR[h𐶐
		@tparam T_IN \[Xž^w
		@note pSrcNULL܂͔z񐔂0łꍇA^ꂽl̂܂܃nbVR[hƂċL^܂B
		*/
		template <typename T_IN> CollectionHashCode( const T_IN *pSrc, const size_t ct, const T_OUT seed = defaultSeed ) : m_val(seed) {
			if ( pSrc != NULL ) for ( size_t i = 0; i < ct; i++ ) m_val = (m_val * (T_OUT)(sizeof(T_IN) * 8 - 1)) ^ pSrc[i];
		}
		/*!
		@brief w肵ănbVR[h𐶐
		@note pSrcNULL܂͒0̋̕łꍇA^ꂽl̂܂܃nbVR[hƂċL^܂B
		*/
		CollectionHashCode( const char *pSrc, const T_OUT seed = defaultSeed ) : m_val(FromTrailCodeCollection(pSrc,'\0',seed)) {}
		/*!
		@brief Chw肵ănbVR[h𐶐
		@note pSrcNULL܂͒0̋̕łꍇA^ꂽl̂܂܃nbVR[hƂċL^܂B
		*/
		CollectionHashCode( const wchar_t *pSrc, const T_OUT seed = defaultSeed ) : m_val(FromTrailCodeCollection(pSrc,L'\0',seed)) {}
		/*!
		@brief z̐擪|C^Ɣz̏I[lw肵ănbVR[h𐶐
		@tparam T_IN \[Xž^w
		@note pSrcNULL܂́Aŏ̃f[^ŏI[̔złꍇA^ꂽl̂܂܃nbVR[hƂċL^܂B
		*/
		template <typename T_IN> static CollectionHashCode FromTrailCodeCollection( const T_IN *pSrc, const T_IN trailCode, const T_OUT seed = defaultSeed ) {
			CollectionHashCode ret(seed);
			if ( pSrc != NULL ) while ( (*pSrc) != trailCode ) ret.m_val = (ret.m_val * (T_OUT)(sizeof(T_IN) * 8 - 1)) ^ (*(pSrc++));
			return ret;
		}
		///@brief Öق̃LXgĖ߂l擾
		operator T_OUT() { return m_val; }
	private:
		T_OUT m_val;
	};
	
	//! @brief HSVF\ @details F(H)Eʓx(S)Ex(V)gĐFێ܂B܂RGB(MQColor)Ƃ̕ϊ\bh܂B
	//! @tparam T	l(h,s,v)Ɏg^w肵܂Bfloat/double/long doublew肵ĂB
	template <typename T> struct HSV {
		typedef T value_type;	///< @brief ev[gTɎw肳ꂽ^typedef܂BTɂ͒l(h,s,v)Ɏg^w肵܂BTɂfloat/double/long doublew肵ĂB
		T h;					///< @brief F F[0,360][0.0,1.0]ƂċL^܂B
		T s;					///< @brief ʓx[0.0,1.0]ƂċL^܂B
		T v;					///< @brief x[0.0,1.0]ƂċL^܂B
		HSV() : h(T(0)), s(T(0)), v(T(0)) {} ///< @brief ftHgRXgN^
		HSV(T h_, T s_, T v_) : h(h_), s(s_), v(v_) {} ///< @brief RXgN^
		HSV( const HSV& src ) : h(src.h), s(src.s), v(src.v) {} ///< @brief Rs[RXgN^
		/// @brief RGBiMQColorjHSVɕϊ܂B
		HSV( const MQColor& rgb ) : h(T(0)), s(T(0)), v(T(0))  {
			const T min = T(std::min(std::min(rgb.r,rgb.g),rgb.b));
			const T max = T(std::max(std::max(rgb.r,rgb.g),rgb.b));
			const T delta = max - min;
			v = max;
			if(delta!=T(0)) {
				s = delta / max;
				if ( rgb.r == max ) h = (rgb.g-rgb.b) / delta;
				else if (rgb.g == max) h = T(2) + (rgb.b-rgb.r) / delta;
				else h = T(4) + (rgb.r-rgb.g) / delta;
				h /= T(6);
				if ( h < T(0) ) h += T(1);
			}
		}
		/*! @brief O[XP[J[肵܂B
		@param threshold O[XP[iʓxȂ[ɓjƔ肷鎞臒lw肵܂B̊֐̖߂l (threshold < s) łB
		@return O[XP[̎trueBȊOfalseB*/
		bool isGrayScale( T threshold ) const { return threshold < s; }
		/// @brief O[XP[J[肵܂B
		/// @return O[XP[̎trueBȊOfalseB̊֐̖߂l isGrayScale(std::numeric_limits<value_type>::epsilon()) ƓȂ܂B
		bool isGrayScale() const { return isGrayScale(std::numeric_limits<T>::epsilon()); }
		//! @brief F𐳋K܂B
		//! @details h,s,vꂼ[0.0,1.0]ɐK܂Bh͉]pxƂďz悤K܂As,v̓NvvZŖOa悤ɐK܂B
		void normalize() {
			h -= std::floor(h);
			s = clamp01(s);
			v = clamp01(v);
		}
		/*!	@brief HSVRGB֕ϊ܂B @details ʓx[łꍇAIɐF؂̂ĂĖx𔽉fO[XP[J[Ԃ܂B*/
		MQColor toMQColor() const {
			const HSV normal = toNormalized(); // to [0,1]
			if ( normal.isGrayScale() ) return MQColor( normal.v );
			const T H = normal.h * T(6);
			const int Hi = static_cast<int>(H);
			const T fr = H - T(Hi);
			const T m = normal.v * (T(1)-normal.s);
			const T n = normal.v * (T(1)-normal.s*fr);
			const T p = normal.v * (T(1)-normal.s*(T(1)-fr));
			switch(Hi) {
				case 0:		return MQColor( float(normal.v), float(p), float(m) );
				case 1:		return MQColor( float(n), float(normal.v), float(m) );
				case 2:		return MQColor( float(m), float(normal.v), float(p) );
				case 3:		return MQColor( float(m), float(n), float(normal.v) );
				case 4:		return MQColor( float(p), float(m), float(normal.v) );
				default:	return MQColor( float(normal.v), float(m), float(n) );
			}
		}
		/*! @brief KHSVF\̂Ԃ܂B @details normalize() lɐK\̂Ԃ܂ig̏͐K܂jB*/
		HSV toNormalized() const { return HSV( h - std::floor(h), Clamp01(s), Clamp01(v) ); }
	};

	/*!
	@brief MQSettingsNX
	@code
		PluginBase<MQCommandPlugin> some_plugin;
		{
			SettingProxy setting = some_plugin.Setting(); // Setting擾
			setting.Load( ... );
			setting.Save( ... );
			setting.Close(); // ȗ\ifXgN^oRłClose()͎s܂j
		}
	@endcode
	SettingProxỹRs[͋֎~Ă܂(notcopyable)
	*/
	struct SettingProxy {
	public:
		//!@brief SettingProxyNX̐nh^
		struct Handle {
			///@cond
			friend struct SettingProxy;
			template <typename T_MQPLUGIN> friend class PluginBase;
			///@endcond
			static Handle Empty() { return Handle(NULL); }
		public:
			Handle( MQBasePlugin* plugin ) { this->plugin = plugin; }
			MQBasePlugin* plugin;
		};
		SettingProxy( Handle handle );
		~SettingProxy() { Close(); }
		void Close();
		bool Load(const char *name, bool& value, bool default_value=false);
		bool Load(const char *name, int& value, int default_value=0);
		bool Load(const char *name, unsigned int& value, unsigned int default_value=0);
		bool Load(const char *name, float& value, float default_value=0.0f);
		bool Load(const char *name, std::string& value, std::string default_value="");
		bool Save(const char *name, const bool& value);
		bool Save(const char *name, const int& value);
		bool Save(const char *name, const unsigned int& value);
		bool Save(const char *name, const float& value);
		bool Save(const char *name, const char* value);
		bool Save(const char *name, const std::string& value);
	private:
		SettingProxy(const SettingProxy&);				// kill copy
		SettingProxy& operator=(const SettingProxy&);	// kill copy
		MQBasePlugin* m_plugin;
		MQSetting* m_setting;
	};

/*!
@brief MQBasePluginpNXɁA{IȊgsev[gbp[NX
@tparam T_MQPLUGIN MQBasePluginp^

@par

̃NX̓RXgN^ŐҖAvOCA\w肷鎖ňȉ̎܂B
- GetPlugInID()
- GetPlugInName()
- EnumString()
- MQSetting::Open()Close()

@par

@code
PluginBase<MQCommandPlugin> plugin("tiritomato", "SamplePlugin Copyright(C) 2013, tiritomato.", "SamplePlugin");
{
	SettingProxy setting = plugin.Setting();
	setting.Load(...);
	setting.Save(...);
	setting.Close(); // Close()SettingProxỹfXgN^ɔC鎖o܂B
}
@endcode

@par

ID̎ɂ͕̃nbVR[h̗pĂ܂B
- IDҖiproductNamej̃nbVR[h
- vOCIDvOCiGetPlugInName()Ŏ擾ł镶j̃nbVR[h
	
@par

nbVR[hZo͓T^IɁunbVR[h = nbVR[h * (͌^(̏ꍇchar^)TCỸrbg-1) ^ zvfvƂvZA
zvf̌JԂWbN̗pĂ܂B̃ev[gNXōŏIIɃbv̂Ãev[gNXx[XNXɂČpĊĝ͎RłB
	*/
	template <typename T_MQPLUGIN> class PluginBase : public T_MQPLUGIN {
	public:
		PluginBase( const char* productName, const char* pluginFullName, const char* pluginString ) :
			m_productName( productName ),
			m_pluginFullName( pluginFullName ),
			m_pluginString( pluginString ),
			m_idProduct( CollectionHashCode<DWORD>(productName) ),
			m_idPlugin( CollectionHashCode<DWORD>(pluginFullName) )
		{
		}

		PluginBase( const char* productName, const char* pluginFullName, const char* pluginString,
			const DWORD idProduct, const DWORD idPlugin	) :
			m_productName( productName ),
			m_pluginFullName( pluginFullName ),
			m_pluginString( pluginString ),
			m_idProduct( idProduct ),
			m_idPlugin( idPlugin )
		{
		}

		//! vOCIDԂB
		virtual void GetPlugInID(DWORD *Product, DWORD *ID) {
			*Product = m_idProduct;
			*ID = m_idPlugin;
		}
		//! vOCԂB
		virtual const char *GetPlugInName() { return m_pluginFullName.c_str(); }
		//! {^⃁j[ɕ\镶ԂB
		virtual const char *EnumString() { return m_pluginString.c_str(); }
		//! ҖԂiƎɒǉj
		const char* GetProductName() { return m_productName.c_str(); }
		//! pꂽɎgILXg
		MQBasePlugin* BasePlugin() { return this; }
		//! SettingProxy(MQSetting̑)I[vnh擾
		SettingProxy::Handle Setting() { return SettingProxy::Handle(BasePlugin()); }
		/// @brief v_NgID擾
		DWORD ProductID() { return m_idProduct; }
		/// @brief vOCID擾
		DWORD PluginID() { return m_idPlugin; }
	protected:
		const std::string m_productName;
		const std::string m_pluginFullName;
		const std::string m_pluginString;
		const DWORD m_idProduct;
		const DWORD m_idPlugin;
	};

	namespace Math {
		///@addtogroup MQ0x-MathO
		///@{

		///@brief ceiling֐ @note _ȊO̐l^ɂΉceilłB̎src̒l̂܂ܕԂ܂B11dl𖞂 std::ceil() ŗpĂB
		template <typename T> inline T Ceil( T src ) { return src; }
		/// @cond
		template <> inline float Ceil( float src ) { return std::ceil(src); }
		template <> inline double Ceil( double src ) { return std::ceil(src); }
		template <> inline long double Ceil( long double src ) { return std::ceil(src); }
		/// @endcond

		//! @brief NvvZ @details srcmin`max̊OɂꍇAsrc𗼒[ŖOaminȏmaxȉɂ߂܂B
		template <typename T> inline T Clamp( T src, T min, T max ) {
			return std::min( std::max(min,max), std::max( std::min(min,max), src) );
		}
		
		//! @brief 0`1NvvZ @details src0`1̊OɂꍇAsrc𗼒[ŖOa0ȏ1ȉɂ߂܂B
		template <typename T> inline T Clamp01( T src ) { return std::min(T(1),std::max(T(0),src)); }
		
		//! @brief floor֐ @note _ȊO̐l^ɂΉfloorłB̎src̒l̂܂ܕԂ܂B11dl𖞂 std::floor() ŗpĂB
		template <typename T> inline T Floor( T src ) { return src; }
		/// @cond
		template <> inline float Floor( float src ) { return std::floor(src); }
		template <> inline double Floor( double src ) { return std::floor(src); }
		template <> inline long double Floor( long double src ) { return std::floor(src); }
		/// @endcond

		/*! @brief ` (Linear interpolation)
		@return t0̎fromAt1̎toԂAt0.5̎fromto̕ϒlԂ܂Btclampɂ0`1Ɋۂ߂܂B*/
		template <typename T> inline T Lerp(T from, T to, T t) { return from + (to - from) * clamp01(t); }
		
		//! @brief ݂̒lڕW̒l܂Ŏwʈړ܂B @details fromto֌movړ܂Bmov傫Ătoǂz͂ȂtoŎ~܂܂B
		template <typename T> inline T MoveTo( T from, T to, T mov ) {
			mov = std::abs(mov);
			if ( std::abs(from - to) < mov ) return to;
			return from += ( from < to ? mov : -mov );
		}
		
		//! @brief PI @return PIԂ܂B
		template <typename T> inline T Pi() { return (T)M_PI; }
		/// @cond
		template <> long double Pi();
		/// @endcond

		/*! @brief x烉WApiʓxjɕϊ
		@code
		float d = 180.0f;                // as degree
		float rd = d * Deg2Rad<float>(); // to radian
		@endcode*/
		template <typename T> inline T Deg2Rad() { return Pi<T>() / (T)180; }
		//! @brief x烉WApiʓxjɕϊ @code float rad = Deg2Rad<float>(180.0f); // convert 180.0 degree into radian @endcode
		template <typename T> inline T Deg2Rad(T degree) { return Deg2Rad<T>() * degree; }

		/*! @brief WApiʓxjxɕϊ
		@code
		float rd = 2.0f * Pi<float>();   // as radian
		float d = rd * Rad2Deg<float>(); // to degree
		@endcode*/
		template <typename T> inline T Rad2Deg() { return (T)180 / Pi<T>(); }
		//! @brief WApiʓxjxɕϊ @code float deg = Rad2Deg<float>(2.0f * pi<float>()); // convert 2 * PI (radian) into degree @endcode
		template <typename T> inline T Rad2Deg(T degree) { return Rad2Deg() * degree; }

		/*! @brief zۂ @return tzlƂāAt0`Βl(length)Ɋۂ߂lԂ܂BႦ΁ARepeat(380.0,360.0)20.0Ԃ܂B*/
		template <typename T> inline T Repeat( T t, T length ) { return t - std::floor(t/length)*length; }

		/*!	@brief truncatevZB @note VC2010 std::trunc() ڂĂȂ̂ŎĂ܂B std::trunc() Ȃ炻gׂłB*/
		template <typename T> inline T Trunc( T src ) { if ( T(0) < src ) return floor(src); return ceil(src); }
		/// @}
	}
	using namespace Math;


	namespace Polygon {
		///@addtogroup MQ0x-PolygonO
		///@{
		
		///@cond
		struct VertexNormalBuffer;
		///@endcond

		/*! @brief ʖ@obt@O܂
		@details IuWFNg̃f[^XVĂ FaceNormalBuffer ̖@obt@͓܂i`ύXȂÓIȏ̓rŁA@ZȍdČvZ邽߂ɈꎞIɗp̂ɌĂ܂jB
		{IɈ̃IuWFNgɑ΂Ĉ FaceNormalBuffer KvłAVrAȃptH[}XvꍇA
		Clear() \bhĐVIuWFNgݒ肵Amۍς݂̃obt@̈lNAčėpAq[vׂ̏ጸ鎖\łB*/
		struct FaceNormalBuffer {
			typedef std::vector<MQPoint>::size_type size_type;
			/// @brief Ȗ@肵܂B
			static bool IsInvalid( const MQPoint& src ) { return src.x >= std::numeric_limits<float>::infinity(); }
			/// @brief ftHgRXgN^
			FaceNormalBuffer() : m_obj(NULL), m_buffer(0), invalid_value( std::numeric_limits<float>::infinity(), std::numeric_limits<float>::infinity(), std::numeric_limits<float>::infinity() ) {}
			/// @brief RXgN^
			FaceNormalBuffer( const ::MQObject obj ) : m_obj( obj ), m_buffer(0),
				invalid_value( std::numeric_limits<float>::infinity(), std::numeric_limits<float>::infinity(), std::numeric_limits<float>::infinity() ) {
				if ( obj != NULL ) {
					const int ctFaceMax = obj->GetFaceCount();
					m_buffer.resize( ctFaceMax );
					for ( int ctFace = 0; ctFace < ctFaceMax; ctFace++ ) m_buffer[ctFace].x = invalid_value.x;
				}
			}
			//! @brief obt@NA܂B
			//! @param [in] isCompact q[v؂l߂邩ǂB
			//! @details q[v؂l߂鎞Aݒ肳ꂽIuWFNg̖ʐQƂĐ؂l߂܂BIuWFNgݒ肳ĂȂAq[vTCY̓[ɐ؂l߂܂B
			void Clear( const bool isCompact = false ) {
				if ( isCompact ) {
					size_type sz = 0; if ( m_obj != NULL ) sz = size_type(m_obj->GetFaceCount());
					std::vector<MQPoint>(sz).swap( m_buffer );
				}
				for ( size_type ctFace = 0; ctFace < m_buffer.size(); ctFace++ ) m_buffer[ctFace].x = invalid_value.x;
			}
			//! @brief VIuWFNgw肵ăobt@NA܂B
			//! @param [in] isCompact q[v؂l߂邩ǂB
			//! @details q[v؂l߂鎞Aݒ肳ꂽIuWFNg̖ʐQƂĐ؂l߂܂BIuWFNgݒ肳ĂȂAq[vTCY̓[ɐ؂l߂܂B
			void Clear( const ::MQObject obj, const bool isCompact = false ) { m_obj = obj; Clear(isCompact); }
			//! @brief svȃq[v̈؂l߂܂BIuWFNgݒ肳ĂȂAq[vTCY̓[ɐ؂l߂܂B
			void Compact() {
				size_type sz = 0; if ( m_obj != NULL ) sz = size_type(m_obj->GetFaceCount());
				m_buffer.resize(sz);
				m_buffer.shrink_to_fit();
			}
			//! @brief ֘AtĂMQObject擾܂B
			const ::MQObject MQObject() const { return m_obj; }
			/*! @brief ʖ@擾܂B
			@details CfbNXw肷ʂ̖@͍ŏɎQƂꂽɌvZij܂Bxobt@ꂽf[^ Clear() \bhōĂіԂɖ߂܂ŕێ܂B
			@return obt@ꂽʖ@B@͐Kς݂łBȂÃP[Xł͖Ȗ@Ԃ܂B
			- IuWFNgw肳ĂȂɁA\zς݃obt@͈̔͊OA܂ĂȂvfQƂB
			- IuWFNgw肳Ă鎞ɁAIuWFNg̖ʔz͈̔͊OQƂB
			- IuWFNgw肳Ă鎞ɁAOpłlpłȂʂQƂB*/
			const MQPoint& operator [] ( size_type index ) {
				if ( m_obj == NULL ) {
					if ( (index < m_buffer.size()) && (IsInvalid(m_buffer[index])==false) ) return m_buffer[index];
				}
				else {
					const size_type ctFaceMax = size_type(m_obj->GetFaceCount());
					if ( index < ctFaceMax ) {
						const size_type registedSize = m_buffer.size();
						if ( registedSize < ctFaceMax ) {
							m_buffer.resize( ctFaceMax );
							for ( size_type ct = registedSize; ct < ctFaceMax; ct++ ) m_buffer[ct].x = invalid_value.x;
						}
						if ( IsInvalid(m_buffer[index]) ) {
							const int ctFacePointMax = m_obj->GetFacePointCount( index );
							if ( (ctFacePointMax==3) || (ctFacePointMax==4) ) {
								int v[4];
								m_obj->GetFacePointArray( index, v );
								if ( ctFacePointMax==3 )
									m_buffer[index] = GetNormal( m_obj->GetVertex(v[0]), m_obj->GetVertex(v[1]), m_obj->GetVertex(v[2]) );
								else if ( ctFacePointMax==4 )
									m_buffer[index] = GetQuadNormal( m_obj->GetVertex(v[0]), m_obj->GetVertex(v[1]), m_obj->GetVertex(v[2]), m_obj->GetVertex(v[3]) );
							}
						}
						return m_buffer[index];
					}
				}
				return invalid_value;
			}
		private:
			///@cond
			friend struct Polygon::VertexNormalBuffer;
			///@endcond
			const MQPoint invalid_value;
			::MQObject m_obj;
			std::vector<MQPoint> m_buffer;
		};

		/*! @brief _@i_LSĂ̖ʖ@̕ϖ@jobt@O܂B
		@details IuWFNg̃f[^XVĂ VertexNormalBuffer ̖@obt@͓܂i`ύXȂÓIȏ̓rŁA@ZȍdČvZ邽߂ɈꎞIɗp̂ɌĂ܂jB
		{IɈ̃IuWFNgɑ΂Ĉ VertexNormalBuffer KvłAVrAȃptH[}XvꍇA
		Clear() \bhĐVIuWFNgݒ肵Amۍς݂̃obt@̈lNAčėpAq[vׂ̏ጸ鎖\łB*/
		struct VertexNormalBuffer {
			typedef std::vector<MQPoint>::size_type size_type;
			/// @brief Ȗ@肵܂B
			static bool IsInvalid( const MQPoint& src ) { return FaceNormalBuffer::IsInvalid(src); }
			/// @brief ftHgRXgN^
			VertexNormalBuffer() : m_face_normals( NULL ), m_buffer(0) {}
			/// @brief RXgN^
			VertexNormalBuffer( const ::MQObject obj ) : m_face_normals( obj ), m_buffer(0) { if (obj != NULL) Clear(obj); }
			//! @brief obt@NA܂B
			//! @param [in] isCompact q[v؂l߂邩ǂB
			//! @details q[v؂l߂鎞Aݒ肳ꂽIuWFNg̒_ƖʐQƂĐ؂l߂܂BIuWFNgݒ肳ĂȂAq[vTCY̓[ɐ؂l߂܂B
			void Clear( const bool isCompact = false ) {
				if ( isCompact ) {
					size_type sz = 0;
					if ( m_face_normals.m_obj != NULL ) sz = size_type(m_face_normals.m_obj->GetVertexCount());
					std::vector<MQPoint>(sz).swap( m_buffer );
				}
				for ( size_type ctFace = 0; ctFace < m_buffer.size(); ctFace++ ) m_buffer[ctFace].x = m_face_normals.invalid_value.x;
				m_face_normals.Clear(isCompact);
			}
			//! @brief VIuWFNgw肵ăobt@NA܂B
			//! @param [in] isCompact q[v؂l߂邩ǂB
			//! @details q[v؂l߂鎞Aݒ肳ꂽIuWFNg̒_ƖʐQƂĐ؂l߂܂BIuWFNgݒ肳ĂȂAq[vTCY̓[ɐ؂l߂܂B
			void Clear( const ::MQObject obj, const bool isCompact = false ) {
				if ( isCompact ) {
					size_type sz = 0; if ( obj != NULL ) sz = size_type(obj->GetVertexCount());
					std::vector<MQPoint>(sz).swap( m_buffer );
				}
				for ( size_type ctFace = 0; ctFace < m_buffer.size(); ctFace++ ) m_buffer[ctFace].x = m_face_normals.invalid_value.x;
				m_face_normals.Clear(obj,isCompact);
			}
			//! @brief svȃq[v̈؂l߂܂B
			//! @details ݒ肳ꂽIuWFNg̒_ƖʐQƂĐ؂l߂܂BIuWFNgݒ肳ĂȂAq[vTCY̓[ɐ؂l߂܂B
			void Compact() {
				size_type sz = 0;
				if ( m_face_normals.m_obj != NULL ) sz = size_type(m_face_normals.m_obj->GetVertexCount());
				m_buffer.resize(sz);
				m_buffer.shrink_to_fit();
				m_face_normals.Compact();
			}
			/*! @brief ʖ@擾܂B
			@details CfbNXw肷ʂ̖@͍ŏɎQƂꂽɌvZij܂Bxobt@ꂽf[^ Clear() \bhōĂіԂɖ߂܂ŕێ܂B
			VertexNormal() Œ_@擾ہA_Lʂ FaceNormal() Ăяo߁A VertexNormal() ɂ FaceNormal() ԐړIɎ擾ςݏԂɂȂĂP[X܂B
			@return obt@ꂽʖ@B@͐Kς݂łB̃P[Xł͖Ȗ@Ԃ܂B
			- IuWFNgw肳ĂȂɁA\zς݃obt@͈̔͊OA܂ĂȂvfQƂB
			- IuWFNgw肳Ă鎞ɁAIuWFNg̖ʔz͈̔͊OQƂB
			- IuWFNgw肳Ă鎞ɁAOpłlpłȂʂQƂB*/
			const MQPoint& FaceNormal( FaceNormalBuffer::size_type index ) { return m_face_normals[index]; }
			//! @brief ֘AtĂMQObject擾܂B
			const ::MQObject MQObject() const { return m_face_normals.MQObject(); }
			/*! @brief _@i_LSĂ̖ʖ@̕ϖ@j擾܂B
			@details CfbNXw肷钸_̖@͍ŏɎQƂꂽɌvZij܂Bxobt@ꂽf[^ Clear() \bhōĂіԂɖ߂܂ŕێ܂B
			@return obt@ꂽ_@B@͐Kς݂łB̃P[Xł͖Ȗ@Ԃ܂B
			- IuWFNgw肳ĂȂɁA\zς݃obt@͈̔͊OA܂ĂȂvfQƂB
			- IuWFNgw肳Ă鎞ɁAIuWFNg̒_z͈̔͊OQƂB
			- IuWFNgw肳Ă鎞ɁAOp܂͎lp̖ʂɂ܂pĂȂ_QƂB*/
			const MQPoint& VertexNormal( size_type index ) {
				if ( m_face_normals.m_obj == NULL ) {
					if ( (index < m_buffer.size()) && (IsInvalid(m_buffer[index])==false) ) return m_buffer[index];
				}
				else {
					const size_type ctVertexMax = size_type(m_face_normals.m_obj->GetVertexCount());
					if ( index < ctVertexMax ) {
						const size_type registedSize = m_buffer.size();
						if ( registedSize < ctVertexMax ) {
							m_buffer.resize( ctVertexMax );
							for ( size_type ct = registedSize; ct < ctVertexMax; ct++ ) m_buffer[ct].x = m_face_normals.invalid_value.x;
						}
						MQPoint& ret = m_buffer[index]; // get [in,out] reference
						if ( IsInvalid(ret) ) {
							const std::vector<int>::size_type ctFaceMax = std::vector<int>::size_type(m_face_normals.m_obj->GetVertexRelatedFaces( index, NULL ));
							if (ctFaceMax == 1)
							{
								int face_index;
								m_face_normals.m_obj->GetVertexRelatedFaces( index, &face_index );
								ret = FaceNormal(FaceNormalBuffer::size_type(face_index));
							}
							else if ( 1 < ctFaceMax ) {
								std::vector<int> face_indexes( ctFaceMax );
								std::vector<int> vertexIndexesOfFace(4);
								m_face_normals.m_obj->GetVertexRelatedFaces( index, &face_indexes[0] );
								unsigned int ctAdd = 0;
								ret.zero(); // ret reference clear
								for ( std::vector<int>::size_type ct = 0; ct < ctFaceMax; ct++ ) // all check of related face
								{
									const MQPoint& n = FaceNormal(FaceNormalBuffer::size_type(face_indexes[ct]));
									if ( FaceNormalBuffer::IsInvalid(n) == false )
									{
										const std::vector<int>::size_type vertexCountOfFace = std::vector<int>::size_type(m_face_normals.m_obj->GetFacePointCount(face_indexes[ct]));
										if (vertexIndexesOfFace.size() < vertexCountOfFace) vertexIndexesOfFace.resize(vertexCountOfFace);
										m_face_normals.m_obj->GetFacePointArray(face_indexes[ct], &vertexIndexesOfFace[0]);
										int findCt = 0;
										std::vector<int>::size_type findPosition;
										for (std::vector<int>::size_type ct = 0; ct < vertexCountOfFace; ct++)
										{
											if (index == vertexIndexesOfFace[ct]) if (findCt++ == 0) findPosition = ct;
										}
										if (findCt != 1) continue;
										const int prevVertexIndex = vertexIndexesOfFace[(findPosition <= 0 ? vertexCountOfFace : findPosition) - 1];
										const int nextVertexIndex = vertexIndexesOfFace[(findPosition + 1) < vertexCountOfFace ? (findPosition + 1) : 0];
										const MQPoint vertex = m_face_normals.m_obj->GetVertex(index);
										MQPoint toPrevVertex = m_face_normals.m_obj->GetVertex(prevVertexIndex) - vertex;
										MQPoint toNextVertex = m_face_normals.m_obj->GetVertex(nextVertexIndex) - vertex;
										float cos = GetInnerProduct(toPrevVertex, toNextVertex) / (GetSize(toPrevVertex) * GetSize(toNextVertex));
										ret += (n * (1.0f - cos)); // n * (2.0 - (cos + 1.0))
										ctAdd++;
									}
								}
								if (0 < ctAdd) ret.normalize();
								else ret.x = m_face_normals.invalid_value.x;
							}
						}
						return ret;
					}
				}
				return m_face_normals.invalid_value;
			}
			//! @brief _@擾܂B @details vertex_normal() Ăяo܂B
			const MQPoint& operator [] ( size_type index ) { return VertexNormal(index); }
		private:
			FaceNormalBuffer m_face_normals;
			std::vector<MQPoint> m_buffer;
		};

		//! @brief Cӂ̃IuWFNgQuv|Sobt@\zNXłB
		class UVFaceBuffer {
		public:

			//! @brief UVW̃f[^vfłB @ref MQ0x::Polygon::UVFaceBuffer::UVPoint::Buffer "UVPoint::Buffer"\̂găobt@O܂B
			struct UVPoint {
				MQCoordinate uv;
				UVPoint( const MQCoordinate& initial_uv ) : uv(initial_uv) {}
				//! @brief @ref MQ0x::Polygon::UVFaceBuffer::UVPoint "UVPoint"obt@\́BuvdȂ悤uvWobt@O܂B
				//! @details UVPoint::Buffer͒PȓI`zł͂ȂAu̒l0`1͈̔͂ɑz肵Aresolution萔gănbVL[ɂ镪zł()B
				//! uvlӂɃnbVoĔzו邱ƂŊuvl̑茟Ag̍ĔzuRXg\ɂȂĂ܂B
				//! AvfɃANZXɂ͐p̃ItZbgf[^^@ref MQ0x::Polygon::UVFaceBuffer::UVPoint::Buffer::Index "Index"\̂KvłB
				//!	@details () u_key = u * resolution A0 <= u_key <= (resolution-1)͈͊Ȍꍇ͗[@ref MQ0x::Math::Clamp() "Clamp()"B
				struct Buffer {
					typedef uint16_t resolution_type;				//!< @brief resolutioň^
					static const resolution_type resolution = 10;	//!< @brief resolution萔
				private:
					typedef std::vector<UVPoint> base_buffer_type;
					base_buffer_type m_buffer[resolution];
					/// @cond
					friend struct Index;
					/// @endcond
				public:
					//! @brief @ref MQ0x::Polygon::UVFaceBuffer::UVPoint::Buffer "UVPoint::Buffer"QƂ邽߂̃CfbNX^
					//! @details rẐ߂ std::pair publicpĂ܂Afirst/secondoւ̃ANZX͖Ă܂B
					//! gp鎞́AreadonlyŒۉꂽnh^̂悤ɈĂB
					struct Index : public std::pair<resolution_type, base_buffer_type::size_type> {
						///@cond
						friend struct MQ0x::Polygon::UVFaceBuffer::UVPoint::Buffer;
						///@endcond
						typedef std::pair<resolution_type, base_buffer_type::size_type> base_type; //! < x[XNX
						Index() : base_type( resolution, 0 ) {} //! < @brief ftHgRXgN^(Ȓlŏ܂)
					private:
						Index( resolution_type first, base_buffer_type::size_type second ) : base_type(first, second) {}
						resolution_type first() const { return base_type::first; }
						base_buffer_type::size_type second() const { return base_type::second; }
					};
					//! @brief Index Ŏw肳ꂽobt@vf(@ref MQ0x::Polygon::UVFaceBuffer::UVPoint "UVPoint")̃AhX擾܂
					//! @return index͈͊ÔƂNULLBȊO͎w肳ꂽuvobt@vfւ̃AhX
					const UVPoint* GetAccessAt( const Index& index ) const {
						if ( ( index.first() < resolution ) && ( index.second() < m_buffer[index.first()].size() ) ) return &(m_buffer[index.first()][index.second()]);
						return NULL;
					}
					//! @brief CӂuvlL^obt@vf(@ref MQ0x::Polygon::UVFaceBuffer::UVPoint "UVPoint")f[^猟A܂͐VKǉăCfbNX擾܂B
					//! @param [in] epsilon uvƂċe鎲̌덷͈́BuvAǂ̎łepsilon菬ꍇAuvWƂ݂ȂB
					//! @return łɓuvlL^ĂꍇÅ̃CfbNXBȊȌꍇ͐VKɒǉꂽCfbNXB
					const Index GetIndexOf( const MQCoordinate &uv, const float epsilon ) {
						const float abs_e = std::abs(epsilon);
						const resolution_type first = std::min( resolution_type(std::max( uv.u * float(resolution), 0.0f)), resolution_type(resolution - 1) );
						const base_buffer_type::size_type size = m_buffer[first].size();
						for ( base_buffer_type::size_type ct = 0; ct < size; ct++ ) {
							const MQCoordinate& buffer_uv = m_buffer[first][ct].uv;
							if ( (std::abs(uv.u - buffer_uv.u) < abs_e) && (std::abs(uv.v - buffer_uv.v) < abs_e) ) return Index( first, ct );
						}
						m_buffer[first].push_back( UVPoint(uv) );
						return Index( first, size );
					}
					/// @brief obt@NA
					/// @param [in] isCompact q[v̈؂l߂邩ǂ
					void Clear( const bool isCompact = false ) {
						for ( int ct = 0; ct < resolution; ct++ ) {
							if ( isCompact ) base_buffer_type().swap( m_buffer[ct] );
							else m_buffer[ct].clear();
						}
					}
					//!@brief svȃq[v̈؂l߂܂B
					void Compact() { for ( int ct = 0; ct < resolution; ct++ ) m_buffer[ct].shrink_to_fit(); }
					//!@brief vfւ̃ANZXB͔͈̏̓`FbNs܂B
					UVPoint& operator [] ( const Index& index ) { return m_buffer[index.first()][index.second()]; }
				};
			};

			//! @brief ʏ\
			struct Face {
				//! @brief ʏ̒_\
				struct Point {
					UVPoint::Buffer::Index index;	//!< @brief uvobt@iuvWjQƂ邽߂̃CfbNX
					uint32_t color;					//!< @brief _F
				};
				
				//! @brief Op`̃Xgi[\̂łB
				struct Buffer {
				private:
					typedef std::vector<Face> buffer_type;
					friend class Polygon::UVFaceBuffer;
				public:
					//! @brief CfbNX^
					typedef buffer_type::size_type Index;
					/// @brief CfbNXobt@^
					/// @details Face::Buffer::IndexBuffer\̂́A@ref Face::Buffer̃CfbNXdȂ悤Ƀobt@\̂łB
					struct IndexBuffer {
						//! @brief CfbNX^
						typedef std::vector<Index>::size_type Index;
						//! @brief ǂݎp̑OiCe[^
						typedef std::vector<Index>::const_iterator ConstIterator;
						//! @brief CfbNXobt@̗vfɃANZX܂B @details ͈͍͌sȂ̂ŁAindexɂ͕K Count() 菬Ȓlw肵ĂB
						Face::Buffer::Index operator[] ( IndexBuffer::Index index ) const { return m_buffer[index]; }
						//! @brief CfbNXobt@ɃCfbNXǉ܂Bɓo^ς݂̃CfbNXꍇ͒ǉ܂B
						//! @return VKɒǉꂽCfbNXB邢͓o^ς݂͊̃CfbNXB
						Face::Buffer::IndexBuffer::Index Add( Face::Buffer::Index index ) {
							IndexBuffer::Index ret;
							if ( Contains( index, &ret ) == false ) {
								ret = m_buffer.size();
								m_buffer.push_back(index);
							}
							return ret;
						}
						//! @brief ǂݎpEOi^Cv̐擪Ce[^Ԃ܂B
						ConstIterator Begin() const { return m_buffer.begin(); }
						//! @brief vf܂B @param [in] src vf @param [out] NULLȊOw肷ƁACfbNXL^܂B	
						bool Contains( const Face::Buffer::Index src, IndexBuffer::Index* find_index = NULL ) const {
							for ( Index index = 0; index < m_buffer.size(); index++ ) {
								if ( m_buffer[index] == src ) { if ( find_index != NULL ) *find_index = index; return true; }
							}
							return false;
						}
						//! @brief vf擾܂
						IndexBuffer::Index Count() const { return m_buffer.size(); }
						//! @brief ǂݎpEOi^Cv̏I[Ce[^Ԃ܂B
						ConstIterator End() const { return m_buffer.end(); }
					private:
						std::vector<Face::Buffer::Index> m_buffer;
					};
					/// @brief vfɃANZX܂B͈͊O̒lQƂNULLԂ܂B
					const Face* operator [] ( Index index ) const { if ( index < m_buffer.size() ) return &m_buffer[index]; return NULL; }
					//! @brief ɗvfǉ܂B
					void Add( const Face& add_item ) { m_buffer.push_back( add_item ); }
					//! @brief 擪̗vfԍԂ܂B݂̂Ƃ0Ԃ܂B
					Index BeginIndex() const { return 0; }
					/// @brief obt@NA܂BisCompacttrueɎw肷ƁAq[v̈؂l߂܂B
					void Clear( const bool isCompact = false ) { if ( isCompact ) std::vector<Face>().swap( m_buffer ); else m_buffer.clear(); }
					//! @brief svȃq[v̈؂l߂܂B
					void Compact() { m_buffer.shrink_to_fit(); }
					//! @brief z̗vfԂ܂B
					Index Count() const { return m_buffer.size(); }
					//! @brief I[̗vfԍԂ܂B̂Ƃz̗vf Count() ɓlԂ܂B
					Index EndIndex() const { return m_buffer.size(); }
					//! @brief q[v̈炩ߗ\񂵂܂B
					void Reserve( const Index size ) { m_buffer.reserve( size ); }
				private:
					buffer_type m_buffer;
				};
				//! @brief ʂۗLIuWFNg̃j[NID
				UINT object_uid;
				//! @brief ʂ̃j[NID
				UINT face_uid;
				//! @brief ʂɊ܂܂钸_Ԃ܂B @details ݂̂Ƃ3܂4Ԃ܂B
				std::size_t PointsCount() const { return m_szPoints; }
				//! @brief Cӂ@ref UVPoint::Buffer::IndexoɎPointvf܂B @return vf̃AhXBȂꍇNULLB
				const Point* GetPointFrom( const UVPoint::Buffer::Index& search_index ) const {
					for ( std::size_t ct = 0; ct < m_szPoints; ct++ ) if ( m_points[ct].index == search_index ) return (m_points + ct);
					return NULL;
				}
				//! @brief ʂɊ܂܂钸_z̗vfɃANZX܂B @details ͈͍͌sȂ̂ŁAKPointsCount()菬Ȓlw肵ĂB
				const Point& Points(std::size_t index) const { return m_points[index]; }
				Face() : m_szPoints(0) {}
			private:
				///@cond
				friend class Polygon::UVFaceBuffer;
				///@endcond
				std::size_t m_szPoints;
				Face::Point m_points[4];
			};

			/// @brief ӏ @details UVWCfbNX̃yAƁAQƌOp`CfbNX̃XgԂ܂B
			struct Edge {
				
				//! @brief UVWCfbNX̃yA
				//! @details [UVWobt@CfbNXێyA\̂łBrPɂ邽߁AɃoɊi[悤ɂĂ܂B
				//! ׁ[XNXfirst/secondoւ̃ANZX͋֎~ĂȂǂݎpoperator[]gēeQƂ܂B
				//! first/secondʂɏ͏oȂ̂ŁAeύX鎞͊ẽI[o[[hꂽZqA܂̓RXgN^𗘗p܂B
				struct VertexPair : public std::pair<UVPoint::Buffer::Index, UVPoint::Buffer::Index> {
					typedef std::pair<UVPoint::Buffer::Index, UVPoint::Buffer::Index> base_type;
					VertexPair( const UVPoint::Buffer::Index& first, const UVPoint::Buffer::Index& second )
						: base_type( std::min(first, second), std::max(first, second) ) {}	///< @brief RXgN^
					VertexPair( const VertexPair& src ) : base_type( src[0], src[1] ) {}	///< @brief Rs[RXgN^
					VertexPair( const UVPoint::Buffer::Index* pSrc ) { *this = pSrc; }		///< @brief RXgN^
					///@biref ZqI[o[[h @param [in] pSrc Œ̗vfIndexzw肵ĂB
					VertexPair& operator = ( const UVPoint::Buffer::Index* pSrc ) {
						if ( pSrc != NULL ) {
							if ( pSrc[0] < pSrc[1] ) {
								base_type::first = pSrc[0];
								base_type::second = pSrc[1];
							}
							else {
								base_type::first = pSrc[1];
								base_type::second = pSrc[0];
							}
						}
						return *this;
					}
					///@biref ZqI[o[[h
					VertexPair& operator = ( const VertexPair& src ) { base_type::first = src[0]; base_type::second = src[1]; return *this; } 
					///@brief vfANZXBindex0w肷ƁAyAo[̂̏ @ref MQ0x::Polygon::UVFaceBuffer::UVPoint::Buffer::Index "UVPoint::Buffer::Index" 擾܂BłȂꍇA傫 UVPoint::Buffer::Index 擾܂B
					UVPoint::Buffer::Index operator [](int index) const { return index == 0 ? base_type::first : base_type::second; }
					///@brief lyAo[Ɋ܂܂Ă邩܂B܂܂ꍇtrueԂ܂B
					bool Contains( const UVPoint::Buffer::Index& index ) const { return (base_type::first == index) || (base_type::second == index); }
				private:
					UVPoint::Buffer::Index first();		// kill access
					UVPoint::Buffer::Index second();	// kill access
				};

				//! @brief ӂ̃Xgi[^
				struct Buffer {
				private:
					typedef std::vector<Edge> buffer_type;
				public:
					typedef buffer_type::const_iterator ConstIterator;	//!< @brief ǂݎp̑OiCe[^BQƂ@ref MQ0x::Polygon::UVFaceBuffer::Edge "Edge"\̂擾ł܂B
					//! @brief Edgevfǉ܂B
					//! @details VertexPairɓo^ς݂̂Ƃ̗͂vfɑ΂indexǉo^܂BłȂꍇ͖ɐVKEdge\̂ǉ܂B
					void Add( const VertexPair& vertex_pair, const Face::Buffer::Index& index );
					ConstIterator Begin() const { return m_buffer.begin(); }	//!< @brief ǂݎpEOi^Cv̐擪Ce[^Ԃ܂B
					/// @brief obt@NA܂BisCompacttrueɎw肷ƁAq[v̈؂l߂܂B
					void Clear( const bool isCompact = false ) { if ( isCompact ) std::vector<Edge>().swap( m_buffer ); else m_buffer.clear(); }
					void Compact() { m_buffer.shrink_to_fit(); }				//!< @brief svȃq[v̈؂l߂܂B
					ConstIterator End() const { return m_buffer.end(); }		//!< @brief ǂݎpEOi^Cv̏I[Ce[^Ԃ܂B
				private:
					buffer_type m_buffer;
				};

				Edge( const VertexPair& v_pair, Face::Buffer::Index face_index ) : m_vertex_pair(v_pair) { m_owner_faces.Add(face_index); }
				Edge( const UVPoint::Buffer::Index* pSrc, Face::Buffer::Index face_index ) : m_vertex_pair(pSrc) {
					if ( pSrc != NULL ) m_owner_faces.Add(face_index);
				}
				/// @brief ێĂ钸_CfbNXyA̓eCӂ̃yAƔr܂B
				bool operator == ( const VertexPair& src ) const { return (const VertexPair::base_type&)m_vertex_pair == (const VertexPair::base_type&)src; }
				/// @brief ێĂ钸_CfbNXyAQƂ܂B
				const VertexPair& IndexPair() const { return m_vertex_pair; }
				/// @brief ێĂ钸_CfbNXyA̗vfi@ref MQ0x::Polygon::UVFaceBuffer::UVPoint::Buffer::Index "UVPoint::Buffer::Index"j擾܂B
				/// @param [in] index 0w肷Ə̃CfbNXԂ܂BȊO͑傫̃CfbNXԂ܂B
				UVPoint::Buffer::Index IndexPair(int index) const { return m_vertex_pair[index]; }
				/// @brief ӂLʂ̃XgAǂݎpŎQƂ܂B
				/// @detailes QƐ́Aʂ̂̂ł͂ȂCfbNX̃obt@iʃobt@̃CfbNX̔zjɂȂĂ܂Bڂ @ref Face::Buffer::IndexBuffer QƂĂB
				const Face::Buffer::IndexBuffer& Owners() const { return m_owner_faces; }
				/// @brief ӂLʂ̃XgAvf擾܂B
				/// @details 擾vf́Aʂ̂̂ł͂Ȃʃobt@̃CfbNXɂȂĂ܂Bڂ @ref Face::Buffer::IndexBuffer QƂĂB
				Face::Buffer::Index Owners( const Face::Buffer::IndexBuffer::Index& index ) const { return m_owner_faces[index]; }
			private:
				///@cond
				friend struct Edge::Buffer;
				///@endcond
				VertexPair m_vertex_pair;
				Face::Buffer::IndexBuffer m_owner_faces;
			};

			struct Functors {
				/// @brief {IUVWϊ֐IuWFNg
				/// @details UVWіʒ_ŗL̒_Fɑ΂ĔCӂ̕ϊs܂Bϊ֐UVobt@ւ̓o^OɎsAϊUVWUVobt@ɓo^܂B
				struct BasicUVTransformFunctor {
					///@brief ϊt@N^
					///@param [in,out]	uv_coorinates	UVWzւ̃ANZX
					///@param [in,out]	colors			_Fzւ̃ANZX
					///@param [in]		obj				I[i[IuWFNg
					///@param [in]		count			uv_coorinates/colors/point_normals̔z(3܂4)
					///@param [in]		face_index		I[i[ʂ̃CfbNX
					///@param [in]		face_uid		I[i[ʂ̃j[NID
					///@return ̖ʂLUVƂꍇtrueBłȂfalseBʏtrueԂ܂BႦ΂܂ɂUV|S𖳎ȂǂfalseԂo܂B
					bool operator()( MQCoordinate* const uv_coorinates, DWORD* const colors,
						const MQObject obj, const int count_of_points, const int face_index, const UINT face_uid ) { return true; }
				};
				
				/// @brief @f[^tUVWϊ֐IuWFNg
				/// @details UVWіʒ_ŗL̒_Fɑ΂ĔCӂ̕ϊs܂Bϊ֐UVobt@ւ̓o^OɎsAϊUVWUVobt@ɓo^܂B
				struct NormaledUVTransformFunctor {
					///@brief ϊt@N^
					///@param [in,out]	uv_coorinates	UVWzւ̃ANZX
					///@param [in,out]	colors			_Fzւ̃ANZX
					///@param [in]		obj				I[i[IuWFNg
					///@param [in]		count			uv_coorinates/colors/point_normals̔z(3܂4)
					///@param [in]		face_index		I[i[ʂ̃CfbNX
					///@param [in]		face_uid		I[i[ʂ̃j[NID
					///@param [in]		normal			ʖ@ւ̃ANZX(uvWnł͂Ȃ̃f̖@)
					///@param [in]		point_normals	Kς݂̒_@zւ̃ANZX(uvWnł͂Ȃ̃f̖@ŁA_Lʖ@̕σxNg)
					///@return ̖ʂLUVƂꍇtrueBłȂfalseBʏtrueԂ܂BႦ΂܂ɂUV|S𖳎ȂǂfalseԂo܂B
					bool operator()( MQCoordinate* const uv_coorinates, DWORD* const colors,
						const MQObject obj, const int count_of_points, const int face_index, const UINT face_uid,
						const MQPoint& normal, MQPoint* const point_normals ) { return true; }
				};

				template <class _NormaledCoordinateTransformFunctor> struct CoordinateTransformFunctorFromNormaled {
					_NormaledCoordinateTransformFunctor functor;
					//! @brief BasicUVTransformFunctor^CṽX^_[hȃt@N^
					bool operator()(
						MQCoordinate* const uv_coorinates, DWORD* const colors,
						const MQObject obj, const int count_of_points, const int face_index, const UINT face_uid )
					{
						MQPoint v_normal_buffer[4];
						int v_index_buffer[4];
						obj->GetFacePointArray( face_index, v_index_buffer );
						for ( int ctFacePoint = 0; ctFacePoint < count_of_points; ctFacePoint++ ) {
							v_normal_buffer[ctFacePoint] = m_normal_buffer.VertexNormal( VertexNormalBuffer::size_type(v_index_buffer[ctFacePoint]) );
						}
						return functor( uv_coorinates, colors, obj, count_of_points, face_index, face_uid, m_normal_buffer.FaceNormal(face_index), v_normal_buffer );
					}
				private:
					VertexNormalBuffer m_normal_buffer;
				};
			};

			/// @brief ftHgRXgN^
			UVFaceBuffer() : m_epsilon( std::numeric_limits<float>::epsilon() ) {}

			//! @brief VIuWFNgǉ͂܂Bt@N^w肵āAobt@o^OUVϊs܂B
			//! @param coordinateTrans ϊt@N^w肵܂Bnׂt@N^Functors::BasicUVTransformFunctorfɂĂB
			template <class _BasicUVTransformFunctor> void AddObject( const MQObject obj, _BasicUVTransformFunctor& coordinateTrans ) {
				if ( obj == NULL ) return;
				MQCoordinate coordinate_buffer[4];
				DWORD vertex_color_buffer[4];
				Face add_face;
				const int ctFaceMax = obj->GetFaceCount();
				const UINT obj_uid = obj->GetUniqueID();
				const float eps = m_epsilon;
				m_face_buffer.Reserve( m_face_buffer.Count() + (Face::Buffer::Index)ctFaceMax );
				add_face.object_uid = obj_uid;
				for ( int ctFace = 0; ctFace < ctFaceMax; ctFace++ ) {
					const UINT uidFace = obj->GetFaceUniqueID( ctFace );
					const int ctFacePointMax = obj->GetFacePointCount( ctFace );
					if ( (ctFacePointMax<3)||(4<ctFacePointMax) ) continue;
					obj->GetFaceCoordinateArray( ctFace, coordinate_buffer );
					for ( int ctFacePoint = 0; ctFacePoint < ctFacePointMax; ctFacePoint++ ) {
						vertex_color_buffer[ctFacePoint] = obj->GetFaceVertexColor( ctFace, ctFacePoint );
					}
					if ( coordinateTrans( coordinate_buffer, vertex_color_buffer, obj, ctFacePointMax, ctFace, uidFace ) == false ) continue;
					add_face.face_uid = uidFace;
					add_face.m_szPoints = ctFacePointMax;
					for ( int ctFacePoint = 0; ctFacePoint < ctFacePointMax; ctFacePoint++ ) {
						add_face.m_points[ctFacePoint].index = m_uv_buffer.GetIndexOf( coordinate_buffer[ctFacePoint], eps );
						add_face.m_points[ctFacePoint].color = vertex_color_buffer[ctFacePoint];
					}
					m_face_buffer.Add(add_face);
					for ( int ctFacePoint = 0; ctFacePoint < ctFacePointMax; ctFacePoint++ ) {
						int ctFacePointNext = (ctFacePoint < (ctFacePointMax-1)) ? ctFacePoint + 1 : 0;
						const Edge::VertexPair add_edge( add_face.m_points[ctFacePoint].index, add_face.m_points[ctFacePointNext].index );
						m_edge_buffer.Add( add_edge, m_face_buffer.Count()-1 );
					}
				}
			}
			/// @brief VIuWFNgǉ͂܂Bobt@o^OUVϊ͍s܂B
			void AddObject( const MQObject obj ) { AddObject( obj, Functors::BasicUVTransformFunctor() ); }
			/// @brief VIuWFNgǉ͂܂iċAIɒǉ܂jBFunctors::BasicUVTransformFunctorƓ`operator()Cӂ̃t@N^`w肵āAobt@o^OUVϊs܂B
			template <class _BasicUVTransformFunctor> void AddObjectRecursive(const MQDocument doc, const MQObject obj, _BasicUVTransformFunctor& coordinateTrans)
			{
				if ( (doc == NULL) || (obj == NULL) ) return;
				AddObject( obj, coordinateTrans );
				const int ctChild = doc->GetChildObjectCount(obj);
				for ( int indexCh = 0; indexCh < ctChild; indexCh++ ) AddObjectRecursive( doc, doc->GetChildObject( obj, indexCh ), coordinateTrans );
			}
			/// @brief VIuWFNgǉ͂܂iċAIɒǉ܂jBobt@o^OUVϊ͍s܂B
			void AddObjectRecursive(const MQDocument doc, const MQObject obj) { AddObjectRecursive(doc, obj, Functors::BasicUVTransformFunctor()); }

			/// @brief LbVꂽUVSăNA܂B
			/// @param [in] isCompact q[v̈؂l߂邩ǂ
			void Clear( const bool isCompact = false ) { m_edge_buffer.Clear(isCompact); m_face_buffer.Clear(isCompact); m_uv_buffer.Clear(isCompact); }
			/// @brief svȃq[v̈؂l߂܂B
			void Compact() { m_uv_buffer.Compact(); m_face_buffer.Compact(); m_edge_buffer.Compact(); }
			/// @brief Edge \(ӏ)obt@ǂݎpŎQƂ܂B
			const Edge::Buffer& EdgeBuffer() const { return m_edge_buffer; }
			//! @brief UVẄv臒lłBu,vꂼ̎ō臒l菬ΈvƂ݂Ȃ܂BftHgłstd::numeric_limits<float>::epsilon()ݒ肳܂B
			float Epsilon() const { return m_epsilon; }
			/// @brief Cӂ Epsilon() o^܂B
			float Epsilon( float setValue ) { return m_epsilon = std::abs(setValue); }
			/// @brief Op`Xgf[^擾܂iCfbNXXg͈͊O̎NULLj
			const Face* FaceBuffer( const Face::Buffer::Index& index ) const { return m_face_buffer[index]; }
			/// @brief Op`XgǂݎpŎQƂ܂B
			const Face::Buffer& FaceBuffer() const { return m_face_buffer; }
			//! @brief UVWobt@f[^擾܂iCfbNXobt@͈͊O̎NULLj
			const UVPoint* UVBuffer( const UVPoint::Buffer::Index& index ) const { return m_uv_buffer.GetAccessAt(index); }

		private:
			float m_epsilon;
			UVPoint::Buffer m_uv_buffer;
			Face::Buffer m_face_buffer;
			Edge::Buffer m_edge_buffer;
		};
		/// @}
		/// @}

		///@cond
		inline void UVFaceBuffer::Edge::Buffer::Add( const Edge::VertexPair& vertex_pair, const Face::Buffer::Index& index ) {
			for ( buffer_type::iterator itr = m_buffer.begin(); itr != m_buffer.end(); itr++ ) {
				if ( *itr == vertex_pair ) { itr->m_owner_faces.Add( index ); return; }
			}
			m_buffer.push_back( Edge(vertex_pair, index ) );
		}
		///@endcond
	}

	/*!	@name O[o
		@{ */

	//! @brief e̖O擾֐ɂāAϒobt@TCY̍ŒᏉl̃ftHg`B
#ifdef _DEBUG 
	static const std::vector<char>::size_type GetNameInitialBufferSize = 2;
#else
	static const std::vector<char>::size_type GetNameInitialBufferSize = 32;
#endif

	//! @brief hLg}eA폜B
	//! @return NULL܂̓j[NID̈v}eAȂꍇ͍폜s킸falseԂ܂BȊOtrue
	inline bool DeleteMaterial( const MQDocument doc, const MQMaterial mat ) {
		int index = prv_impl::GetIdentifiedIndex(doc, mat);
		if ( index < 0 ) return false;
		doc->DeleteMaterial(index); return true;
	}
	//! @brief hLgIuWFNg폜B
	//! @return NULL܂̓j[NID̈vIuWFNgȂꍇ͍폜s킸falseԂ܂BȊOtrue
	inline bool DeleteObject( const MQDocument doc, const MQObject obj ) {
		int index = prv_impl::GetIdentifiedIndex(doc, obj);
		if ( index < 0 ) return false;
		doc->DeleteObject(index); return true;
	}
	/*!	@brief }eAN[̂߂́AJEgAbvꂽdȂʖ擾
		@return ȂƂT_ŏdȂʖ╶BNULLw肳ȂǃG[ɂ͋̕񂪕ԂB
		@par ʖ̖K
		jobj > obj1 | obj00 > obj01 | obj0.99 > obj0.100
		- d͉
		- ̖O̖ɐꍇ'1't^B
		- ̖O̖0-9̐񂪂ꍇ́A+1B0-9ȊOAႦΏ_Ȃǂ͐l`ƂĂ͍lȂB
		- N[▼̖̌́A̖O̖̐ƓꌅB
		.
		@attention MQSDK Rev3.10MQDocument::GetUnusedMaterialName()ǉ܂B̊֐͉ʌ݊AэMQxƎdlƂĎc܂B
		@date 2013.02.04 MQSDK Rev3.10Ή
		*/
	inline std::string GetCountUpCloneableUniqueName( const MQDocument doc, const MQMaterial src, std::vector<char>* const buf = NULL ) {
		return prv_impl::GetCountUpCloneableUniqueName(doc,src,buf);
	}
	/*!	@brief IuWFNgN[̂߂́AJEgAbvꂽdȂʖ擾
		@return ȂƂT_ŏdȂʖ╶BNULLw肳ȂǃG[ɂ͋̕񂪕ԂB
		@par ʖ̖K
		jobj > obj1 | obj00 > obj01 | obj0.99 > obj0.100
		- d͉
		- ̖O̖ɐꍇ'1't^B
		- ̖O̖0-9̐񂪂ꍇ́A+1B0-9ȊOAႦΏ_Ȃǂ͐l`ƂĂ͍lȂB
		- N[▼̖̌́A̖O̖̐ƓꌅB
		.
		@attention MQSDK Rev3.10MQDocument::GetUnuseObjectName()ǉ܂B̊֐͉ʌ݊AэMQxƎdlƂĎc܂B
		@date 2013.02.04 MQSDK Rev3.10Ή
	*/
	inline std::string GetCountUpCloneableUniqueName( const MQDocument doc, const MQObject src, std::vector<char>* const buf = NULL ) {
		return prv_impl::GetCountUpCloneableUniqueName(doc,src,buf);
	}
	//! @brief hLgɓo^Ă}eA𖼑OŌ
	//! @return }eABȂꍇNULLB
	inline MQMaterial GetMaterial( const MQDocument doc, const char* name ) { return prv_impl::GetNamed<MQMaterial>( doc, name ); }
	//! @brief hLgɓo^Ă}eAj[NIDŌ
	//! @return }eABȂꍇNULLB
	//! @attention MQSDK Rev3.10MQDocument::GetMaterialFromUniqueID()ǉ܂B̊֐͉ʌ݊̂߂ɎcĂ܂B
	//!	@date 2013.02.04 MQSDK Rev3.10Ή
	inline MQMaterial GetMaterial( const MQDocument doc, const UINT id ) {
		#if 0x0310 <= MQPLUGIN_VERSION
			if ( doc != NULL ) return doc->GetMaterialFromUniqueID(id);
			return NULL;
		#else
			return prv_impl::GetIdentified<MQMaterial>( doc, id );
		#endif
	}
	
	/// @cond
	std::string GetMaterialTextureName( const MQMaterial, DWORD );
	/// @endcond

	/// @brief eNX`̃t@CpX擾B GetMaterialTextureName()  map_type  MQMAPPING_ALPHA w肷̂ƓłB
	inline std::string GetMaterialAlphaName( const MQMaterial mat ) { return GetMaterialTextureName(mat,MQMAPPING_ALPHA); }
	/// @brief ʉeNX`̃t@CpX擾B GetMaterialTextureName()  map_type  MQMAPPING_BUMP w肷̂ƓłB
	inline std::string GetMaterialBumpName( const MQMaterial mat ) { return GetMaterialTextureName(mat,MQMAPPING_BUMP); }
	/// @brief hLgɓo^Ă}eA𖼑OŌB
	/// @return }eÃCfbNXBȂꍇ-1
	inline int GetMaterialIndex( const MQDocument doc, const char* name ) { return prv_impl::GetNamedIndex<MQMaterial>( doc, name ); }
	/// @brief hLgɓo^Ă}eAj[NIDŌB
	/// @return }eÃCfbNXBȂꍇ-1
	inline int GetMaterialIndex( const MQDocument doc, const UINT id ) { return prv_impl::GetIdentifiedIndex<MQMaterial>( doc, id ); }
	/*! @brief eNX`̃t@CpX擾B
	@param map_type 擾eNX`̎ނw肷
	- MQMAPPING_TEXTURE / MQMaterial::GetTextureName()ĂяoĖ͗l摜pX擾
	- MQMAPPING_ALPHA / MQMaterial::GetAlphaName()Ăяoē摜pX擾
	- MQMAPPING_BUMP / MQMaterial::GetBumpName()Ăяoēʉ摜pX擾
	@return }bsÕt@C𑊑΃pXŎ擾܂iX΃pXŎw肳Ăꍇ͐΃pXԂ邻łjBX摜ݒ肳ĂȂA邢matNULLw肷ȂǂȂ炩̎sɂ́A̕񂪕Ԃ܂B
	@details ꂽt@C΃pXɕϊɂMQDocument::FindMappingFile()gp܂B*/
	inline std::string GetMaterialTextureName( const MQMaterial mat, const DWORD map_type = MQMAPPING_TEXTURE ) {
		if ( mat != NULL )
		{
			std::vector<char> buf;
			prv_impl::GetMaterialTextureName(&buf, mat, map_type);
			return std::string(&buf[0]);
		}
		return "";
	}
	/// @brief }eA̖O擾B
	/// @return }eA̖OBNULLw肳ȂǁAG[ɂ͋̕B
	inline std::string GetName( const MQMaterial mat ){ return prv_impl::GetName( mat ); }
	/// @brief IuWFNg̖O擾
	/// @return IuWFNg̖OBNULLw肳ȂǁAG[ɂ͋̕B
	inline std::string GetName( const MQObject obj ){ return prv_impl::GetName( obj ); }
	//! @brief hLgɓo^ĂIuWFNg𖼑OŌ
	//! @return IuWFNgBȂꍇNULLB
	inline MQObject GetObject( const MQDocument doc, const char* name ) { return prv_impl::GetNamed<MQObject>( doc, name ); }
	//! @brief hLgɓo^ĂIuWFNgj[NIDŌ
	//! @return IuWFNgBȂꍇNULLB
	//! @attention MQSDK Rev3.10MQDocument::GetObjectFromUniqueID()ǉ܂B̊֐͉ʌ݊̂߂ɎcĂ܂B
	//!	@date 2013.02.04 MQSDK Rev3.10Ή
	inline MQObject GetObject( const MQDocument doc, const UINT id ) {
		#if 0x0310 <= MQPLUGIN_VERSION
			if ( doc != NULL ) return doc->GetObjectFromUniqueID(id);
			return NULL;
		#else
			return prv_impl::GetIdentified<MQObject>(doc, id );
		#endif
	}
	//! @brief hLgɓo^ĂIuWFNg𖼑OŌ
	/// @return IuWFNg̃CfbNXBȂꍇ-1
	inline int GetObjectIndex( const MQDocument doc, const char* name ) { return prv_impl::GetNamedIndex<MQObject>( doc, name ); }
	/// @brief hLgɓo^ĂIuWFNgj[NIDŌB
	/// @return IuWFNg̃CfbNXBȂꍇ-1
	inline int GetObjectIndex( const MQDocument doc, const UINT id ) { return prv_impl::GetIdentifiedIndex<MQObject>(doc, id ); }

#if 0x0310 <= MQPLUGIN_VERSION

	/// @brief hLgɓo^ĂȂ}eA擾iMQDocument::GetUnusedMaterialNamẽbp[֐jB
	/// @return 擾BdocNULL̎͋̕B
	/// @attention MQSDK Rev3.10 痘p\
	inline std::string GetUnusedMaterialName( const MQDocument doc, const char* base_name = NULL ) {
		return prv_impl::GetUnusedNameString<MQMaterial>( doc, base_name );
	}
	/// @brief hLgɓo^ĂȂ}eA擾iMQDocument::GetUnusedMaterialNamẽbp[֐jB
	/// @param base_name_material ̖Ow肷}eABNULLŏȗbase_nameNULLɂMQDocument::GetUnusedMaterialNameĂяôƓB
	/// @return 擾BdocNULL̎͋̕B
	/// @attention MQSDK Rev3.10 痘p\
	inline std::string GetUnusedMaterialName( const MQDocument doc, const MQMaterial base_name_material ) {
		if ( base_name_material == NULL ) return prv_impl::GetUnusedNameString<MQMaterial>( doc );
		return prv_impl::GetUnusedNameString<MQMaterial>( doc, GetName( base_name_material ).c_str() );
	}
	/// @brief hLgɓo^ĂȂIuWFNg擾iMQDocument::GetUnusedObjectNamẽbp[֐jB
	/// @return 擾BdocNULL̎͋̕B
	/// @attention MQSDK Rev3.10 痘p\
	inline std::string GetUnusedObjectName( const MQDocument doc, const char* base_name = NULL ) {
		return prv_impl::GetUnusedNameString<MQObject>( doc, base_name );
	}
	/// @brief hLgɓo^ĂȂIuWFNg擾iMQDocument::GetUnusedObjectNamẽbp[֐jB
	/// @param base_name_object ̖Ow肷}eABNULLŏȗbase_nameNULLɂMQDocument::GetUnusedObjectNameĂяôƓB
	/// @return 擾BdocNULL̎͋̕B
	/// @attention MQSDK Rev3.10 痘p\
	inline std::string GetUnusedObjectName( const MQDocument doc, const MQObject base_name_object ) {
		if ( base_name_object == NULL ) return prv_impl::GetUnusedNameString<MQMaterial>( doc );
		return prv_impl::GetUnusedNameString<MQMaterial>( doc, GetName( base_name_object ).c_str() );
	}
	
#endif

	//! @}

	//! @}

	namespace prv_impl {}; // kill prv_impl access ( to private header implement trap )
};

#endif