/*
 * Decompiled with CFR 0.152.
 */
package nekora.cwn.paper;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import nekora.cwn.paper.PaperFormException;
import nekora.cwn.paper.ParcePixel;
import nekora.cwn.paper.UNIT;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class InputPaper {
    final int GOSA = 10;
    Logger logger;
    File f;
    int dpi;
    Rectangle paper;
    Rectangle outer;
    Rectangle inner;
    Rectangle cropR;
    Point putR;
    Rectangle cropL;
    Point putL;
    Rectangle cropC;
    Point putC;

    public InputPaper(File f, int dpi, Logger logger) throws Exception {
        this.f = f;
        this.dpi = dpi;
        this.logger = logger;
        this.paper = new Rectangle();
        this.outer = new Rectangle();
        this.inner = new Rectangle();
        try {
            this.readConfig(f, dpi);
        }
        catch (IOException | JDOMException e) {
            logger.log(Level.WARNING, "XML\u30d5\u30a1\u30a4\u30eb\u51e6\u7406\u5931\u6557.\u30d5\u30a1\u30a4\u30eb\uff1d" + f.getName() + " DPI=" + dpi, e);
            throw e;
        }
    }

    public void computeLR(int w, int h) {
        this.logger.info("W=" + w + " H=" + h);
        this.cropR = new Rectangle();
        this.putR = new Point();
        this.cropR.x = this.outer.x;
        this.putR.x = w / 2;
        if (Math.abs(h - this.paper.height) < 10) {
            this.logger.info("\u51fa\u529b\u7d19\u306e\u9ad8\u3055\uff1d\u5165\u529b\u7d19\u306e\u9ad8\u3055");
            this.cropR.y = this.paper.y;
            this.cropR.height = this.paper.height;
            this.putR.y = 0;
        } else if (Math.abs(h - this.outer.height) < 10) {
            this.logger.info("\u51fa\u529b\u7d19\u306e\u9ad8\u3055\uff1d\u5916\u67a0\u306e\u9ad8\u3055");
            this.cropR.y = this.outer.y;
            this.cropR.height = this.outer.height;
            this.putR.y = 0;
        } else if (Math.abs(h - this.inner.height) < 10) {
            this.logger.info("\u51fa\u529b\u7d19\u306e\u9ad8\u3055\uff1d\u5185\u67a0\u306e\u9ad8\u3055");
            this.cropR.y = this.inner.y;
            this.cropR.height = this.inner.height;
            this.putR.y = 0;
        } else {
            this.logger.info("\u51fa\u529b\u7d19\u306e\u9ad8\u3055\uff1d\u305d\u306e\u4ed6\u306a\u306e\u3067\u5185\u67a0\u3068\u51fa\u529b\u7d19\u306e\u4e2d\u5fc3\u3092\u5408\u308f\u305b\u308b");
            double a = this.inner.y + this.inner.height / 2;
            double b = h / 2;
            this.cropR.y = (int)Math.round(a - b);
            if (h <= this.paper.height) {
                this.cropR.height = h;
                this.putR.y = 0;
            } else {
                this.cropR.height = this.paper.height;
                this.putR.y = (h - this.paper.height) / 2;
            }
        }
        int rw = this.paper.width - this.inner.x;
        this.cropR.width = w >= rw ? rw : w / 2;
        this.cropL = new Rectangle();
        this.cropL.width = this.cropR.width;
        this.cropL.height = this.cropR.height;
        this.cropL.x = w >= rw ? 0 : this.cropL.width - w / 2;
        this.cropL.y = this.cropR.y;
        this.putL = new Point();
        this.putL.y = this.putR.y;
        this.putL.x = this.putR.x - this.cropR.width;
        this.logger.info("cropL=" + this.cropL + " cropR=" + this.cropR + " putL=" + this.putL + " putR=" + this.putR);
    }

    public void computeC(int w, int h) {
        double b;
        double a;
        this.logger.info("W=" + w + " H=" + h);
        this.cropC = new Rectangle();
        this.putC = new Point();
        if (Math.abs(w - this.paper.width) < 10) {
            this.logger.info("\u51fa\u529b\u7d19\u306e\u5e45\uff1d\u5165\u529b\u7d19\u306e\u5e45");
            this.cropC.x = this.paper.x;
            this.cropC.width = this.paper.width;
            this.putC.x = 0;
        } else if (Math.abs(w - this.outer.width) < 10) {
            this.logger.info("\u51fa\u529b\u7d19\u306e\u5e45\uff1d\u5916\u67a0\u306e\u5e45");
            this.cropC.x = this.outer.x;
            this.cropC.width = this.outer.width;
            this.putC.x = 0;
        } else if (Math.abs(w - this.inner.width) < 10) {
            this.logger.info("\u51fa\u529b\u7d19\u306e\u5e45\uff1d\u5185\u67a0\u306e\u5e45");
            this.cropC.x = this.inner.x;
            this.cropC.width = this.inner.width;
            this.putC.x = 0;
        } else {
            this.logger.info("\u51fa\u529b\u7d19\u306e\u5e45\uff1d\u305d\u306e\u4ed6\u306a\u306e\u3067\u5185\u67a0\u3068\u51fa\u529b\u7d19\u306e\u4e2d\u5fc3\u3092\u5408\u308f\u305b\u308b");
            a = this.inner.x + this.inner.width / 2;
            b = w / 2;
            this.cropC.x = (int)((double)this.inner.x + (a - b) / 2.0);
            if (w < this.paper.width) {
                this.cropC.width = w;
                this.putC.x = 0;
            } else {
                this.cropC.width = this.paper.width;
                this.putC.x = (h - this.paper.width) / 2;
            }
        }
        if (Math.abs(h - this.paper.height) < 10) {
            this.logger.info("\u51fa\u529b\u7d19\u306e\u9ad8\u3055\uff1d\u5165\u529b\u7d19\u306e\u9ad8\u3055");
            this.cropC.y = this.paper.y;
            this.cropC.height = this.paper.height;
            this.putC.y = 0;
        } else if (Math.abs(h - this.outer.height) < 10) {
            this.logger.info("\u51fa\u529b\u7d19\u306e\u9ad8\u3055\uff1d\u5916\u67a0\u306e\u9ad8\u3055");
            this.cropC.y = this.outer.y;
            this.cropC.height = this.outer.height;
            this.putC.y = 0;
        } else if (Math.abs(h - this.inner.height) < 10) {
            this.logger.info("\u51fa\u529b\u7d19\u306e\u9ad8\u3055\uff1d\u5185\u67a0\u306e\u9ad8\u3055");
            this.cropC.y = this.inner.y;
            this.cropC.height = this.inner.height;
            this.putC.y = 0;
        } else {
            this.logger.info("\u51fa\u529b\u7d19\u306e\u9ad8\u3055\uff1d\u305d\u306e\u4ed6\u306a\u306e\u3067\u5185\u67a0\u3068\u51fa\u529b\u7d19\u306e\u4e2d\u5fc3\u3092\u5408\u308f\u305b\u308b");
            a = this.inner.y + this.inner.height / 2;
            b = h / 2;
            this.cropC.y = (int)Math.round(a - b);
            if (h < this.paper.height) {
                this.cropC.height = h;
                this.putC.y = 0;
            } else {
                this.cropC.height = this.paper.height;
                this.putC.y = (h - this.paper.height) / 2;
            }
        }
        this.logger.info("cropC=" + this.cropC + " putC=" + this.putC);
    }

    public Rectangle getCropR() {
        return this.cropR;
    }

    public Rectangle getCropL() {
        return this.cropL;
    }

    public Point getPutR() {
        return this.putR;
    }

    public Point getPutL() {
        return this.putL;
    }

    public Rectangle getCropC() {
        return this.cropC;
    }

    public Point getPutC() {
        return this.putC;
    }

    private void readConfig(File f, int dpi) throws Exception {
        Element root;
        this.logger.info("File=" + f.getCanonicalPath() + " dpi=" + dpi);
        Document doc = new SAXBuilder().build(f);
        Element paperElement = root = doc.getRootElement();
        String str_unit = paperElement.getAttributeValue("unit");
        if (str_unit == null) {
            PaperFormException pfe = new PaperFormException("paper\u30bf\u30b0\u5185\u306b unit\u30a2\u30c8\u30ea\u30d3\u30e5\u30fc\u30c8\u304c\u7121\u3044", f, dpi, "<paper>");
            throw pfe;
        }
        UNIT unit = UNIT.pixel;
        int paper_dpi = -1;
        switch (str_unit) {
            case "mm": {
                unit = UNIT.mm;
                break;
            }
            case "inch": {
                unit = UNIT.inch;
                break;
            }
            case "pixel": {
                unit = UNIT.pixel;
                try {
                    paper_dpi = Integer.parseInt(paperElement.getAttributeValue("dpi"));
                    break;
                }
                catch (Exception e) {
                    PaperFormException pfe = new PaperFormException(e, f, dpi, "<paper>");
                    throw pfe;
                }
            }
            default: {
                PaperFormException pfe = new PaperFormException("paper\u30bf\u30b0\u5185\u306eunit\u30a2\u30c8\u30ea\u30d3\u30e5\u30fc\u30c8\u304c\u4e0d\u6b63\uff1d" + str_unit, f, dpi, "<paper>");
                throw pfe;
            }
        }
        ParcePixel px = new ParcePixel(unit, paper_dpi, dpi, this.logger);
        this.paper.x = 0;
        this.paper.y = 0;
        try {
            this.paper.width = px.parce(paperElement.getAttributeValue("width"));
            this.paper.height = px.parce(paperElement.getAttributeValue("height"));
        }
        catch (Exception e) {
            PaperFormException pfe = new PaperFormException(e, f, dpi, "<paper>");
            throw pfe;
        }
        Element outerElement = root.getChild("outer");
        if (outerElement == null) {
            PaperFormException pfe = new PaperFormException("outer\u30bf\u30b0\u304c\u7121\u3044", f, dpi, "<outer>");
            throw pfe;
        }
        try {
            this.outer.x = px.parce(outerElement.getAttributeValue("x1"));
            this.outer.y = px.parce(outerElement.getAttributeValue("y1"));
            this.outer.width = px.parce(outerElement.getAttributeValue("x2")) - this.outer.x;
            this.outer.height = px.parce(outerElement.getAttributeValue("y2")) - this.outer.y;
        }
        catch (Exception e) {
            PaperFormException pfe = new PaperFormException(e, f, dpi, "<outer>");
            throw pfe;
        }
        Element innerElement = root.getChild("inner");
        if (innerElement == null) {
            PaperFormException pfe = new PaperFormException("inner\u30bf\u30b0\u304c\u7121\u3044", f, dpi, "<inner>");
            throw pfe;
        }
        try {
            this.inner.x = px.parce(innerElement.getAttributeValue("x1"));
            this.inner.y = px.parce(innerElement.getAttributeValue("y1"));
            this.inner.width = px.parce(innerElement.getAttributeValue("x2")) - this.inner.x;
            this.inner.height = px.parce(innerElement.getAttributeValue("y2")) - this.inner.y;
        }
        catch (Exception e) {
            PaperFormException pfe = new PaperFormException(e, f, dpi, "<inner>");
            throw pfe;
        }
        String msg = "\u7528\u7d19\u5168\u4f53\uff1d" + this.paper + " \u5916\u67a0\uff1d" + this.outer + " \u5185\u67a0\uff1d" + this.inner;
        this.logger.info(msg);
    }
}

