/*
 * Decompiled with CFR 0.152.
 */
package nekora.cwn.align;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import nekora.cwn.align.PageAlign;
import nekora.cwn.align.PageAlignBag;
import nekora.cwn.align.PageAlignBendDouble;
import nekora.cwn.align.PageAlignCenterBend;
import nekora.cwn.align.PageAlignCutDouble;
import nekora.cwn.align.PageAlignSingle;

public class PageAlignFactory {
    public static PageAlign createPageAlign(List<File> flist, String name, Logger logger) {
        PageAlign ret = null;
        switch (name) {
            case "\u888b\u7db4\u3058\u7247\u9762\u5370\u5237\u7528": {
                ret = new PageAlignBag(flist, logger);
                break;
            }
            case "\u6298\u308a\u7db4\u3058\u4e21\u9762\u7528": {
                ret = new PageAlignBendDouble(flist, logger);
                break;
            }
            case "\u4e2d\u7db4\u3058\u4e21\u9762\u7528": {
                ret = new PageAlignCenterBend(flist, logger);
                break;
            }
            case "\u4e2d\u592e\u88c1\u65ad\u4e21\u9762\u5370\u5237\u7528": {
                ret = new PageAlignCutDouble(flist, logger);
                break;
            }
            case "\uff11\u679a\u305a\u3064": {
                ret = new PageAlignSingle(flist, logger);
            }
        }
        return ret;
    }

    public static List<String> getNameList() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("\u888b\u7db4\u3058\u7247\u9762\u5370\u5237\u7528");
        ret.add("\u6298\u308a\u7db4\u3058\u4e21\u9762\u7528");
        ret.add("\u4e2d\u7db4\u3058\u4e21\u9762\u7528");
        ret.add("\u4e2d\u592e\u88c1\u65ad\u4e21\u9762\u5370\u5237\u7528");
        ret.add("\uff11\u679a\u305a\u3064");
        return ret;
    }

    public static String getDefaultName() {
        return "\u4e2d\u592e\u88c1\u65ad\u4e21\u9762\u5370\u5237\u7528";
    }
}

