/*
 * Decompiled with CFR 0.152.
 */
package nekora.cwn;

import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.prefs.Preferences;
import javafx.application.Application;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.layout.VBoxBuilder;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import jfx.messagebox.MessageBox;
import nekora.cwn.MDPSTask;
import nekora.cwn.align.PageAlign;
import nekora.cwn.align.PageAlignFactory;
import nekora.cwn.ext.ExtCmd;
import nekora.cwn.ext.ExtCmdFactory;
import nekora.cwn.paper.InputPaper;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class MDPSMain
extends Application {
    private final String INPUT_CONFIG_DIR = "./confinputfile";
    private final String OUTPUT_CONFIG_DIR = "./confoutputfile";
    private final String ROOT_TITLE = "\u9762\u4ed8\u3051\u30bd\u30d5\u30c8 for ComicWorks NEO\u306a\u3069";
    private final String PROP_NAME = "nekora/MDPSprocess";
    private final int ROOT_WIDTH = 480;
    private final int ROOT_HEIGHT = 360;
    private final int LABEL_MARGIN_TOP = 12;
    private final int LABEL_MARGIN_BOTOM = 12;
    private final int LABEL_MARGIN_RIGHT = 6;
    private final int LABEL_MARGIN_LEFT = 6;
    private final int[] DPI_TYPES = new int[]{1200, 720, 600, 350, 300, 150, 96, 72};
    private final int L_PAGE = 0;
    private final int R_PAGE = 1;
    private final int ALL_PAGE = 2;
    File[] inputFileConfigs;
    File curConfFile;
    ComboBox<String> cmbPaperType;
    ComboBox<String> cmbDpi;
    TextField inputField;
    TextField outputField;
    TextField borderField;
    String inputDirName;
    String outputDirName;
    ComboBox<String> cmbPosition;
    ComboBox<String> cmbOutFormat;
    File[] outputFileConfigs;
    File curOutConfFile;
    ComboBox<String> cmbOutSize;
    Button execButton;
    ProgressBar progressBar;
    Text statusBar;
    boolean executing_flg = false;
    Logger logger;
    Stage rootStage;

    public MDPSMain() {
        String logname = "log/MDPSprocess";
        this.logger = Logger.getLogger(logname);
        try {
            FileHandler fileHandler = new FileHandler(String.valueOf(logname) + "%g.log", 100000, 9);
            fileHandler.setFormatter(new SimpleFormatter());
            this.logger.addHandler(fileHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    public void stop() throws Exception {
        this.savePreferences();
    }

    public void start(Stage rootStage) throws Exception {
        Object name;
        this.loadPreferences();
        File dir = new File("./confinputfile");
        this.inputFileConfigs = dir.listFiles();
        File diro = new File("./confoutputfile");
        this.outputFileConfigs = diro.listFiles();
        this.rootStage = rootStage;
        rootStage.setTitle("\u9762\u4ed8\u3051\u30bd\u30d5\u30c8 for ComicWorks NEO\u306a\u3069");
        BorderPane rootPane = new BorderPane();
        Label topLabel = new Label("\u5229\u7528\u306b\u306fImageMagic Q8 DLL\u306e\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u304c\u5fc5\u8981");
        topLabel.setStyle("-jx-background-color:mistyrose");
        BorderPane.setAlignment((Node)topLabel, (Pos)Pos.CENTER);
        BorderPane.setMargin((Node)topLabel, (Insets)new Insets(6.0));
        rootPane.setTop((Node)topLabel);
        GridPane centerPane = new GridPane();
        BorderPane.setMargin((Node)centerPane, (Insets)new Insets(4.0, 12.0, 4.0, 12.0));
        Label mdpsLabel = new Label("\u5165\u529b\u539f\u7a3f\u30bf\u30a4\u30d7\u3000\u89e3\u50cf\u5ea6(DPI)");
        GridPane.setMargin((Node)mdpsLabel, (Insets)new Insets(12.0, 6.0, 12.0, 6.0));
        centerPane.add((Node)mdpsLabel, 0, 0);
        this.cmbPaperType = new ComboBox();
        ObservableList pjtypes = this.cmbPaperType.getItems();
        File[] fileArray = this.inputFileConfigs;
        int n = this.inputFileConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            name = f.getName();
            int p = ((String)name).lastIndexOf(46);
            name = ((String)name).substring(0, p);
            pjtypes.add(name);
            ++n2;
        }
        this.cmbPaperType.setValue((Object)((String)pjtypes.get(0)));
        this.cmbPaperType.setMaxWidth(Double.MAX_VALUE);
        centerPane.add(this.cmbPaperType, 1, 0);
        this.cmbDpi = new ComboBox();
        ObservableList dpis = this.cmbDpi.getItems();
        name = this.DPI_TYPES;
        int n3 = this.DPI_TYPES.length;
        n = 0;
        while (n < n3) {
            Object dpi = name[n];
            dpis.add((Object)Integer.toString((int)dpi));
            ++n;
        }
        this.cmbDpi.setValue((Object)((String)dpis.get(2)));
        this.cmbDpi.setMaxWidth(Double.MAX_VALUE);
        centerPane.add(this.cmbDpi, 2, 0);
        Label imgsLabel = new Label("\u5165\u529b\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u30c7\u30a3\u30ec\u30af\u30c8\u30ea");
        GridPane.setMargin((Node)imgsLabel, (Insets)new Insets(12.0, 6.0, 12.0, 6.0));
        centerPane.add((Node)imgsLabel, 0, 1);
        this.inputField = new TextField();
        this.inputField.setText(this.inputDirName);
        centerPane.add((Node)this.inputField, 1, 1);
        Button imgsButton = new Button("...");
        imgsButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MDPSMain.this.clickImgsDir();
            }
        });
        centerPane.add((Node)imgsButton, 2, 1);
        Label outputLabel = new Label("\u51fa\u529b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea");
        GridPane.setMargin((Node)outputLabel, (Insets)new Insets(12.0, 6.0, 12.0, 6.0));
        centerPane.add((Node)outputLabel, 0, 2);
        this.outputField = new TextField();
        this.outputField.setText(this.outputDirName);
        centerPane.add((Node)this.outputField, 1, 2);
        Button outputButton = new Button("...");
        outputButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MDPSMain.this.clickOutputDir();
            }
        });
        centerPane.add((Node)outputButton, 2, 2);
        Label menLabel = new Label("\u9762\u4ed8\u3051\u30bf\u30a4\u30d7");
        GridPane.setMargin((Node)menLabel, (Insets)new Insets(12.0, 6.0, 12.0, 6.0));
        centerPane.add((Node)menLabel, 0, 3);
        this.cmbPosition = new ComboBox();
        ObservableList mentypes = this.cmbPosition.getItems();
        List<String> typelist = PageAlignFactory.getNameList();
        for (String type : typelist) {
            mentypes.add((Object)type);
        }
        typelist.clear();
        typelist = null;
        this.cmbPosition.setValue((Object)PageAlignFactory.getDefaultName());
        this.cmbPosition.setMaxWidth(Double.MAX_VALUE);
        centerPane.add(this.cmbPosition, 1, 3);
        Label outtypeLabel = new Label("\u51fa\u529b\u753b\u50cf\u30b5\u30a4\u30ba\u3000\u767d\u7e01(mm)");
        GridPane.setMargin((Node)outtypeLabel, (Insets)new Insets(12.0, 6.0, 12.0, 6.0));
        centerPane.add((Node)outtypeLabel, 0, 4);
        this.cmbOutSize = new ComboBox();
        ObservableList outtypes = this.cmbOutSize.getItems();
        File[] fileArray2 = this.outputFileConfigs;
        int n4 = this.outputFileConfigs.length;
        int n5 = 0;
        while (n5 < n4) {
            File f = fileArray2[n5];
            String name2 = f.getName();
            int p = name2.lastIndexOf(46);
            name2 = name2.substring(0, p);
            outtypes.add((Object)name2);
            ++n5;
        }
        String name3 = this.outputFileConfigs[0].getName();
        int p = name3.lastIndexOf(46);
        name3 = name3.substring(0, p);
        this.cmbOutSize.setValue((Object)name3);
        this.cmbOutSize.setMaxWidth(Double.MAX_VALUE);
        centerPane.add(this.cmbOutSize, 1, 4);
        this.borderField = new TextField();
        this.borderField.setMaxWidth(50.0);
        this.borderField.setAlignment(Pos.BOTTOM_CENTER);
        this.borderField.setText("0");
        centerPane.add((Node)this.borderField, 2, 4);
        Label typeLabel = new Label("\u51fa\u529b\u753b\u50cf\u5f62\u5f0f");
        GridPane.setMargin((Node)typeLabel, (Insets)new Insets(12.0, 6.0, 12.0, 6.0));
        centerPane.add((Node)typeLabel, 0, 5);
        this.cmbOutFormat = new ComboBox();
        ObservableList imgtypes = this.cmbOutFormat.getItems();
        typelist = ExtCmdFactory.getNameList();
        for (String type : typelist) {
            imgtypes.add((Object)type);
        }
        typelist.clear();
        typelist = null;
        this.cmbOutFormat.setValue((Object)ExtCmdFactory.getDefaultName());
        this.cmbOutFormat.setMaxWidth(Double.MAX_VALUE);
        centerPane.add(this.cmbOutFormat, 1, 5);
        this.execButton = new Button("\u5b9f\u884c");
        GridPane.setMargin((Node)this.execButton, (Insets)new Insets(12.0, 0.0, 12.0, 0.0));
        this.execButton.setMaxWidth(Double.MAX_VALUE);
        this.execButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MDPSMain.this.execPJ();
            }
        });
        centerPane.add((Node)this.execButton, 1, 6);
        rootPane.setCenter((Node)centerPane);
        this.statusBar = new Text();
        this.statusBar.setText("\u505c\u6b62\u4e2d");
        this.statusBar.setTextAlignment(TextAlignment.CENTER);
        this.progressBar = new ProgressBar();
        this.progressBar.setMaxWidth(Double.MAX_VALUE);
        this.progressBar.setMaxHeight(Double.MAX_VALUE);
        BorderPane.setMargin((Node)this.progressBar, (Insets)new Insets(6.0));
        VBox vstatus = ((VBoxBuilder)VBoxBuilder.create().spacing(10.0).children(new Node[]{this.progressBar, this.statusBar})).build();
        rootPane.setBottom((Node)vstatus);
        rootStage.setScene(new Scene((Parent)rootPane, 480.0, 360.0));
        rootStage.show();
    }

    private void clickImgsDir() {
        String str;
        File inif = null;
        String initDirName = this.inputField.getText();
        if (initDirName != null && initDirName.length() > 0) {
            inif = new File(initDirName).getParentFile();
        }
        if ((str = this.chooseDir("\u753b\u50cf\u306e\u3042\u308b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u6307\u5b9a", inif)) != null) {
            this.inputField.setText(str);
            this.inputDirName = str;
        }
    }

    private void clickOutputDir() {
        String str;
        File inif = null;
        String initDirName = this.outputField.getText();
        if (initDirName != null && initDirName.length() > 0) {
            inif = new File(initDirName).getParentFile();
        }
        if ((str = this.chooseDir("\u51fa\u529b\u5148\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u6307\u5b9a", inif)) != null) {
            this.outputField.setText(str);
            this.outputDirName = str;
        }
    }

    private String chooseDir(String str, File startDir) {
        String ret = null;
        DirectoryChooser dc = new DirectoryChooser();
        if (str == null) {
            str = "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u6307\u5b9a";
        }
        dc.setTitle(str);
        if (startDir == null) {
            startDir = new File(System.getProperty("user.home"));
        }
        dc.setInitialDirectory(startDir);
        File f = dc.showDialog((Window)this.rootStage);
        if (f != null) {
            try {
                ret = f.getCanonicalPath();
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u53d6\u5f97\u5931\u6557 " + e.getMessage(), e);
                ret = null;
            }
        }
        return ret;
    }

    private void loadPreferences() {
        Preferences prefs = Preferences.userRoot().node("nekora/MDPSprocess");
        this.inputDirName = prefs.get("inputDirName", null);
        this.outputDirName = prefs.get("outputDirName", null);
    }

    private void savePreferences() {
        try {
            Preferences prefs = Preferences.userRoot().node("nekora/MDPSprocess");
            this.inputDirName = this.inputField.getText();
            this.outputDirName = this.outputField.getText();
            prefs.put("inputDirName", this.inputDirName);
            prefs.put("outputDirName", this.outputDirName);
        }
        catch (Exception e) {
            this.logger.warning(e.getLocalizedMessage());
        }
    }

    private double mm_to_pixel(double n, int dpi) {
        return n * 0.03937 * (double)dpi;
    }

    private void execPJ() {
        Point[] points;
        InputPaper ip;
        if (this.executing_flg) {
            Toolkit.getDefaultToolkit().beep();
            String msg = "\u65e2\u306b\u5b9f\u884c\u4e2d\u3067\u3059\u3002";
            this.logger.warning(msg);
            MessageBox.show((Window)this.rootStage, (String)msg, (String)"\u8b66\u544a", (int)0x2000000);
            return;
        }
        if (this.outputDirName == null || this.outputDirName.length() <= 0) {
            Toolkit.getDefaultToolkit().beep();
            String msg = "\u51fa\u529b\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044";
            this.logger.warning(msg);
            MessageBox.show((Window)this.rootStage, (String)msg, (String)"\u8b66\u544a", (int)0x2000000);
            return;
        }
        if (this.inputDirName == null || this.inputDirName.length() <= 0) {
            Toolkit.getDefaultToolkit().beep();
            String msg = "\u5165\u529b\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044";
            this.logger.warning(msg);
            MessageBox.show((Window)this.rootStage, (String)msg, (String)"\u8b66\u544a", (int)0x2000000);
            return;
        }
        String t = (String)this.cmbDpi.getValue();
        int dpi = Integer.parseInt(t);
        t = this.borderField.getText();
        int borderPixel = t != null && t.length() > 0 ? (int)this.mm_to_pixel(Double.parseDouble(t), dpi) : 0;
        this.logger.info("DPI=" + dpi + " \u7e01\uff1d" + borderPixel);
        t = (String)this.cmbPaperType.getValue();
        this.curConfFile = new File("./confinputfile" + File.separator + t + ".xml");
        try {
            this.logger.info(String.valueOf(t) + " / " + this.curConfFile.getCanonicalPath());
            ip = new InputPaper(this.curConfFile, dpi, this.logger);
        }
        catch (Exception e1) {
            Toolkit.getDefaultToolkit().beep();
            String msg = "\u539f\u7a3f\u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f\u5931\u6557 \u30d5\u30a1\u30a4\u30eb\uff1d" + this.curConfFile + " \u30a8\u30e9\u30fc\uff1d" + e1.getLocalizedMessage();
            this.logger.warning(msg);
            e1.printStackTrace();
            MessageBox.show((Window)this.rootStage, (String)msg, (String)"\u30a8\u30e9\u30fc", (int)0x1000000);
            return;
        }
        String outsize = (String)this.cmbOutSize.getValue();
        this.curConfFile = new File("./confoutputfile" + File.separator + outsize + ".xml");
        try {
            this.logger.info(String.valueOf(outsize) + " / " + this.curConfFile.getCanonicalPath());
            points = this.readOutputConfig(this.curConfFile, dpi);
            this.logger.info("Put\u4f4d\u7f6e\u3000L=" + points[0] + " R=" + points[1] + " \u5168\u4f53\u306e\u5927\u304d\u3055\uff1d" + points[2]);
        }
        catch (IOException | JDOMException e1) {
            Toolkit.getDefaultToolkit().beep();
            String msg = "\u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f\u5931\u6557 \u30d5\u30a1\u30a4\u30eb\uff1d" + this.curConfFile + " \u30a8\u30e9\u30fc\uff1d" + e1.getLocalizedMessage();
            this.logger.warning(msg);
            e1.printStackTrace();
            MessageBox.show((Window)this.rootStage, (String)msg, (String)"\u30a8\u30e9\u30fc", (int)0x1000000);
            return;
        }
        Point baseSize = points[2];
        File[] infiles = new File(this.inputDirName).listFiles();
        ArrayList<File> flist = new ArrayList<File>();
        File[] fileArray = infiles;
        int n = infiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            try {
                if (f.isDirectory() || f.isHidden()) {
                    this.logger.info("\u539f\u7a3f\u30d5\u30a1\u30a4\u30eb\u3067\u306f\u306a\u3044(\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u307e\u305f\u306f\u96a0\u3057\u30d5\u30a1\u30a4\u30eb)\uff1a" + f.getCanonicalPath());
                } else {
                    String str = f.getName();
                    if (str.indexOf(".") <= 0) {
                        this.logger.info("\u539f\u7a3f\u30d5\u30a1\u30a4\u30eb\u3067\u306f\u306a\u3044(\u5148\u982d\u304c\u30c9\u30c3\u30c8)\uff1a" + f.getCanonicalPath());
                    } else {
                        this.logger.info("\u539f\u7a3f\u30d5\u30a1\u30a4\u30eb\uff1d" + f.getCanonicalPath());
                        flist.add(f);
                    }
                }
            }
            catch (IOException e) {
                Toolkit.getDefaultToolkit().beep();
                String msg = "\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f\u5931\u6557 \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff1d" + this.inputDirName + " \u30d5\u30a1\u30a4\u30eb\uff1d" + f.getName() + " \u30a8\u30e9\u30fc\uff1d" + e.getLocalizedMessage();
                this.logger.warning(msg);
                e.printStackTrace();
                MessageBox.show((Window)this.rootStage, (String)msg, (String)"\u30a8\u30e9\u30fc", (int)0x1000000);
                return;
            }
            ++n2;
        }
        int pages = flist.size();
        String aligntype = (String)this.cmbPosition.getValue();
        this.logger.info("\u30da\u30fc\u30b8\u6570\uff1d" + pages + " \u9762\u4ed8\u3051\u30bf\u30a4\u30d7\uff1d" + aligntype + " \u7d19\u306e\u7a2e\u985e\uff1d" + outsize);
        PageAlign pa = PageAlignFactory.createPageAlign(flist, aligntype, this.logger);
        t = (String)this.cmbOutFormat.getValue();
        ExtCmd cmd = ExtCmdFactory.createExtCmd(t);
        if (cmd == null) {
            Toolkit.getDefaultToolkit().beep();
            String msg = "\u51fa\u529b\u753b\u50cf\u5f62\u5f0f\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044";
            this.logger.warning(msg);
            MessageBox.show((Window)this.rootStage, (String)msg, (String)"\u8b66\u544a", (int)0x2000000);
            return;
        }
        final ExecutorService exec = Executors.newSingleThreadExecutor();
        MDPSTask task = new MDPSTask(pa, this.outputDirName, ip, baseSize, dpi, borderPixel, outsize, cmd, this.logger);
        this.progressBar.progressProperty().unbind();
        this.progressBar.progressProperty().bind((ObservableValue)task.progressProperty());
        this.statusBar.textProperty().bind((ObservableValue)task.messageProperty());
        task.addEventHandler(WorkerStateEvent.WORKER_STATE_SUCCEEDED, (EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                exec.shutdown();
                MDPSMain.this.execButton.setDisable(false);
                MDPSMain.this.executing_flg = false;
                Toolkit.getDefaultToolkit().beep();
            }
        });
        this.executing_flg = true;
        this.execButton.setDisable(true);
        exec.submit((Runnable)((Object)task));
    }

    private Point[] readOutputConfig(File f, int dpi) throws JDOMException, IOException {
        Point[] ret = new Point[3];
        Document doc = new SAXBuilder().build(f);
        Element root = doc.getRootElement();
        double x = Double.parseDouble(root.getAttributeValue("width"));
        double y = Double.parseDouble(root.getAttributeValue("height"));
        int ix = (int)(x * (double)dpi);
        int iy = (int)(y * (double)dpi);
        ret[2] = new Point(ix, iy);
        Element cropElement = root.getChild("crop");
        y = Double.parseDouble(cropElement.getAttributeValue("y"));
        iy = (int)(y * (double)dpi);
        x = Double.parseDouble(cropElement.getAttributeValue("lx"));
        ix = (int)(x * (double)dpi);
        ret[0] = new Point(ix, iy);
        x = Double.parseDouble(cropElement.getAttributeValue("rx"));
        ix = (int)(x * (double)dpi);
        ret[1] = new Point(ix, iy);
        return ret;
    }
}

