/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.readers;

import com.anotherbigidea.flash.interfaces.SWFFileSignature;
import com.anotherbigidea.flash.interfaces.SWFTags;
import com.anotherbigidea.flash.structs.Rect;
import com.anotherbigidea.flash.writers.SWFWriter;
import com.anotherbigidea.io.InStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SWFReader {
    protected SWFTags mConsumer;
    protected InStream mIn;
    protected InputStream mInputstream;
    protected boolean mCompressed;
    protected String mFilename;

    public SWFReader(SWFTags consumer, String filename) throws IOException {
        this(consumer, new FileInputStream(filename));
        this.mFilename = filename;
    }

    public SWFReader(SWFTags consumer, InputStream inputstream) {
        this.mConsumer = consumer;
        this.mInputstream = inputstream;
        this.mIn = new InStream(inputstream);
    }

    public SWFReader(SWFTags consumer, InStream instream) {
        this.mConsumer = consumer;
        this.mIn = instream;
    }

    public void readFile() throws IOException {
        this.readHeader();
        this.readTags();
        if (this.mFilename != null) {
            this.mInputstream.close();
        }
    }

    public void readTags() throws IOException {
        while (this.readOneTag() != 0) {
        }
    }

    public int readOneTag() throws IOException {
        boolean longTag;
        int header = this.mIn.readUI16();
        int type = header >> 6;
        int length = header & 0x3F;
        boolean bl = longTag = length == 63;
        if (longTag) {
            length = (int)this.mIn.readUI32();
        }
        byte[] contents = this.mIn.read(length);
        this.mConsumer.tag(type, longTag, contents);
        return type;
    }

    public void readSignature() throws IOException {
        int[] sig = new int[]{this.mIn.readUI8(), this.mIn.readUI8(), this.mIn.readUI8()};
        if (sig[0] != 70 && sig[0] != 67 || sig[1] != 87 || sig[2] != 83) {
            throw new IOException("Invalid SWF File Signature");
        }
        boolean bl = this.mCompressed = sig[0] == 67;
        if (this.mConsumer instanceof SWFFileSignature) {
            ((SWFFileSignature)((Object)this.mConsumer)).signature(this.mCompressed ? "CWS" : "FWS");
        }
    }

    public void readHeader() throws IOException {
        this.readSignature();
        this.readRemainderOfHeader();
    }

    public void readRemainderOfHeader() throws IOException {
        int version = this.mIn.readUI8();
        long length = this.mIn.readUI32();
        if (this.mCompressed) {
            this.mIn.readCompressed();
        }
        Rect frameSize = new Rect(this.mIn);
        int frameRate = this.mIn.readUI16() >> 8;
        int frameCount = this.mIn.readUI16();
        this.mConsumer.header(version, length, frameSize.getMaxX(), frameSize.getMaxY(), frameRate, frameCount);
    }

    public static void main(String[] args) throws IOException {
        SWFWriter writer = new SWFWriter(args[1]);
        if (args.length > 2) {
            if (args[2].equals("+")) {
                writer.setCompression(true);
            } else if (args[2].equals("-")) {
                writer.setCompression(false);
            }
        }
        SWFReader reader = new SWFReader((SWFTags)writer, args[0]);
        reader.readFile();
    }
}

