/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.table.DefaultTableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SBDTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    static final int CUT = 0;
    static final int IMG = 1;
    static final int DESC = 2;
    static final int WORDS = 3;
    static final int SEC = 4;
    static final int TOTAL = 5;
    static final int KEY = 6;
    static final int COLMNNUMBERS = 7;
    static final int ROWINITNUMBERS = 100;
    static final String S_ROOT = "storyboard";
    static final String S_TITLE = "title";
    static final String S_DOCID = "docid";
    static final String S_AUTHOR = "author";
    static final String S_FRAMERATE = "framerate";
    static final String S_SIZE = "size";
    static final String S_WIDE = "wide";
    static final String S_TABLE = "table";
    static final String S_RECORD = "tr";
    static final String S_CUT = "cut";
    static final String S_IMG = "img";
    static final String S_DESC = "desc";
    static final String S_WORDS = "words";
    static final String S_SEC = "sec";
    static final String S_TOTAL = "total";
    static final String S_KEY = "key";
    static final String S_BOOKMARKS = "bookmarks";
    static final String S_MARK = "mark";
    static final String S_NAME = "name";
    static final String S_POINT = "point";
    static final String S_CURX = "cur_x";
    static final String S_CURY = "cur_y";
    static final String S_ICON_SMALL = "small";
    static final String S_ICON_MIDDLE = "middle";
    static final String S_ICON_LARGE = "large";
    static final String S_ICON_NOMAL = "nomal";
    static final String S_ICON_WIDE = "wide";
    static final String S_LINE_LOCK = "linelock";
    static final String S_LINESPARPAGE = "linesparpage";
    static final int ICON_SMALL = 0;
    static final int ICON_MIDDLE = 1;
    static final int ICON_LARGE = 2;
    static final int ICON_NOMAL = 0;
    static final int ICON_WIDE = 1;
    private Logger logger;
    private boolean editing = false;
    private Container sbcont;
    private boolean speed_flg = false;
    String docid;
    String title = null;
    String docFileName = null;
    File docFileDir = null;
    Hashtable<String, ImageIcon> icons;
    int iconsize = 0;
    int iconmode = 1;
    DefaultListModel bookmarks;
    CharacterTableModel charList = null;
    Integer cur_x;
    Integer cur_y;
    ImageIcon simg;
    int frameRate = 24;
    boolean line_lock;
    int linesparpage = 5;
    String author;
    String subtitle;
    String editor;
    String company;
    Locale lang;

    SBDTableModel(Object[][] rowData, Logger p_logger, Container p_cont, String[] columnNames) {
        super(rowData, columnNames);
        this.logger = p_logger;
        this.sbcont = p_cont;
        this.docid = sbedit.makeKeyUID();
        if (this.icons == null) {
            this.icons = new Hashtable(100);
        } else {
            this.icons.clear();
        }
        if (this.bookmarks != null) {
            this.bookmarks.clear();
        }
        this.cur_x = 1;
        this.cur_y = 0;
        this.simg = new ImageIcon();
        this.line_lock = false;
        this.author = null;
    }

    SBDTableModel(Logger p_logger, Container p_cont, String[] columnNames) {
        super(columnNames, 0);
        this.logger = p_logger;
        this.sbcont = p_cont;
        this.docid = sbedit.makeKeyUID();
        if (this.icons == null) {
            this.icons = new Hashtable(100);
        } else {
            this.icons.clear();
        }
        if (this.bookmarks != null) {
            this.bookmarks.clear();
        }
        this.cur_x = 1;
        this.cur_y = 0;
        this.simg = new ImageIcon();
        this.line_lock = false;
        this.author = null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column != 5 && column != 6;
    }

    public Class getColumnClass(int column) {
        if (column == 1) {
            return this.simg.getClass();
        }
        return super.getColumnClass(column);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        String imgfile;
        super.setValueAt(aValue, row, column);
        if (column == 1 && aValue != null && (imgfile = aValue.toString()) != null && imgfile.length() > 0) {
            ImageIcon icon;
            String key = (String)this.getValueAt(row, 6);
            if (this.icons.containsKey(key)) {
                this.icons.remove(key);
            }
            if ((icon = this.getIcon(imgfile)) != null) {
                this.icons.put(key, icon);
            }
        }
        this.setEditing();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 1) {
            String imgfile = (String)super.getValueAt(row, column);
            if (imgfile != null) {
                if (imgfile.length() > 0) {
                    String key = (String)this.getValueAt(row, 6);
                    ImageIcon icon = this.icons.get(key);
                    if (icon == null) {
                        icon = this.getIcon(imgfile);
                        if (icon != null) {
                            this.icons.put(key, icon);
                        } else {
                            String str = "";
                            this.setValueAt(str, row, column);
                            return str;
                        }
                    }
                    return icon;
                }
                return "";
            }
            return "";
        }
        return super.getValueAt(row, column);
    }

    public String getImgNameAt(int row) {
        return (String)super.getValueAt(row, 1);
    }

    public void removeRow(int row, String myfilename) {
        String imgstr;
        if (this.icons != null && row <= this.getRowCount() - 1) {
            String key = (String)this.getValueAt(row, 6);
            this.icons.remove(key);
        }
        if ((imgstr = this.getImgNameAt(row)) != null && imgstr.length() > 0) {
            File dstfile = new File(myfilename);
            String dst = String.valueOf(dstfile.getParent()) + File.separator + S_IMG + File.separator + this.getValueAt(row, 6) + ".png";
            try {
                dstfile = new File(dst);
                dstfile.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                dst = String.valueOf(dstfile.getParent()) + File.separator + S_IMG + File.separator + "S" + File.separator + this.getValueAt(row, 6) + ".png";
                dstfile = new File(dst);
                dstfile.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                dst = String.valueOf(dstfile.getParent()) + File.separator + S_IMG + File.separator + "M" + File.separator + this.getValueAt(row, 6) + ".png";
                dstfile = new File(dst);
                dstfile.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                dst = String.valueOf(dstfile.getParent()) + File.separator + S_IMG + File.separator + "L" + File.separator + this.getValueAt(row, 6) + ".png";
                dstfile = new File(dst);
                dstfile.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.removeRow(row);
    }

    @Override
    public void removeRow(int row) {
        super.removeRow(row);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ImageIcon getIcon(String filename) {
        ImageIcon reticon;
        block30: {
            this.logger.info("Called filename=" + filename);
            if (filename == null || filename.length() <= 0) {
                reticon = null;
            } else {
                File readImgFile = new File(filename);
                reticon = this.getIconFromCachFile(readImgFile);
                if (reticon == null) {
                    Image readImage = null;
                    Graphics gM = null;
                    Image sclimg = null;
                    try {
                        if (!readImgFile.getCanonicalFile().exists()) {
                            if (gM != null) {
                                gM.dispose();
                                gM = null;
                            }
                            if (readImage != null && readImage != sclimg) {
                                readImage.flush();
                                return null;
                            }
                            return null;
                        }
                    }
                    catch (Exception ex) {
                        StringBuilder msg = new StringBuilder("\u30a4\u30e1\u30fc\u30b8\u53d6\u5f97\u5931\u6557\u3000\u30d5\u30a1\u30a4\u30eb\u540d\uff1d");
                        msg.append(filename).append(" \u7d76\u5bfe\u30d1\u30b9\uff1d").append(readImgFile.getAbsolutePath()).append("\u3000\u539f\u56e0\uff1d").append(ex.toString()).append(" \u30b9\u30ec\u30c3\u30c9\u540d\uff1d").append(Thread.currentThread().getName());
                        this.logger.warning(msg.toString());
                        reticon = null;
                        if (gM != null) {
                            gM.dispose();
                            gM = null;
                        }
                        if (readImage != null && readImage != sclimg) {
                            readImage.flush();
                            readImage = null;
                        }
                        break block30;
                    }
                    catch (Throwable throwable) {
                        if (gM != null) {
                            gM.dispose();
                            gM = null;
                        }
                        if (readImage != null && readImage != sclimg) {
                            readImage.flush();
                            readImage = null;
                        }
                        throw throwable;
                    }
                    {
                        String ext = filename.substring(filename.lastIndexOf(46) + 1);
                        readImage = ext.equalsIgnoreCase("png") || ext.equalsIgnoreCase("gif") || ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("jpeg") ? Toolkit.getDefaultToolkit().getImage(readImgFile.getCanonicalPath()) : ImageIO.read(readImgFile.getCanonicalFile());
                        switch (this.iconsize) {
                            case 2: {
                                int x = 640;
                                int y = this.iconmode == 1 ? 360 : 480;
                                MediaTracker tracker = new MediaTracker(this.sbcont);
                                tracker.addImage(readImage, 0);
                                try {
                                    tracker.waitForID(0);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                int w = readImage.getWidth(null);
                                int h = readImage.getHeight(null);
                                if (x == w && y == h) {
                                    this.logger.info("\u5927\u304d\u3055\u4e00\u81f4");
                                    sclimg = readImage;
                                    break;
                                }
                                this.logger.info("\u5927\u304d\u3055\u4e0d\u4e00\u81f4 w=" + w + " ,h=" + h);
                                sclimg = new BufferedImage(x, y, 5);
                                if (this.speed_flg) {
                                    gM = ((BufferedImage)sclimg).createGraphics();
                                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
                                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                                    gM.drawImage(readImage, 0, 0, x, y, null);
                                    break;
                                }
                                sclimg = readImage.getScaledInstance(x, y, 4);
                                break;
                            }
                            case 1: {
                                int x = 320;
                                int y = this.iconmode == 1 ? 180 : 240;
                                sclimg = new BufferedImage(x, y, 5);
                                if (this.speed_flg) {
                                    gM = ((BufferedImage)sclimg).createGraphics();
                                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
                                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                                    ((Graphics2D)gM).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                                    MediaTracker tracker = new MediaTracker(this.sbcont);
                                    tracker.addImage(readImage, 0);
                                    try {
                                        tracker.waitForID(0);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    gM.drawImage(readImage, 0, 0, x, y, null);
                                    break;
                                }
                                sclimg = readImage.getScaledInstance(x, y, 4);
                                break;
                            }
                            default: {
                                int x = 160;
                                int y = this.iconmode == 1 ? 90 : 120;
                                sclimg = readImage.getScaledInstance(x, y, 4);
                            }
                        }
                        MediaTracker tracker2 = new MediaTracker(this.sbcont);
                        tracker2.addImage(sclimg, 0);
                        try {
                            tracker2.waitForID(0);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        reticon = new ImageIcon(sclimg, readImgFile.getCanonicalPath());
                    }
                    if (gM != null) {
                        gM.dispose();
                        gM = null;
                    }
                    if (readImage != null && readImage != sclimg) {
                        readImage.flush();
                        readImage = null;
                    }
                }
            }
        }
        this.logger.info("return value=" + reticon);
        return reticon;
    }

    private ImageIcon getIconFromCachFile(File readImgFile) {
        File cashFile;
        ImageIcon reticon;
        block14: {
            block13: {
                block12: {
                    block11: {
                        reticon = null;
                        if (this.docFileDir == null || readImgFile == null) {
                            return null;
                        }
                        if (readImgFile.getCanonicalFile().exists()) break block11;
                        return null;
                    }
                    String cdirname = "S";
                    switch (this.iconsize) {
                        case 2: {
                            cdirname = "L";
                            break;
                        }
                        case 1: {
                            cdirname = "M";
                        }
                    }
                    String tmpname = readImgFile.getName();
                    StringBuilder readImgFileName = new StringBuilder(tmpname.substring(0, tmpname.lastIndexOf(46) + 1)).append("png");
                    StringBuilder cashFileName = new StringBuilder(this.docFileDir.getCanonicalPath()).append(File.separator).append(S_IMG).append(File.separator).append(cdirname).append(File.separator).append((CharSequence)readImgFileName);
                    cashFile = new File(cashFileName.toString());
                    if (cashFile.getCanonicalFile().exists()) break block12;
                    this.logger.info("Image Cache file not exist");
                    return null;
                }
                if (cashFile.getCanonicalFile().length() > 0L) break block13;
                this.logger.info("Image Cache file size 0");
                return null;
            }
            if (readImgFile.getCanonicalFile().lastModified() < cashFile.getCanonicalFile().lastModified()) break block14;
            this.logger.info("Image Cache file old cash");
            return null;
        }
        try {
            Image image = Toolkit.getDefaultToolkit().getImage(cashFile.getCanonicalPath());
            reticon = new ImageIcon(image, readImgFile.getCanonicalPath());
            this.logger.info("retIcon=" + reticon.toString() + " readImgFile=" + readImgFile.getCanonicalPath());
        }
        catch (IOException ioe) {
            reticon = null;
        }
        return reticon;
    }

    void renumTotalTime() {
        int max = this.getRowCount();
        double totalsec = 0.0;
        int totalkoma = 0;
        int i = 0;
        while (i < max) {
            double cursec = this.getSecond(i, 4);
            int curkoma = this.getKoma(i, 4);
            if (curkoma > 0) {
                totalkoma += curkoma;
            }
            if (cursec >= 0.0) {
                totalsec += cursec;
            }
            if (curkoma > 0 || cursec >= 0.0) {
                if (totalkoma >= this.frameRate) {
                    int tkoma2 = totalkoma / this.frameRate;
                    totalsec += (double)tkoma2;
                    totalkoma -= tkoma2 * this.frameRate;
                }
                StringBuilder strb = new StringBuilder().append(totalsec).append("+").append(totalkoma);
                this.setValueAt(strb.toString(), i, 5);
            } else {
                this.setValueAt("", i, 4);
                this.setValueAt("", i, 5);
            }
            ++i;
        }
    }

    double getSecond(int row, int col) {
        double ret;
        try {
            String str = super.getValueAt(row, col).toString();
            int index = str.indexOf(43);
            ret = index < 0 ? Double.parseDouble(str) : Double.parseDouble(str.substring(0, index));
        }
        catch (Exception ex) {
            ret = -1.0;
        }
        return ret;
    }

    int getKoma(int row, int col) {
        int ret;
        try {
            String str = super.getValueAt(row, col).toString();
            int index = str.indexOf(43);
            ret = index < 0 ? 0 : Integer.parseInt(str.substring(index + 1));
        }
        catch (Exception ex) {
            ret = 0;
        }
        return ret;
    }

    public void renumCutNumber(int row) {
        if (this.line_lock) {
            return;
        }
        int max = this.getRowCount();
        int last = 0;
        int i = 0;
        while (i < max) {
            Object ob = this.getValueAt(i, 0);
            CutNumType.Type t = CutNumType.check(ob.toString());
            switch (t) {
                case INT: {
                    this.setValueAt(++last, i, 0);
                    break;
                }
                case FLOAT: {
                    Float Fr = new Float(ob.toString());
                    float f2 = Fr.floatValue() - (float)Fr.intValue();
                    this.setValueAt(new Float(f2 += (float)last), i, 0);
                }
            }
            ++i;
        }
    }

    public void changeIconSize(int psize) {
        if (psize != this.iconsize && (psize == 0 || psize == 1 || psize == 2)) {
            this.clearIcons();
            this.iconsize = psize;
        }
    }

    public int getIconSize() {
        return this.iconsize;
    }

    public void setIconMode(int pmode) {
        if (pmode != this.iconmode) {
            if (pmode == 1 || pmode == 0) {
                this.clearIcons();
                this.iconmode = pmode;
            } else {
                this.logger.info("changeIconMode:\u4e0d\u6b63\u30a2\u30a4\u30b3\u30f3\u30e2\u30fc\u30c9\u6307\u5b9a" + pmode);
            }
        }
    }

    public int getIconMode() {
        return this.iconmode;
    }

    void setIconSize(int i) {
        switch (i) {
            case 1: 
            case 2: {
                this.iconsize = i;
                break;
            }
            default: {
                this.iconsize = 0;
            }
        }
    }

    public void clearIcons() {
        if (this.icons == null) {
            this.icons = new Hashtable(100);
        } else {
            this.icons.clear();
        }
    }

    public int getFindRow(int start, String keyword) {
        int row = -1;
        if (keyword != null) {
            int max = this.getRowCount();
            if (start < 0 || start >= max) {
                start = 0;
            }
            int i = ++start;
            while (i < max) {
                String desc = (String)this.getValueAt(i, 2);
                String words = (String)this.getValueAt(i, 3);
                if (desc.indexOf(keyword) >= 0 || words.indexOf(keyword) >= 0) {
                    row = i;
                    break;
                }
                ++i;
            }
        }
        return row;
    }

    public int getFindRowCutNo(String keyword) {
        int row = -1;
        if (keyword != null) {
            int max = this.getRowCount();
            int i = 0;
            while (i < max) {
                String cut = this.getValueAt(i, 0).toString();
                this.logger.info("cut=" + cut + " keyword=" + keyword);
                if (cut.equalsIgnoreCase(keyword)) {
                    row = i;
                    this.logger.info("getFindRowCutNo:HIT KEY=" + keyword + " ROW=" + i);
                    break;
                }
                ++i;
            }
        }
        return row;
    }

    public int getFindRowTotal(double keytime) {
        int row = -1;
        double total = 0.0;
        int max = this.getRowCount();
        int i = 0;
        while (i < max) {
            double d = this.getSecond(i, 4);
            if (d > 0.0 && (total += d) >= keytime) {
                row = i;
                this.logger.info("getFindRowTotal:HIT KEY=" + keytime + " ROW=" + i);
                break;
            }
            ++i;
        }
        return row;
    }

    public Document getDocument() throws Exception {
        String s;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document retdoc = builder.newDocument();
        Element root = retdoc.createElement(S_ROOT);
        root.setAttribute("xmlns", "http://www.mapletown.net/~nekora/sbedit");
        retdoc.appendChild(root);
        Element e = retdoc.createElement(S_TITLE);
        if (this.title == null) {
            this.title = "\u7121\u984c";
        }
        e.appendChild(retdoc.createTextNode(this.title));
        root.appendChild(e);
        e = retdoc.createElement(S_DOCID);
        e.appendChild(retdoc.createTextNode(this.docid));
        root.appendChild(e);
        e = retdoc.createElement(S_AUTHOR);
        e.appendChild(retdoc.createTextNode(this.getAuthor()));
        root.appendChild(e);
        e = retdoc.createElement(S_FRAMERATE);
        Integer If = this.frameRate;
        e.appendChild(retdoc.createTextNode(If.toString()));
        root.appendChild(e);
        e = retdoc.createElement(S_SIZE);
        switch (this.iconsize) {
            case 2: {
                s = S_ICON_LARGE;
                break;
            }
            case 1: {
                s = S_ICON_MIDDLE;
                break;
            }
            default: {
                s = S_ICON_SMALL;
            }
        }
        e.appendChild(retdoc.createTextNode(s));
        root.appendChild(e);
        e = retdoc.createElement("wide");
        switch (this.iconmode) {
            case 1: {
                s = "wide";
                break;
            }
            default: {
                s = S_ICON_NOMAL;
            }
        }
        e.appendChild(retdoc.createTextNode(s));
        root.appendChild(e);
        e = retdoc.createElement(S_CURX);
        e.appendChild(retdoc.createTextNode(this.cur_x.toString()));
        root.appendChild(e);
        e = retdoc.createElement(S_CURY);
        e.appendChild(retdoc.createTextNode(this.cur_y.toString()));
        root.appendChild(e);
        e = retdoc.createElement(S_LINE_LOCK);
        s = this.line_lock ? "true" : "false";
        e.appendChild(retdoc.createTextNode(s));
        root.appendChild(e);
        e = retdoc.createElement(S_LINESPARPAGE);
        If = this.linesparpage;
        e.appendChild(retdoc.createTextNode(If.toString()));
        root.appendChild(e);
        Element tbltag = retdoc.createElement(S_TABLE);
        root.appendChild(tbltag);
        int i = 0;
        while (i < this.getRowCount()) {
            Element li = retdoc.createElement(S_RECORD);
            e = retdoc.createElement(S_CUT);
            e.appendChild(retdoc.createTextNode(this.getValueAt(i, 0).toString()));
            this.logger.info("CUT=" + this.getValueAt(i, 0).toString());
            li.appendChild(e);
            e = retdoc.createElement(S_IMG);
            e.appendChild(retdoc.createTextNode(this.getImgNameAt(i)));
            li.appendChild(e);
            e = retdoc.createElement(S_DESC);
            e.appendChild(retdoc.createTextNode(this.getValueAt(i, 2).toString()));
            li.appendChild(e);
            e = retdoc.createElement(S_WORDS);
            e.appendChild(retdoc.createTextNode(this.getValueAt(i, 3).toString()));
            li.appendChild(e);
            e = retdoc.createElement(S_SEC);
            e.appendChild(retdoc.createTextNode(this.getValueAt(i, 4).toString()));
            li.appendChild(e);
            e = retdoc.createElement(S_TOTAL);
            e.appendChild(retdoc.createTextNode(this.getValueAt(i, 5).toString()));
            li.appendChild(e);
            e = retdoc.createElement(S_KEY);
            e.appendChild(retdoc.createTextNode(this.getValueAt(i, 6).toString()));
            li.appendChild(e);
            tbltag.appendChild(li);
            ++i;
        }
        Element booktag = retdoc.createElement(S_BOOKMARKS);
        root.appendChild(booktag);
        if (this.bookmarks != null) {
            int i2 = 0;
            while (i2 < this.bookmarks.getSize()) {
                BookmarkItem item = (BookmarkItem)this.bookmarks.getElementAt(i2);
                String key = item.key;
                Element li = retdoc.createElement(S_MARK);
                e = retdoc.createElement(S_NAME);
                e.appendChild(retdoc.createTextNode(key));
                li.appendChild(e);
                String point = item.point;
                e = retdoc.createElement(S_POINT);
                e.appendChild(retdoc.createTextNode(point));
                li.appendChild(e);
                booktag.appendChild(li);
                ++i2;
            }
        }
        retdoc.getDocumentElement().normalize();
        this.resetEditing();
        return retdoc;
    }

    public void setDocument(Document pdoc) throws Exception {
        Integer If;
        Element booktag;
        Element fileElement;
        Element tbltag;
        NodeList list;
        if (pdoc == null) {
            return;
        }
        String value = "";
        Element root = pdoc.getDocumentElement();
        try {
            list = root.getElementsByTagName(S_TABLE);
            tbltag = (Element)list.item(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        list = tbltag.getElementsByTagName(S_RECORD);
        int lis = list.getLength();
        int i = 0;
        while (i < lis) {
            NodeList itemList;
            Object[] rec = new Object[7];
            Element element = (Element)list.item(i);
            try {
                itemList = element.getElementsByTagName(S_CUT);
                fileElement = (Element)itemList.item(0);
                Node fchild = fileElement.getFirstChild();
                if (fchild != null) {
                    value = fchild.getNodeValue();
                    CutNumType.Type t = CutNumType.check(value);
                    switch (t) {
                        case INT: {
                            rec[0] = new Integer(value);
                            this.logger.info("\u30ab\u30c3\u30c8\u756a\u53f7\u304c\u6574\u6570\uff1d" + rec[0]);
                            break;
                        }
                        case FLOAT: {
                            rec[0] = new Float(value);
                            this.logger.info("\u30ab\u30c3\u30c8\u756a\u53f7\u304c\u5c0f\u6570\uff1d" + rec[0]);
                            break;
                        }
                        default: {
                            rec[0] = value;
                            this.logger.info("\u30ab\u30c3\u30c8\u756a\u53f7\u304c\u6587\u5b57\u5217\uff1d" + rec[0]);
                            break;
                        }
                    }
                } else {
                    rec[0] = "";
                    this.logger.info("\u30ab\u30c3\u30c8\u756a\u53f7\u304c\u7a7a\u3063\u307d\uff1d" + rec[0]);
                }
            }
            catch (Exception ex) {
                this.logger.warning("Invalid CUT NO=" + value);
                rec[0] = "";
                this.logger.info("\u30ab\u30c3\u30c8\u756a\u53f7\u304c\u6587\u5b57\u5217(invalid\uff12)\uff1d" + rec[0]);
                ex.printStackTrace();
            }
            try {
                itemList = element.getElementsByTagName(S_IMG);
                fileElement = (Element)itemList.item(0);
                String imgfilename = value = fileElement.getFirstChild().getNodeValue();
                File imgfile = new File(imgfilename);
                if (!imgfile.getCanonicalFile().exists()) {
                    this.logger.info("\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u306a\u3044\uff1d" + imgfilename + " docFileDir=" + this.docFileDir);
                    imgfilename = "./img/" + imgfile.getName();
                }
                rec[1] = imgfilename;
            }
            catch (Exception ex) {
                rec[1] = "";
            }
            try {
                itemList = element.getElementsByTagName(S_DESC);
                fileElement = (Element)itemList.item(0);
                value = fileElement.getFirstChild().getNodeValue();
                rec[2] = value;
            }
            catch (Exception ex) {
                rec[2] = "";
            }
            try {
                itemList = element.getElementsByTagName(S_WORDS);
                fileElement = (Element)itemList.item(0);
                value = fileElement.getFirstChild().getNodeValue();
                rec[3] = value;
            }
            catch (Exception ex) {
                rec[3] = "";
            }
            try {
                itemList = element.getElementsByTagName(S_SEC);
                fileElement = (Element)itemList.item(0);
                value = fileElement.getFirstChild().getNodeValue();
                rec[4] = value;
            }
            catch (Exception ex) {
                rec[4] = "";
            }
            try {
                itemList = element.getElementsByTagName(S_KEY);
                fileElement = (Element)itemList.item(0);
                value = fileElement.getFirstChild().getNodeValue();
                rec[6] = value;
            }
            catch (Exception ex) {
                rec[6] = sbedit.makeKeyUID();
            }
            this.addRow(rec);
            ++i;
        }
        try {
            list = root.getElementsByTagName(S_BOOKMARKS);
            booktag = (Element)list.item(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        list = booktag.getElementsByTagName(S_MARK);
        if (list.getLength() > 0) {
            this.bookmarks = new DefaultListModel();
            int i2 = 0;
            while (i2 < list.getLength()) {
                block53: {
                    String point;
                    String key;
                    NodeList itemList;
                    Element element = (Element)list.item(i2);
                    try {
                        itemList = element.getElementsByTagName(S_NAME);
                        fileElement = (Element)itemList.item(0);
                        key = value = fileElement.getFirstChild().getNodeValue();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        break block53;
                    }
                    try {
                        itemList = element.getElementsByTagName(S_POINT);
                        fileElement = (Element)itemList.item(0);
                        point = value = fileElement.getFirstChild().getNodeValue();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        break block53;
                    }
                    BookmarkItem item = new BookmarkItem(key, point);
                    this.bookmarks.addElement(item);
                }
                ++i2;
            }
        }
        try {
            list = root.getElementsByTagName(S_SIZE);
            fileElement = (Element)list.item(0);
            value = fileElement.getFirstChild().getNodeValue();
            this.iconsize = S_ICON_LARGE.equalsIgnoreCase(value) ? 2 : (S_ICON_MIDDLE.equalsIgnoreCase(value) ? 1 : 0);
        }
        catch (Exception ex) {
            this.iconsize = 0;
        }
        try {
            list = root.getElementsByTagName("wide");
            fileElement = (Element)list.item(0);
            value = fileElement.getFirstChild().getNodeValue();
            this.iconmode = "wide".equalsIgnoreCase(value) ? 1 : 0;
        }
        catch (Exception ex) {
            this.iconmode = 0;
        }
        try {
            list = root.getElementsByTagName(S_TITLE);
            fileElement = (Element)list.item(0);
            this.title = fileElement.getFirstChild().getNodeValue();
        }
        catch (Exception ex) {
            this.title = "\u7121\u984c";
        }
        try {
            list = root.getElementsByTagName(S_FRAMERATE);
            fileElement = (Element)list.item(0);
            If = new Integer(fileElement.getFirstChild().getNodeValue());
            this.frameRate = If;
        }
        catch (Exception ex) {
            this.frameRate = 24;
        }
        try {
            list = root.getElementsByTagName(S_AUTHOR);
            fileElement = (Element)list.item(0);
            this.author = fileElement.getFirstChild().getNodeValue();
        }
        catch (Exception ex) {
            this.author = null;
        }
        try {
            list = root.getElementsByTagName(S_CURX);
            fileElement = (Element)list.item(0);
            value = fileElement.getFirstChild().getNodeValue();
            this.cur_x = new Integer(value);
            if (this.cur_x < 0) {
                this.cur_x = 0;
            }
            if (this.cur_x > 4) {
                this.cur_x = 4;
            }
        }
        catch (Exception ex) {
            this.cur_x = 0;
        }
        try {
            list = root.getElementsByTagName(S_CURY);
            fileElement = (Element)list.item(0);
            value = fileElement.getFirstChild().getNodeValue();
            this.cur_y = Integer.valueOf(value);
            if (this.cur_y < 0) {
                this.cur_y = 0;
            }
            if (this.cur_y > lis - 1) {
                this.cur_y = lis - 1;
            }
        }
        catch (Exception ex) {
            this.cur_y = 0;
        }
        try {
            list = root.getElementsByTagName(S_LINE_LOCK);
            fileElement = (Element)list.item(0);
            value = fileElement.getFirstChild().getNodeValue();
            this.line_lock = value.equalsIgnoreCase("true");
        }
        catch (Exception ex) {
            this.line_lock = false;
        }
        try {
            list = root.getElementsByTagName(S_LINESPARPAGE);
            fileElement = (Element)list.item(0);
            If = new Integer(fileElement.getFirstChild().getNodeValue());
            this.linesparpage = If;
        }
        catch (Exception ex) {
            this.linesparpage = 5;
        }
        this.renumCutNumber(0);
        this.renumTotalTime();
        this.resetEditing();
    }

    /*
     * Unable to fully structure code
     */
    public void scanImageDef(String filename) {
        docf = new File(filename);
        imgpath = String.valueOf(docf.getParent()) + File.separator + "img" + File.separator;
        cashS = String.valueOf(imgpath) + "S" + File.separator;
        cashM = String.valueOf(imgpath) + "M" + File.separator;
        cashL = String.valueOf(imgpath) + "L" + File.separator;
        i = 0;
        while (i < this.getRowCount()) {
            imgfile = this.getImgNameAt(i);
            if (imgfile == null || imgfile.length() <= 0) {
                key = String.valueOf(imgpath) + (String)this.getValueAt(i, 6);
                exts = ImageIO.getReaderFormatNames();
                j = 0;
                while (j < exts.length) {
                    img = new File(String.valueOf(key) + exts[j]);
                    if (img.getAbsoluteFile().exists()) {
                        this.setValueAt("./img/" + img.getName(), i, 1);
                        break;
                    }
                    ++j;
                }
            } else {
                img = new File(imgfile);
                if (!img.getAbsoluteFile().exists()) {
                    this.logger.warning(String.valueOf(i) + "\u884c\u76ee\uff1a\u5b58\u5728\u3057\u306a\u3044\u30d5\u30a1\u30a4\u30eb\u540d\uff1d" + imgfile);
                } else {
                    try {
                        f = new File(String.valueOf(cashS) + this.getNotSuffix(img.getName()) + ".png").getCanonicalFile();
                        if (f.length() <= 0L) {
                            var11_13 = f.delete();
                        }
                        if ((f = new File(String.valueOf(cashM) + this.getNotSuffix(img.getName()) + ".png").getCanonicalFile()).length() <= 0L) {
                            var11_14 = f.delete();
                        }
                        if ((f = new File(String.valueOf(cashL) + this.getNotSuffix(img.getName()) + ".png").getCanonicalFile()).length() > 0L) ** GOTO lbl36
                        var11_15 = f.delete();
                    }
                    catch (Exception e) {
                        this.logger.warning(e.toString());
                    }
                }
            }
            ++i;
        }
    }

    public void flashImageCash(boolean isdo) {
        if (!isdo) {
            return;
        }
        if (this.docFileDir == null) {
            return;
        }
        String cdirname = "S";
        switch (this.iconsize) {
            case 2: {
                cdirname = "L";
                break;
            }
            case 1: {
                cdirname = "M";
            }
        }
        try {
            String cashDirName = String.valueOf(this.docFileDir.getCanonicalPath()) + File.separator + S_IMG + File.separator + cdirname;
            File cashDir = new File(cashDirName);
            cashDir.getCanonicalFile().mkdirs();
        }
        catch (IOException e) {
            return;
        }
        int i = 0;
        while (i < this.getRowCount()) {
            String imgfile = this.getImgNameAt(i);
            if (imgfile != null && imgfile.length() > 0) {
                try {
                    String key = (String)this.getValueAt(i, 6);
                    ImageIcon icon = this.icons.get(key);
                    this.saveIconCashFile(imgfile, icon, cdirname);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.logger.warning(e.toString());
                }
            }
            ++i;
        }
    }

    private void saveIconCashFile(String imgfilename, ImageIcon icon, String cdirname) {
        if (this.docFileDir == null || imgfilename == null || icon == null || cdirname == null) {
            return;
        }
        File readImgFile = new File(imgfilename);
        Image img = icon.getImage();
        if (img == null) {
            return;
        }
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        if (w <= 0 || h <= 0) {
            return;
        }
        BufferedImage bimg = new BufferedImage(w, h, 5);
        Graphics2D g = bimg.createGraphics();
        g.drawImage(img, 0, 0, null);
        try {
            try {
                String cashDirName = String.valueOf(this.docFileDir.getCanonicalPath()) + File.separator + S_IMG + File.separator + cdirname;
                String cashFileName = String.valueOf(cashDirName) + File.separator + this.getNotSuffix(readImgFile.getName()) + ".png";
                File cashFile = new File(cashFileName);
                if (cashFile.getCanonicalFile().lastModified() < readImgFile.getCanonicalFile().lastModified()) {
                    cashFile.getCanonicalFile().delete();
                    ImageIO.write((RenderedImage)bimg, "png", cashFile.getCanonicalFile());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.logger.warning(e.toString());
                g.dispose();
                bimg.flush();
                bimg = null;
            }
        }
        finally {
            g.dispose();
            bimg.flush();
            bimg = null;
        }
    }

    public void addBookmark(int row, String keyword) {
        String point = (String)this.getValueAt(row, 6);
        if (this.bookmarks == null) {
            this.bookmarks = new DefaultListModel();
        }
        BookmarkItem item = new BookmarkItem(keyword, point);
        if (this.bookmarks.isEmpty()) {
            this.bookmarks.addElement(item);
        } else {
            int max = this.bookmarks.getSize();
            int i = 0;
            while (i < max) {
                BookmarkItem it = (BookmarkItem)this.bookmarks.getElementAt(i);
                int line = this.getBookmarkRow(it.key);
                if (line < 0) {
                    this.logger.info("\u4e0d\u6b63\u3057\u304a\u308a=" + i);
                    this.bookmarks.remove(i);
                    --max;
                } else if (row < line) {
                    if (i > 0) {
                        this.bookmarks.add(i - 1, item);
                        break;
                    }
                    this.bookmarks.add(0, item);
                    break;
                }
                ++i;
            }
            if (i >= max) {
                this.bookmarks.addElement(item);
            }
        }
    }

    public int getBookmarkRow(String keyword) {
        int row = -1;
        if (this.bookmarks != null) {
            String point = null;
            int i = 0;
            while (i < this.bookmarks.getSize()) {
                BookmarkItem item = (BookmarkItem)this.bookmarks.getElementAt(i);
                if (item.key.equals(keyword)) {
                    point = item.point;
                }
                ++i;
            }
            if (point != null) {
                int max = this.getRowCount();
                int i2 = 0;
                while (i2 < max) {
                    String key = (String)this.getValueAt(i2, 6);
                    if (point.equals(key)) {
                        row = i2;
                        break;
                    }
                    ++i2;
                }
            }
        }
        return row;
    }

    String[] getBookmarkKeys() {
        String[] ret;
        if (this.bookmarks == null) {
            ret = null;
        } else {
            ret = new String[this.bookmarks.size()];
            int i = 0;
            while (i < ret.length) {
                BookmarkItem item = (BookmarkItem)this.bookmarks.elementAt(i);
                ret[i] = item.key;
                ++i;
            }
        }
        return ret;
    }

    int getBookMarkSize() {
        if (this.bookmarks == null) {
            return 0;
        }
        return this.bookmarks.size();
    }

    void clearBookmark() {
        if (this.bookmarks != null) {
            this.bookmarks.clear();
        }
    }

    DefaultListModel getBookmarks() {
        return this.bookmarks;
    }

    void setTitle(String s) {
        if (s != null) {
            this.title = s;
        }
        this.setEditing();
    }

    String getTitle() {
        return this.title;
    }

    void setPos(int x, int y) {
        this.cur_x = x;
        this.cur_y = y;
    }

    int getPosX() {
        if (this.cur_x == null) {
            return 1;
        }
        return this.cur_x;
    }

    int getPosY() {
        if (this.cur_y == null) {
            return 0;
        }
        return this.cur_y;
    }

    String getDocID() {
        return this.docid;
    }

    void setLinesParPage(int p) {
        this.linesparpage = p;
        this.setEditing();
    }

    int getLinesParPage() {
        return this.linesparpage;
    }

    int removeSpace() {
        int lastrow = this.getRowCount() - 1;
        while (lastrow >= 0) {
            if (this.getValueAt(lastrow, 1).toString().length() > 0 || this.getValueAt(lastrow, 2).toString().length() > 0 || this.getValueAt(lastrow, 3).toString().length() > 0 || this.getValueAt(lastrow, 4).toString().length() > 0) break;
            --lastrow;
        }
        if (lastrow < this.getRowCount() - 1) {
            this.setRowCount(lastrow + 1);
        }
        if (lastrow < this.cur_y) {
            this.cur_y = lastrow;
        }
        return lastrow;
    }

    int removeSpaceAll() {
        int delrow = this.getRowCount() - 1;
        while (delrow >= 0) {
            if (this.getValueAt(delrow, 1).toString().length() <= 0 && this.getValueAt(delrow, 2).toString().length() <= 0 && this.getValueAt(delrow, 3).toString().length() <= 0 && this.getValueAt(delrow, 4).toString().length() <= 0) {
                this.removeRow(delrow);
            }
            --delrow;
        }
        return delrow;
    }

    public boolean flipImage(int row) {
        BufferedImage image;
        boolean pngflg = false;
        String srcfilename = null;
        srcfilename = this.getImgNameAt(row);
        if (srcfilename == null) {
            return false;
        }
        if (srcfilename.length() <= 0) {
            return false;
        }
        File f = new File(srcfilename);
        try {
            image = ImageIO.read(f.getAbsoluteFile());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        Hanten hanten = new Hanten(image);
        BufferedImage dstimage = hanten.RightSideLeft();
        String dstfilename = null;
        String extension = this.getSuffix(srcfilename);
        if (!"png".equalsIgnoreCase(extension)) {
            dstfilename = String.valueOf(this.getNotSuffix(srcfilename)) + ".png";
            extension = "png";
            pngflg = true;
        } else {
            dstfilename = srcfilename;
        }
        File dest = new File(dstfilename);
        try {
            ImageIO.write((RenderedImage)dstimage, extension, dest.getAbsoluteFile());
            if (pngflg) {
                this.setValueAt(dstfilename, row, 1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        image.flush();
        image = null;
        return pngflg;
    }

    public boolean pasteImage(int row) {
        boolean ret = true;
        try {
            Image tmpimg = SystemClip.getImage();
            if (tmpimg != null) {
                BufferedImage image = (BufferedImage)tmpimg;
                String imgfilename = "." + File.separator + S_IMG + File.separator + this.getValueAt(row, 6) + ".png";
                File dest = new File(imgfilename);
                ImageIO.write((RenderedImage)image, "png", dest.getAbsoluteFile());
                this.setValueAt(imgfilename, row, 1);
                image.flush();
                image = null;
            }
        }
        catch (Exception err) {
            err.printStackTrace();
            ret = false;
        }
        return ret;
    }

    private String getSuffix(String filename) {
        int i = filename.lastIndexOf(46);
        if (i > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return "";
    }

    private String getNotSuffix(String filename) {
        int i = filename.lastIndexOf(46);
        if (i > 0 && i < filename.length() - 1) {
            return filename.substring(0, i);
        }
        return filename;
    }

    public void makeDIRS(String pFilename) {
        if (pFilename == null) {
            return;
        }
        if (pFilename.length() <= 0) {
            return;
        }
        String imagedir = pFilename.substring(0, pFilename.lastIndexOf(46));
        imagedir = String.valueOf(imagedir) + "_CUT";
        imagedir = String.valueOf(imagedir) + File.separator;
        try {
            File f = new File(imagedir);
            f.mkdirs();
        }
        catch (Exception e) {
            this.logger.warning(e.toString());
        }
        String keta = null;
        keta = this.getRowCount() > 999 ? "0000" : (this.getRowCount() > 99 ? "000" : (this.getRowCount() > 9 ? "00" : "#####"));
        int i = 0;
        while (i < this.getRowCount()) {
            Float Fr;
            Object ob = this.getValueAt(i, 0);
            try {
                Fr = new Float(ob.toString());
            }
            catch (Exception e) {
                Fr = new Float(-1.0f);
            }
            if (Fr.floatValue() > 0.0f) {
                String cutnum = "";
                Float intf = new Float(Fr.intValue());
                if (Fr.compareTo(intf) <= 0) {
                    Integer Ir = intf.intValue();
                    DecimalFormat exFormat = new DecimalFormat(keta);
                    cutnum = exFormat.format(Ir);
                } else {
                    DecimalFormat exFormat = new DecimalFormat(String.valueOf(keta) + ".####");
                    cutnum = exFormat.format(Fr);
                    cutnum = cutnum.replace('.', '_');
                }
                String cutdir = String.valueOf(imagedir) + "C" + cutnum;
                try {
                    File cf = new File(cutdir);
                    cf.mkdirs();
                }
                catch (Exception e) {
                    this.logger.warning("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u5931\u6557 " + e.toString());
                }
            }
            ++i;
        }
    }

    boolean getLineLock() {
        return this.line_lock;
    }

    void setLineLock(boolean p) {
        this.line_lock = p;
        this.setEditing();
    }

    int getFrameRate() {
        return this.frameRate;
    }

    void setFrameRate(int p) {
        this.frameRate = p;
        this.setEditing();
    }

    public String getAuthor() {
        if (this.author == null) {
            this.author = System.getProperty("user.name");
        }
        return this.author;
    }

    public void setAuthor(String p) {
        this.author = p;
        this.setEditing();
    }

    public void setDocFileName(String p) {
        this.docFileName = p;
        this.docFileDir = new File(p).getParentFile();
        this.logger.info("filename=" + p + " docdir=" + this.docFileDir.toString());
    }

    public void clearProperties() {
        this.title = null;
        this.author = null;
        this.frameRate = 24;
        this.line_lock = false;
    }

    public File getDocFileDir() {
        return this.docFileDir;
    }

    public void setSubTitle(String p) {
        this.subtitle = p;
    }

    public String getSubTitle() {
        return this.subtitle;
    }

    public void setCompany(String p) {
        this.company = p;
    }

    public String getCompany() {
        return this.company;
    }

    public void setEditor(String p) {
        this.editor = p;
    }

    public String getEditor() {
        return this.editor;
    }

    void outWzMemo(String filename) throws Exception {
        WzMemo wz = new WzMemo(this, this.bookmarks);
        wz.write(filename);
    }

    void inWzMemo(String filename) throws Exception {
        if (this.bookmarks != null) {
            this.bookmarks.clear();
        } else {
            this.bookmarks = new DefaultListModel();
        }
        WzMemo wz = new WzMemo(this, this.bookmarks);
        wz.read(filename);
    }

    public void AuxiTimeCalc() {
        WzMemo wz = new WzMemo(this, this.bookmarks);
        wz.calcTimes();
    }

    public CharacterTableModel getCharList() {
        if (this.charList == null) {
            this.charList = new CharacterTableModel(0);
            this.logger.info("\u30ea\u30b9\u30c8\u4f5c\u6210:\u5217\uff1d" + this.charList.getColumnCount() + " \u884c\uff1d" + this.charList.getRowCount());
        }
        return this.charList;
    }

    void inNazoh(String filename) throws Exception {
        if (this.bookmarks != null) {
            this.bookmarks.clear();
        } else {
            this.bookmarks = new DefaultListModel();
        }
        Nazoh nz = new Nazoh(this, this.bookmarks, this.logger);
        nz.read(filename);
    }

    public ArrayList<Integer> checkWords() {
        WzMemo wz = new WzMemo(this, this.bookmarks);
        return wz.checkWords();
    }

    public boolean isEditing() {
        return this.editing;
    }

    private void setEditing() {
        this.editing = true;
    }

    private void resetEditing() {
        this.editing = false;
    }

    public void initEnd() {
        this.resetEditing();
    }
}

