/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class Nekomata {
    private Logger logger;

    Nekomata(Logger l) {
        this.logger = l;
    }

    public boolean copy(String fromDir, String sbdfile, boolean isoverwrite) throws Exception {
        if (fromDir == null || sbdfile == null) {
            this.logger.info("\u30d1\u30e9\u30e1\u30fc\u30bf\u304cnull " + fromDir + " " + sbdfile);
            return false;
        }
        File sbdf = new File(sbdfile);
        String toDir = sbdf.getParent();
        this.logger.info("ToDIr=" + toDir + "  sbdfile=" + sbdfile + " Name=" + sbdf.getName());
        String to_js = String.valueOf(toDir) + File.separator + "sbdConvert.js";
        this.logger.info("FromDir=" + fromDir + "  jsf=" + to_js);
        File check = new File(to_js).getCanonicalFile();
        if (check.exists() && !isoverwrite) {
            this.logger.info("sbdConvert.js\u304c\u65e2\u306b\u3042\u308b\u306e\u3067\u30b3\u30d4\u30fc\u3057\u306a\u3044 " + check.getCanonicalPath());
            return false;
        }
        FileUtils.copyFileToDirectory((File)new File(String.valueOf(fromDir) + File.separatorChar + "sbdConvert.html"), (File)new File(toDir), (boolean)true);
        FileUtils.copyFileToDirectory((File)new File(String.valueOf(fromDir) + File.separatorChar + "sbdPlayer.html"), (File)new File(toDir), (boolean)true);
        File srcDir = new File(String.valueOf(fromDir) + File.separatorChar + "sbdConvert");
        File destDir = new File(toDir);
        FileUtils.copyDirectoryToDirectory((File)srcDir, (File)destDir);
        String data = FileUtils.readFileToString((File)new File(String.valueOf(fromDir) + File.separatorChar + "sbdConvert.js"), (String)"UTF-8");
        data = data.replaceAll("readme.sbd", sbdf.getName());
        FileUtils.writeStringToFile((File)new File(String.valueOf(toDir) + File.separatorChar + "sbdConvert.js"), (String)data, (String)"UTF-8");
        data = FileUtils.readFileToString((File)new File(String.valueOf(fromDir) + File.separatorChar + "sbdPlayer.js"), (String)"UTF-8");
        data = data.replaceAll("readme.sbd", sbdf.getName());
        FileUtils.writeStringToFile((File)new File(String.valueOf(toDir) + File.separatorChar + "sbdPlayer.js"), (String)data, (String)"UTF-8");
        return true;
    }

    public void open(String urlstr, String firefoxDir) {
        if (firefoxDir != null) {
            this.logger.info("Firefox=" + firefoxDir);
            try {
                urlstr = "file:///" + urlstr;
                Process proc = Runtime.getRuntime().exec(new String[]{firefoxDir, urlstr});
                this.logger.info("Firefox\u8d77\u52d5\u3000\u30d7\u30ed\u30bb\u30b9\uff1d" + proc.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.warning(e.toString());
            }
        } else {
            this.logger.info("use BrowserLauncher.openURL");
            try {
                Desktop dt;
                if (Desktop.isDesktopSupported() && (dt = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                    dt.browse(new URI(urlstr));
                }
            }
            catch (IOException ioe) {
                this.logger.warning("\u6a19\u6e96\u306e\u30a4\u30f3\u30bf\u30fc\u30cd\u30c3\u30c8\u30d6\u30e9\u30a6\u30b6\u8d77\u52d5\u5931\u6557");
                this.logger.warning(ioe.toString());
            }
            catch (URISyntaxException e) {
                this.logger.warning("\u30d8\u30eb\u30d7\uff35\uff32\uff2c\u306e\u6587\u6cd5\u8aa4\u308a\u3002URL=" + urlstr);
                this.logger.warning(e.toString());
                e.printStackTrace();
            }
        }
    }
}

