/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import org.apache.commons.lang.StringUtils;

public class Nazoh {
    private SBDTableModel tbl;
    Logger logger;
    final String CODE = "UTF-8";
    int global_num = 1;
    int cutnum = 0;
    String sb_desc = "";
    String sb_words = "";
    String sb_img = "";
    float sb_time = 0.0f;

    public Nazoh(SBDTableModel p_tbl, DefaultListModel p_bookmarks, Logger p_logger) {
        this.tbl = p_tbl;
        this.logger = p_logger;
    }

    public void read(String filename) throws Exception {
        String line;
        FileInputStream is = new FileInputStream(filename);
        InputStreamReader in = new InputStreamReader((InputStream)is, "UTF-8");
        BufferedReader bf = new BufferedReader(in);
        boolean cutnum = true;
        while ((line = bf.readLine()) != null) {
            NAZ_LINE naz_line;
            if (line.length() <= 0 || (naz_line = this.splitLine(line)) == null) continue;
            this.logger.info("NAZLINE=" + naz_line);
            switch (naz_line.type) {
                case KEYVALUE: {
                    this.key_value(naz_line);
                    break;
                }
                case PARAMS: {
                    this.params(naz_line);
                    break;
                }
                case PARAMSEND: {
                    this.params_end(naz_line);
                    break;
                }
                case DATA: {
                    this.data(naz_line);
                    break;
                }
                case KOMAINFO: {
                    this.koma_info(naz_line);
                    break;
                }
                case KOMAINFOEND: {
                    this.koma_info_end(naz_line);
                    break;
                }
                case END: {
                    this.end(naz_line);
                    break;
                }
                default: {
                    this.logger.info("DEFault");
                }
            }
        }
        bf.close();
        in.close();
        is.close();
    }

    void koma_info(NAZ_LINE naz_line) {
        this.cutnum = this.global_num++;
        this.sb_desc = "";
        this.sb_words = "";
        this.sb_time = 0.0f;
    }

    void koma_info_end(NAZ_LINE naz_line) {
    }

    void key_value(NAZ_LINE naz_line) {
        this.logger.info("K:" + naz_line.key + " V:" + naz_line.value);
    }

    void params(NAZ_LINE naz_line) {
    }

    void params_end(NAZ_LINE naz_line) {
    }

    void data(NAZ_LINE naz_line) {
    }

    void end(NAZ_LINE naz_line) {
    }

    NAZ_LINE splitLine(String line) {
        String[] kv = StringUtils.split((String)line, (char)'\t');
        this.logger.info("Input=" + line);
        if (kv.length <= 0) {
            this.logger.info("ret:null");
            return null;
        }
        NAZ_LINE ret = new NAZ_LINE();
        if (kv.length >= 1) {
            ret.key = kv[0];
        }
        if (kv.length >= 2) {
            ret.value = kv[1];
        }
        this.logger.info("Key=" + ret.key + " Value=" + ret.value);
        ret.type = ret.key.equalsIgnoreCase("*KomaInfo") ? NZ_TYPE.KOMAINFO : (ret.key.equalsIgnoreCase("*KomaInfoEnd") ? NZ_TYPE.KOMAINFOEND : NZ_TYPE.KEYVALUE);
        return ret;
    }

    private void addRow(int row, StringBuilder sb_desc, StringBuilder sb_words, String bmk) {
        if (sb_desc == null && sb_words == null) {
            return;
        }
        Object[] rec = new Object[7];
        rec[0] = new Float(row);
        rec[1] = "";
        rec[2] = sb_desc != null ? sb_desc.toString() : "";
        rec[3] = sb_words != null ? sb_words.toString() : "";
        rec[4] = "";
        rec[6] = sbedit.makeKeyUID();
        this.tbl.addRow(rec);
    }

    public void write(String filename) throws Exception {
        StringBuilder sb = new StringBuilder();
        BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
        int i = this.tbl.getRowCount() - 1;
        while (i >= 0) {
            String desc = this.tbl.getValueAt(i, 2).toString();
            String words = this.tbl.getValueAt(i, 3).toString();
            sb.insert(0, "\r\n");
            sb.insert(0, words);
            sb.insert(0, "\r\n");
            sb.insert(0, desc);
            --i;
        }
        try {
            try {
                writer.write(sb.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            writer.flush();
            writer.close();
            sb = null;
        }
    }

    class NAZ_LINE {
        NZ_TYPE type = NZ_TYPE.OTHER;
        String key = "";
        String value = "";
    }

    static enum NZ_TYPE {
        PARAMS,
        PARAMSEND,
        DATA,
        KOMAINFO,
        KOMAINFOEND,
        END,
        KEYVALUE,
        OTHER;

    }
}

