/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.webservicex.www.Language;
import net.webservicex.www.TranslateServiceLocator;
import net.webservicex.www.TranslateServiceSoap;

public class MakeTranslate
extends MakeTemplate {
    private int min;
    private int max;

    public MakeTranslate(String p_filename, int p_min, int p_max, String p_path, SBDTableModel p_model, DialogProgress p_dlg) {
        super(p_filename, p_path, p_model, p_dlg);
        this.min = p_min;
        this.max = p_max;
    }

    @Override
    void exec() {
        TranslateServiceSoap trans;
        try {
            TranslateServiceLocator locator = new TranslateServiceLocator();
            trans = locator.getTranslateServiceSoap();
        }
        catch (Exception e) {
            String errmsg = "WEB\u30b5\u30fc\u30d3\u30b9\u30a8\u30f3\u30c9\u30dd\u30a4\u30f3\u30c8\u53d6\u5f97\u5931\u6557\u3002\u539f\u56e0\uff1d" + e.toString();
            this.logger.warning(errmsg);
            e.printStackTrace();
            if (this.lock.getState()) {
                JOptionPane.showMessageDialog(this.dlg.getContentPane(), errmsg, "\u7ffb\u8a33\u30b5\u30fc\u30d3\u30b9\u63a5\u7d9a\u5931\u6557", 1);
            }
            return;
        }
        int start = this.min;
        int end = this.max;
        int i = start;
        while (i <= end) {
            if (!this.lock.getState()) {
                this.logger.warning("\u30e1\u30a4\u30f3\u30b9\u30ec\u30c3\u30c9\u304b\u3089\u306e\u6307\u793a\u3067\u7ffb\u8a33\u4e2d\u65ad");
                break;
            }
            String desc = (String)this.model.getValueAt(i, 2);
            String words = (String)this.model.getValueAt(i, 3);
            try {
                if (desc != null && desc.length() > 0) {
                    if ((desc = trans.translate(Language.JapaneseTOEnglish, desc)).indexOf("remote server returned an error:") > 0 || desc.indexOf("support@webservicex.net") > 0) {
                        throw new IllegalStateException(desc);
                    }
                    this.logger.info("desc=" + desc.indexOf("remote server returned an error:"));
                }
                if (words != null && words.length() > 0 && ((words = trans.translate(Language.JapaneseTOEnglish, words)).indexOf("remote server returned an error:") > 0 || words.indexOf("support@webservicex.net") > 0)) {
                    throw new IllegalStateException(words);
                }
                if (!this.fileName.equalsIgnoreCase("JapaneseTOEnglish")) {
                    Language lang = Language.fromString(this.fileName);
                    if (desc != null && desc.length() > 0 && ((desc = trans.translate(lang, this.deleteNotAlpha(desc))).indexOf("remote server returned an error:") > 0 || desc.indexOf("support@webservicex.net") > 0)) {
                        throw new IllegalStateException(desc);
                    }
                    if (words != null && words.length() > 0 && ((words = trans.translate(lang, this.deleteNotAlpha(words))).indexOf("remote server returned an error:") > 0 || words.indexOf("support@webservicex.net") > 0)) {
                        throw new IllegalStateException(words);
                    }
                }
                this.model.setValueAt(desc, i, 2);
                this.model.setValueAt(words, i, 3);
            }
            catch (Exception e) {
                String errmsg = "WEB\u30b5\u30fc\u30d3\u30b9\u5b9f\u884c\u5931\u6557\u3002\n\u539f\u56e0\uff1d" + e.toString();
                this.logger.warning(errmsg);
                e.printStackTrace();
                JOptionPane.showMessageDialog(this.dlg.getContentPane(), errmsg, "\u7ffb\u8a33\u5931\u6557", 1);
                return;
            }
            try {
                this.prog = i;
                SwingUtilities.invokeLater(this.updateAComponent);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    private String deleteNotAlpha(String inp) {
        StringBuilder charstr = new StringBuilder(inp);
        int i = 0;
        while (i < charstr.length()) {
            if (charstr.charAt(i) <= ' ' || charstr.charAt(i) >= '\u007f') {
                charstr.setCharAt(i, ' ');
            }
            ++i;
        }
        return charstr.toString();
    }
}

