/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.io;

import com.anotherbigidea.io.OutputStreamWrapper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class OutStream
extends OutputStreamWrapper {
    private int mBitBuf;
    private int mBitPos;

    public OutStream(OutputStream out) {
        super(out);
        this.initBits();
    }

    protected OutStream() {
        super(null);
    }

    public void writeSBits(int numBits, int value) throws IOException {
        long lval = value & Integer.MAX_VALUE;
        if (value < 0) {
            lval |= 1L << numBits - 1;
        }
        this.writeUBits(numBits, lval);
    }

    @Override
    public void flush() throws IOException {
        this.flushBits();
        super.flush();
    }

    public void writeCompressed() {
        this.setOutputStream(new DeflaterOutputStream(this.getOutputStream(), new Deflater(9)));
    }

    public void flushBits() throws IOException {
        if (this.mBitPos == 0) {
            return;
        }
        super.write(this.mBitBuf);
        this.mBitBuf = 0;
        this.mBitPos = 0;
    }

    /*
     * Unable to fully structure code
     */
    public void writeUBits(int numBits, long value) throws IOException {
        if (numBits == 0) {
            return;
        }
        if (this.mBitPos == 0) {
            this.mBitPos = 8;
        }
        bitNum = numBits;
        ** GOTO lbl18
        {
            if (OutStream.getBit(bitNum, value)) {
                this.mBitBuf = OutStream.setBit(this.mBitPos, this.mBitBuf);
            }
            --bitNum;
            --this.mBitPos;
            do {
                if (this.mBitPos > 0 && bitNum > 0) continue block0;
                if (this.mBitPos != 0) continue;
                this.writeUI8(this.mBitBuf);
                this.mBitBuf = 0;
                if (bitNum <= 0) continue;
                this.mBitPos = 8;
lbl18:
                // 4 sources

            } while (bitNum > 0);
        }
    }

    public static boolean getBit(int bitNum, long value) {
        return (value & 1L << bitNum - 1) != 0L;
    }

    public static int setBit(int bitNum, int value) {
        return value | 1 << bitNum - 1;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.flushBits();
        if (bytes != null && bytes.length > 0) {
            super.write(bytes);
        }
    }

    @Override
    public void write(byte[] bytes, int start, int length) throws IOException {
        this.flushBits();
        if (bytes != null && length > 0) {
            super.write(bytes, start, length);
        }
    }

    public void writeUI8(int value) throws IOException {
        this.flushBits();
        super.write(value);
    }

    public void writeUI16(int value) throws IOException {
        this.flushBits();
        super.write(value & 0xFF);
        super.write(value >> 8);
    }

    public void writeSI16(short value) throws IOException {
        this.flushBits();
        super.write(value & 0xFF);
        super.write(value >> 8);
    }

    public void writeUI32(long value) throws IOException {
        this.flushBits();
        super.write((int)(value & 0xFFL));
        super.write((int)(value >> 8));
        super.write((int)(value >> 16));
        super.write((int)(value >> 24));
    }

    public void writeString(String s, String encoding) throws IOException {
        if (s == null) {
            s = "";
        }
        this.writeString(s.getBytes(encoding));
    }

    public void writeString(byte[] string) throws IOException {
        this.flushBits();
        if (string != null) {
            super.write(string);
        }
        super.write(0);
    }

    public static int getStringLength(byte[] string) {
        if (string == null) {
            return 1;
        }
        return string.length + 1;
    }

    public static int getStringLength(String string) {
        if (string == null) {
            return 1;
        }
        byte[] bytes = string.getBytes();
        return bytes.length + 1;
    }

    private void initBits() {
        this.mBitBuf = 0;
        this.mBitPos = 0;
    }

    public static int determineSignedBitSize(int value) {
        if (value >= 0) {
            return OutStream.determineUnsignedBitSize(value) + 1;
        }
        int topBit = 31;
        long mask = 0x40000000L;
        while (topBit > 0) {
            if (((long)value & mask) == 0L) break;
            mask >>= 1;
            --topBit;
        }
        if (topBit == 0) {
            return 2;
        }
        int val2 = value & (1 << topBit) - 1;
        if (val2 == 0) {
            ++topBit;
        }
        return topBit + 1;
    }

    public static int determineUnsignedBitSize(long value) {
        int topBit = 32;
        long mask = 0x80000000L;
        while (topBit > 0) {
            if ((value & mask) != 0L) {
                return topBit;
            }
            mask >>= 1;
            --topBit;
        }
        return 0;
    }

    public void writeFloat(float value) throws IOException {
        this.writeSI32(Float.floatToIntBits(value));
    }

    public void writeDouble(double value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(baos);
        dout.writeDouble(value);
        dout.flush();
        byte[] bytes = baos.toByteArray();
        byte[] bytes2 = new byte[]{bytes[3], bytes[2], bytes[1], bytes[0], bytes[7], bytes[6], bytes[5], bytes[4]};
        this.write(bytes2);
    }

    public void writeSI32(int value) throws IOException {
        this.flushBits();
        super.write(value & 0xFF);
        super.write(value >> 8);
        super.write(value >> 16);
        super.write(value >> 24);
    }

    public static byte[] sintTo2Bytes(int value) {
        return new byte[]{OutStream.uintToByte(value & 0xFF), OutStream.uintToByte(value >> 8)};
    }

    public static byte[] uintTo2Bytes(int value) {
        return new byte[]{OutStream.uintToByte(value & 0xFF), OutStream.uintToByte(value >> 8)};
    }

    public static byte[] uintTo4Bytes(int value) {
        return new byte[]{OutStream.uintToByte(value & 0xFF), OutStream.uintToByte(value >> 8), OutStream.uintToByte(value >> 16), OutStream.uintToByte(value >> 24)};
    }

    public static byte uintToByte(int value) {
        int lowbit = value & 1;
        byte b = (byte)(value >>= 1);
        b = (byte)(b << 1);
        b = (byte)(b | (byte)lowbit);
        return b;
    }

    @Override
    public void write(int b) throws IOException {
        this.flushBits();
        super.write(b);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }
}

