/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.writers;

import com.anotherbigidea.flash.interfaces.SWFFileSignature;
import com.anotherbigidea.flash.interfaces.SWFTags;
import com.anotherbigidea.flash.structs.Rect;
import com.anotherbigidea.io.OutStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SWFWriter
implements SWFTags,
SWFFileSignature {
    protected OutStream mOut;
    protected OutputStream mOutputstream;
    protected ByteArrayOutputStream mByteout;
    protected String mSignature = null;
    protected int frameCount;
    protected int version;
    protected Rect frameSize;
    protected int height;
    protected int rate;

    public SWFWriter(String filename) throws IOException {
        this(new FileOutputStream(filename));
    }

    public SWFWriter(OutputStream outputstream) {
        this.mOutputstream = outputstream;
        this.mOut = new OutStream(outputstream);
    }

    public SWFWriter(OutStream outstream) {
        this.mOut = outstream;
    }

    @Override
    public void signature(String sig) {
        if (this.mSignature != null) {
            return;
        }
        this.mSignature = sig;
    }

    public void setCompression(boolean compressionOn) {
        this.signature(compressionOn ? "CWS" : "FWS");
    }

    @Override
    public void header(int version, long length, int twipsWidth, int twipsHeight, int frameRate, int frameCount) throws IOException {
        this.frameSize = new Rect(0, 0, twipsWidth, twipsHeight);
        if (length < 0L || frameCount < 0) {
            this.version = version;
            this.rate = frameRate;
            this.frameCount = 0;
            if (this.mByteout == null) {
                this.mByteout = new ByteArrayOutputStream(20000);
                this.mOut = new OutStream(this.mByteout);
            }
            return;
        }
        this.writeHeader(version, length, frameRate, frameCount);
    }

    @Override
    public void tag(int tagType, boolean longTag, byte[] contents) throws IOException {
        int length = contents != null ? contents.length : 0;
        longTag = length > 62 || longTag;
        int hdr = (tagType << 6) + (longTag ? 63 : length);
        this.mOut.writeUI16(hdr);
        if (longTag) {
            this.mOut.writeUI32(length);
        }
        if (contents != null) {
            this.mOut.write(contents);
        }
        if (tagType == 1) {
            ++this.frameCount;
        }
        if (tagType == 0) {
            this.finish();
        }
    }

    protected void writeHeader(int version, long length, int frameRate, int frameCount) throws IOException {
        this.writeSignature();
        this.mOut.writeUI8(version);
        this.mOut.writeUI32(length);
        if (this.mSignature.equals("CWS")) {
            this.mOut.writeCompressed();
        }
        this.frameSize.write(this.mOut);
        this.mOut.writeUI16(frameRate << 8);
        this.mOut.writeUI16(frameCount);
    }

    private void writeSignature() throws IOException {
        if (this.mSignature == null) {
            this.signature("FWS");
        }
        this.mOut.write(this.mSignature.getBytes("US-ASCII"));
    }

    protected void finish() throws IOException {
        if (this.mByteout != null) {
            byte[] bytes = this.mByteout.toByteArray();
            long length = 12L + this.frameSize.getLength() + (long)bytes.length;
            this.mOut = new OutStream(this.mOutputstream);
            this.writeHeader(this.version, length, this.rate, this.frameCount);
            this.mOut.write(bytes);
        }
        this.mOut.close();
    }
}

