/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.structs;

import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.structs.Matrix;
import com.anotherbigidea.flash.structs.Style;
import com.anotherbigidea.io.OutStream;
import java.io.IOException;

public class FillStyle
implements Style {
    protected int fillType;
    protected Color color;
    protected Matrix matrix;
    protected int[] ratios;
    protected Color[] colors;
    protected int bitmapId;

    public int getType() {
        return this.fillType;
    }

    public Color getSolidColor() {
        return this.color;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public int getImageId() {
        return this.bitmapId;
    }

    public int[] getGradientRatios() {
        return this.ratios;
    }

    public Color[] getGradientColors() {
        return this.colors;
    }

    public FillStyle(Color solidColor) {
        this.fillType = 0;
        this.color = solidColor;
    }

    public FillStyle(Matrix matrix, int[] ratios, Color[] colors, boolean radial) {
        this.matrix = matrix;
        this.ratios = ratios;
        this.colors = colors;
        this.fillType = radial ? 18 : 16;
    }

    public FillStyle(int bitmapId, Matrix matrix, boolean clipped) {
        this.matrix = matrix;
        this.bitmapId = bitmapId;
        this.fillType = clipped ? 65 : 64;
    }

    @Override
    public void write(OutStream out, boolean hasAlpha) throws IOException {
        out.writeUI8(this.fillType);
        if (this.fillType == 0) {
            if (hasAlpha) {
                this.color.writeWithAlpha(out);
            } else {
                this.color.writeRGB(out);
            }
        } else if (this.fillType == 16 || this.fillType == 18) {
            this.matrix.write(out);
            int numRatios = this.ratios.length;
            out.writeUI8(numRatios);
            int i = 0;
            while (i < numRatios) {
                if (this.colors[i] != null) {
                    out.writeUI8(this.ratios[i]);
                    if (hasAlpha) {
                        this.colors[i].writeWithAlpha(out);
                    } else {
                        this.colors[i].writeRGB(out);
                    }
                }
                ++i;
            }
        } else if (this.fillType == 64 || this.fillType == 65) {
            out.writeUI16(this.bitmapId);
            this.matrix.write(out);
        }
    }

    public static void writeMorphFillStyle(OutStream out, FillStyle startStyle, FillStyle endStyle) throws IOException {
        int fillType = startStyle.fillType;
        out.writeUI8(fillType);
        if (fillType == 0) {
            startStyle.color.writeWithAlpha(out);
            endStyle.color.writeWithAlpha(out);
        } else if (fillType == 16 || fillType == 18) {
            startStyle.matrix.write(out);
            endStyle.matrix.write(out);
            int numRatios = startStyle.ratios.length;
            out.writeUI8(startStyle.ratios.length);
            int i = 0;
            while (i < numRatios) {
                if (startStyle.colors[i] != null && endStyle.colors[i] != null) {
                    out.writeUI8(startStyle.ratios[i]);
                    startStyle.colors[i].writeWithAlpha(out);
                    out.writeUI8(endStyle.ratios[i]);
                    endStyle.colors[i].writeWithAlpha(out);
                }
                ++i;
            }
        } else if (fillType == 64 || fillType == 65) {
            int bitmapId = startStyle.bitmapId;
            out.writeUI16(bitmapId);
            startStyle.matrix.write(out);
            endStyle.matrix.write(out);
        }
    }
}

