/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.sound;

import com.anotherbigidea.flash.movie.Sound;
import com.anotherbigidea.flash.sound.ADPCMHelper;
import com.anotherbigidea.flash.sound.SoundStreamHead;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.writers.SWFWriter;
import com.anotherbigidea.flash.writers.TagWriter;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class RawHelper {
    public static SoundStreamHead streamingBlocks(InputStream audioFile, int framesPerSecond, ArrayList soundBlocks) throws IOException, UnsupportedAudioFileException {
        int read;
        AudioInputStream audioIn = AudioSystem.getAudioInputStream(audioFile);
        AudioFormat format = audioIn.getFormat();
        int frameSize = format.getFrameSize();
        boolean isStereo = format.getChannels() == 2;
        boolean is16Bit = format.getSampleSizeInBits() > 8;
        int sampleRate = (int)format.getSampleRate();
        int rate = 0;
        if ((sampleRate = sampleRate >= 44000 ? 44000 : (sampleRate >= 22000 ? 22000 : (sampleRate >= 11000 ? 11000 : 5500))) == 44000) {
            rate = 3;
        } else if (sampleRate == 22000) {
            rate = 2;
        } else if (sampleRate == 11000) {
            rate = 1;
        }
        int samplesPerFrame = sampleRate / framesPerSecond;
        int blockSize = samplesPerFrame * (is16Bit ? 2 : 1) * (isStereo ? 2 : 1);
        SoundStreamHead soundHead = new SoundStreamHead(rate, is16Bit, isStereo, 0, rate, is16Bit, isStereo, samplesPerFrame);
        if (soundBlocks == null) {
            return soundHead;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream(blockSize + 1000);
        do {
            bout.reset();
            byte[] b = new byte[frameSize];
            int num = 0;
            read = 0;
            while (num < blockSize) {
                read = 0;
                while ((read = audioIn.read(b, read, frameSize - read)) < frameSize && read != -1) {
                }
                if (read == -1) break;
                bout.write(b);
                num += read;
            }
            while (num < blockSize) {
                bout.write(128);
                ++num;
            }
            soundBlocks.add(bout.toByteArray());
        } while (read != -1);
        return soundHead;
    }

    public static Sound getSoundDefinition(InputStream audioFile, int framesPerSecond) throws IOException, UnsupportedAudioFileException {
        AudioInputStream audioIn = AudioSystem.getAudioInputStream(new BufferedInputStream(audioFile));
        AudioFormat format = audioIn.getFormat();
        int frameSize = format.getFrameSize();
        boolean isStereo = format.getChannels() == 2;
        boolean is16bit = format.getSampleSizeInBits() > 8;
        int sampleRate = (int)format.getSampleRate();
        int rate = 0;
        if ((sampleRate = sampleRate >= 44000 ? 44000 : (sampleRate >= 22000 ? 22000 : (sampleRate >= 11000 ? 11000 : 5500))) == 44000) {
            rate = 3;
        } else if (sampleRate == 22000) {
            rate = 2;
        } else if (sampleRate == 11000) {
            rate = 1;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ADPCMHelper.FramedInputStream in = new ADPCMHelper.FramedInputStream(audioIn, frameSize);
        int b = 0;
        int count = 0;
        while ((b = in.read()) >= 0) {
            ++count;
            bout.write(b);
        }
        int sampleCount = count;
        if (is16bit) {
            sampleCount /= 2;
        }
        if (isStereo) {
            sampleCount /= 2;
        }
        byte[] soundData = bout.toByteArray();
        return new Sound(0, rate, is16bit, isStereo, sampleCount, soundData);
    }

    public static void main(String[] args) throws Exception {
        BufferedInputStream audioFile = new BufferedInputStream(new FileInputStream(args[0]));
        SWFWriter swfwriter = new SWFWriter(args[1]);
        TagWriter tags = new TagWriter(swfwriter);
        tags.header(5, -1L, 200, 200, 12, -1);
        tags.tagSetBackgroundColor(new Color(255, 255, 255));
        ArrayList blocks = new ArrayList();
        SoundStreamHead header = RawHelper.streamingBlocks(audioFile, 12, blocks);
        ((InputStream)audioFile).close();
        header.write(tags);
        for (byte[] data : blocks) {
            tags.tagSoundStreamBlock(data);
            tags.tagShowFrame();
        }
        tags.tagEnd();
    }
}

