/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.movie;

import com.anotherbigidea.flash.interfaces.SWFShape;
import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.interfaces.SWFVectors;
import com.anotherbigidea.flash.movie.Movie;
import com.anotherbigidea.flash.movie.Symbol;
import com.anotherbigidea.flash.movie.Transform;
import com.anotherbigidea.flash.structs.AlphaColor;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.structs.Rect;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class Shape
extends Symbol {
    protected ArrayList elements = new ArrayList();
    protected double minX;
    protected double maxX;
    protected double minY;
    protected double maxY;
    protected boolean hasAlpha = false;
    protected double maxLineWidth;
    protected double currx;
    protected double curry;

    public double[] getBoundingRectangle() {
        return new double[]{this.minX, this.minY, this.maxX, this.maxY};
    }

    public void setBoundingRectangle(double minX, double minY, double maxX, double maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public ArrayList getShapeElements() {
        return this.elements;
    }

    public void defineLineStyle(double width, Color color) {
        if (color == null) {
            color = new Color(0, 0, 0);
        }
        LineStyle style = new LineStyle(width, color);
        if (this.maxLineWidth < width) {
            this.maxLineWidth = width;
        }
        if (color instanceof AlphaColor) {
            this.hasAlpha = true;
        }
        this.elements.add(style);
    }

    public void defineFillStyle(Color color) {
        if (color == null) {
            color = new Color(255, 255, 255);
        }
        ColorFill fill = new ColorFill(color);
        if (color instanceof AlphaColor) {
            this.hasAlpha = true;
        }
        this.elements.add(fill);
    }

    public void defineFillStyle(Symbol image, Transform matrix, boolean clipped) {
        ImageFill fill = new ImageFill(image, matrix, clipped);
        this.elements.add(fill);
    }

    public void defineFillStyle(Color[] colors, int[] ratios, Transform matrix, boolean radial) {
        GradientFill fill = new GradientFill(colors, ratios, matrix, radial);
        this.elements.add(fill);
        int i = 0;
        while (i < colors.length) {
            if (colors[i] != null && colors[i] instanceof AlphaColor) {
                this.hasAlpha = true;
            }
            ++i;
        }
    }

    public void setLeftFillStyle(int index) {
        SetLeftFillStyle fill = new SetLeftFillStyle(index);
        this.elements.add(fill);
    }

    public void setRightFillStyle(int index) {
        SetRightFillStyle fill = new SetRightFillStyle(index);
        this.elements.add(fill);
    }

    public void setLineStyle(int index) {
        SetLineStyle style = new SetLineStyle(index);
        this.elements.add(style);
    }

    public void move(double x, double y) {
        Move move = new Move(x, y);
        if (x < this.minX) {
            this.minX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        this.elements.add(move);
    }

    public void line(double x, double y) {
        Line line = new Line(x, y);
        if (x < this.minX) {
            this.minX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        this.elements.add(line);
    }

    public void curve(double x, double y, double controlX, double controlY) {
        Curve curve = new Curve(x, y, controlX, controlY);
        if (x < this.minX) {
            this.minX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        if (controlX < this.minX) {
            this.minX = controlX;
        }
        if (controlY < this.minY) {
            this.minY = controlY;
        }
        if (controlX > this.maxX) {
            this.maxX = controlX;
        }
        if (controlY > this.maxY) {
            this.maxY = controlY;
        }
        this.elements.add(curve);
    }

    @Override
    protected int defineSymbol(Movie movie, SWFTagTypes timelineWriter, SWFTagTypes definitionWriter) throws IOException {
        this.currx = 0.0;
        this.curry = 0.0;
        this.predefineImageFills(movie, timelineWriter, definitionWriter);
        int id = this.getNextId(movie);
        Rect outline = this.getRect();
        SWFShape shape = this.hasAlpha ? definitionWriter.tagDefineShape3(id, outline) : definitionWriter.tagDefineShape2(id, outline);
        this.writeShape(shape);
        return id;
    }

    protected Rect getRect() {
        double adjust = this.maxLineWidth / 2.0;
        Rect outline = new Rect((int)(this.minX * 20.0 - adjust * 20.0), (int)(this.minY * 20.0 - adjust * 20.0), (int)(this.maxX * 20.0 + adjust * 20.0), (int)(this.maxY * 20.0 + adjust * 20.0));
        return outline;
    }

    protected void predefineImageFills(Movie movie, SWFTagTypes timelineWriter, SWFTagTypes definitionWriter) throws IOException {
        for (Object el : this.elements) {
            Symbol image;
            if (!(el instanceof ImageFill) || (image = ((ImageFill)el).getImage()) == null) continue;
            image.define(movie, timelineWriter, definitionWriter);
        }
    }

    protected void writeShape(SWFShape shape) throws IOException {
        for (Object el : this.elements) {
            Element style;
            FillStyle fill;
            if (el instanceof ColorFill) {
                fill = (ColorFill)el;
                shape.defineFillStyle(((ColorFill)fill).getColor());
                continue;
            }
            if (el instanceof ImageFill) {
                fill = (ImageFill)el;
                Symbol image = ((ImageFill)fill).getImage();
                int imgId = image != null ? image.getId() : 65535;
                shape.defineFillStyle(imgId, ((ImageFill)fill).getTransform(), ((ImageFill)fill).isClipped());
                continue;
            }
            if (el instanceof GradientFill) {
                fill = (GradientFill)el;
                shape.defineFillStyle(((GradientFill)fill).getTransform(), ((GradientFill)fill).getRatios(), ((GradientFill)fill).getColors(), ((GradientFill)fill).isRadial());
                continue;
            }
            if (el instanceof LineStyle) {
                style = (LineStyle)el;
                shape.defineLineStyle((int)(((LineStyle)style).getWidth() * 20.0), ((LineStyle)style).getColor());
                continue;
            }
            if (el instanceof SetLeftFillStyle) {
                style = (SetLeftFillStyle)el;
                shape.setFillStyle0(((SetStyle)style).getStyleIndex());
                continue;
            }
            if (el instanceof SetRightFillStyle) {
                style = (SetRightFillStyle)el;
                shape.setFillStyle1(((SetStyle)style).getStyleIndex());
                continue;
            }
            if (el instanceof SetLineStyle) {
                style = (SetLineStyle)el;
                shape.setLineStyle(((SetStyle)style).getStyleIndex());
                continue;
            }
            this.writeVector(shape, el);
        }
        shape.done();
    }

    protected void writeVector(SWFVectors vecs, Object el) throws IOException {
        if (el instanceof Move) {
            Move move = (Move)el;
            this.currx = move.getX() * 20.0;
            this.curry = move.getY() * 20.0;
            int x = (int)this.currx;
            int y = (int)this.curry;
            vecs.move(x, y);
        } else if (el instanceof Line) {
            Line line = (Line)el;
            double xx = line.getX() * 20.0;
            double yy = line.getY() * 20.0;
            int dx = (int)(xx - this.currx);
            int dy = (int)(yy - this.curry);
            vecs.line(dx, dy);
            this.currx = xx;
            this.curry = yy;
        } else if (el instanceof Curve) {
            Curve curve = (Curve)el;
            double xx = curve.getX() * 20.0;
            double yy = curve.getY() * 20.0;
            double cxx = curve.getControlX() * 20.0;
            double cyy = curve.getControlY() * 20.0;
            int dx = (int)(xx - cxx);
            int dy = (int)(yy - cyy);
            int cx = (int)(cxx - this.currx);
            int cy = (int)(cyy - this.curry);
            vecs.curve(cx, cy, dx, dy);
            this.currx = xx;
            this.curry = yy;
        }
    }

    protected void writeGlyph(SWFVectors vecs) throws IOException {
        this.currx = 0.0;
        this.curry = 0.0;
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            this.writeVector(vecs, it.next());
        }
        vecs.done();
    }

    public static class ColorFill
    extends FillStyle {
        protected Color color;

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public ColorFill(Color color) {
            this.color = color;
        }
    }

    public static class Curve
    extends Vector {
        protected double cx;
        protected double cy;

        public double getControlX() {
            return this.cx;
        }

        public double getControlY() {
            return this.cy;
        }

        public void setControlX(double cx) {
            this.cx = cx;
        }

        public void setControlY(double cy) {
            this.cy = cy;
        }

        public Curve(double x, double y, double controlX, double controlY) {
            super(x, y);
            this.cx = controlX;
            this.cy = controlY;
        }
    }

    public static abstract class Element {
    }

    public static abstract class FillStyle
    extends Style {
    }

    public static class GradientFill
    extends FillStyle {
        protected Color[] colors;
        protected int[] ratios;
        protected Transform matrix;
        protected boolean radial;

        public Color[] getColors() {
            return this.colors;
        }

        public Transform getTransform() {
            return this.matrix;
        }

        public int[] getRatios() {
            return this.ratios;
        }

        public boolean isRadial() {
            return this.radial;
        }

        public void setColors(Color[] colors) {
            this.colors = colors;
        }

        public void setRatios(int[] ratios) {
            this.ratios = ratios;
        }

        public void setTransform(Transform matrix) {
            this.matrix = matrix;
        }

        public void setRadial(boolean isRadial) {
            this.radial = isRadial;
        }

        public GradientFill(Color[] colors, int[] ratios, Transform matrix, boolean isRadial) {
            this.colors = colors;
            this.matrix = matrix;
            this.radial = isRadial;
            this.ratios = ratios;
        }
    }

    public static class ImageFill
    extends FillStyle {
        protected Symbol image;
        protected Transform matrix;
        protected boolean clipped;

        public Symbol getImage() {
            return this.image;
        }

        public Transform getTransform() {
            return this.matrix;
        }

        public boolean isClipped() {
            return this.clipped;
        }

        public void setImage(Symbol image) {
            this.image = image;
        }

        public void setTransform(Transform matrix) {
            this.matrix = matrix;
        }

        public void setClipped(boolean isClipped) {
            this.clipped = isClipped;
        }

        public ImageFill(Symbol image, Transform matrix, boolean isClipped) {
            this.image = image;
            this.matrix = matrix;
            this.clipped = isClipped;
        }
    }

    public static class Line
    extends Vector {
        public Line(double x, double y) {
            super(x, y);
        }
    }

    public static class LineStyle
    extends Style {
        protected double width;
        protected Color color;

        public double getWidth() {
            return this.width;
        }

        public Color getColor() {
            return this.color;
        }

        public void setWidth(double width) {
            this.width = width;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public LineStyle(double width, Color color) {
            this.width = width;
            this.color = color;
        }
    }

    public static class Move
    extends Vector {
        public Move(double x, double y) {
            super(x, y);
        }
    }

    public static abstract class SetFillStyle
    extends SetStyle {
        protected SetFillStyle(int index) {
            super(index);
        }
    }

    public static class SetLeftFillStyle
    extends SetFillStyle {
        public SetLeftFillStyle(int index) {
            super(index);
        }
    }

    public static class SetLineStyle
    extends SetStyle {
        public SetLineStyle(int index) {
            super(index);
        }
    }

    public static class SetRightFillStyle
    extends SetFillStyle {
        public SetRightFillStyle(int index) {
            super(index);
        }
    }

    public static abstract class SetStyle
    extends Element {
        protected int index;

        public int getStyleIndex() {
            return this.index;
        }

        public void setStyleIndex(int index) {
            this.index = index;
        }

        protected SetStyle(int index) {
            this.index = index;
        }
    }

    public static abstract class Style
    extends Element {
    }

    public static abstract class Vector
    extends Element {
        protected double x;
        protected double y;

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setX(double x) {
            this.x = x;
        }

        public void setY(double y) {
            this.y = y;
        }

        protected Vector(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

