/*
 * Decompiled with CFR 0.152.
 */
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class YahooRestXML {
    private static final String APPID = "";
    private Logger logger;
    private String query = null;
    private int count = 0;
    ArrayList words = null;
    String filename = null;

    public YahooRestXML(String p, int c, String fn, Logger l) {
        this.logger = l;
        this.query = p.trim();
        this.count = c;
        this.filename = fn;
    }

    public boolean exec() {
        if (this.words == null || this.query == null || this.filename == null) {
            return false;
        }
        boolean ret = false;
        this.split();
        if (this.count > this.words.size() - 1) {
            this.count = this.words.size() - 1;
        }
        int i = this.count;
        while (i >= 0) {
            try {
                String reqstr = null;
                if (i == 0) {
                    reqstr = this.query;
                } else {
                    StringBuilder sb = new StringBuilder();
                    int j = 0;
                    while (j < i) {
                        sb.append(this.words.get(j));
                        sb.append(" ");
                        ++j;
                    }
                    reqstr = sb.toString();
                }
                this.logger.info("reqstr(\u30a8\u30f3\u30b3\u30fc\u30c9\u524d)=" + reqstr);
                reqstr = this.getImageRestRequest(reqstr);
                URL url = new URL(reqstr);
                HttpURLConnection urlconn = (HttpURLConnection)url.openConnection();
                urlconn.setRequestMethod("GET");
                urlconn.connect();
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document retdoc = builder.parse(urlconn.getInputStream());
                this.logger.info(retdoc.toString());
                urlconn.disconnect();
                NodeList nodes = retdoc.getElementsByTagName("ClickUrl");
                if (nodes.getLength() > 0) {
                    Node node = nodes.item(0);
                    this.filename = node.getTextContent();
                    this.logger.info("filename=" + this.filename);
                    ret = true;
                    break;
                }
            }
            catch (Exception e) {
                this.logger.warning(e.toString());
            }
            --i;
        }
        return ret;
    }

    private void split() {
        String regex = "\u3042|\u3044|\u3046|\u3048|\u304a|\u304b|\u304d|\u304f|\u3051|\u3053|\u3055|\u3057|\u3059|\u305b|\u305d|\u305f|\u3061|\u3064|\u3066|\u3068|\u306a|\u306b|\u306c|\u306d|\u306e|\u306f|\u3072|\u3075|\u3078|\u307b|\u307e|\u307f|\u3080|\u3081|\u3082|\u3084|\u3086|\u3088|\u308f|\u3092|\u3093";
        this.logger.info(this.query);
        String[] s = this.query.split(regex, 0);
        if (s == null) {
            return;
        }
        this.words = new ArrayList();
        int i = 0;
        while (i < s.length) {
            if (s[i] != null && s[i].trim().length() > 1) {
                this.words.add(s[i].trim());
                this.logger.info(String.valueOf(i) + "=" + s[i]);
            }
            ++i;
        }
    }

    private String getImageRestRequest(String str) throws Exception {
        StringBuilder stb = new StringBuilder("http://api.search.yahoo.co.jp/ImageSearchService/V1/imageSearch?appid=");
        stb.append(APPID).append("&query=");
        String enc = URLEncoder.encode(str);
        stb.append(enc);
        return stb.toString();
    }
}

