/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JToolBar;

public class DialogImageEdit
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    int x1 = 0;
    int y1 = 0;
    int x2 = 0;
    int y2 = 0;
    BufferedImage image = null;
    Graphics imageGraphics;
    static final Color bc = Color.white;
    static final Color dc = Color.black;
    Color cc = dc;
    JToolBar toolBar;
    MyPanel pic;
    private boolean ok_flg = false;
    private boolean load_flg = false;
    private int iconmode = 0;

    DialogImageEdit(JFrame p_f, String filename, int p_iconmode) {
        super(p_f, filename, true);
        this.setBackground(bc);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.toolBar = new JToolBar("\u30a4\u30e1\u30fc\u30b8\u7de8\u96c6");
        this.toolBar.setRollover(true);
        this.toolBar.add(Create.createButton("OK", "ok", this));
        this.toolBar.add(Create.createButton("\u30ad\u30e3\u30f3\u30bb\u30eb", "cansel", this));
        this.toolBar.add(Create.createButton("\u30da\u30fc\u30b9\u30c8", "paste", this));
        this.toolBar.add(Create.createButton("\u30af\u30ea\u30a2", "clear", this));
        contentPane.add((Component)this.toolBar, "North");
        this.pic = new MyPanel();
        contentPane.add((Component)this.pic, "Center");
        this.iconmode = p_iconmode;
    }

    void setupPane(BufferedImage bf) {
        if (bf != null) {
            this.image = bf;
            int w = this.image.getWidth();
            int h = this.image.getHeight();
            this.imageGraphics = this.image.createGraphics();
            this.setSize(w, h += this.toolBar.getPreferredSize().height * 2);
        } else {
            int w = 640;
            int h = this.iconmode == 1 ? 360 : 480;
            this.image = new BufferedImage(w, h, 5);
            this.imageGraphics = this.image.createGraphics();
            this.imageGraphics.setColor(bc);
            this.imageGraphics.fillRect(0, 0, w, h);
            this.setSize(w, h += this.toolBar.getPreferredSize().height * 2);
        }
        this.load_flg = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ok")) {
            this.ok_flg = true;
            this.dispose();
        } else if (e.getActionCommand().equals("cansel")) {
            this.ok_flg = false;
            this.dispose();
        } else if (e.getActionCommand().equals("paste")) {
            try {
                Image tmpimg = SystemClip.getImage();
                if (tmpimg != null) {
                    this.image = (BufferedImage)tmpimg;
                    if (this.imageGraphics != null) {
                        this.imageGraphics.dispose();
                    }
                    this.imageGraphics = this.image.createGraphics();
                    this.pic.repaint();
                }
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        } else if (e.getActionCommand().equals("clear")) {
            int w = this.image.getWidth();
            int h = this.image.getHeight();
            this.imageGraphics.setColor(bc);
            this.imageGraphics.fillRect(0, 0, w, h);
            this.pic.repaint();
        }
    }

    public boolean getOkFlg() {
        return this.ok_flg;
    }

    public BufferedImage getImage() {
        if (this.imageGraphics != null) {
            this.imageGraphics.dispose();
            this.imageGraphics = null;
        }
        return this.image;
    }

    class MyPanel
    extends JLabel
    implements MouseMotionListener,
    MouseListener {
        private static final long serialVersionUID = 1L;

        public MyPanel() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if ((e.getModifiers() & 0x10) != 0) {
                DialogImageEdit.this.cc = dc;
            }
            e.getModifiers();
            if ((e.getModifiers() & 4) != 0) {
                DialogImageEdit.this.cc = bc;
            }
            DialogImageEdit.this.x2 = DialogImageEdit.this.x1 = e.getX();
            DialogImageEdit.this.y2 = DialogImageEdit.this.y1 = e.getY();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            DialogImageEdit.this.x1 = DialogImageEdit.this.x2;
            DialogImageEdit.this.y1 = DialogImageEdit.this.y2;
            DialogImageEdit.this.x2 = e.getX();
            DialogImageEdit.this.y2 = e.getY();
            this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void paint(Graphics g) {
            if (DialogImageEdit.this.image == null) {
                Dimension d = this.getSize();
                int w = d.width;
                int h = d.height;
                DialogImageEdit.this.image = (BufferedImage)this.createImage(w, h);
                DialogImageEdit.this.imageGraphics = DialogImageEdit.this.image.createGraphics();
                DialogImageEdit.this.imageGraphics.setColor(bc);
                DialogImageEdit.this.imageGraphics.fillRect(0, 0, w, h);
            }
            if (DialogImageEdit.this.load_flg) {
                g.drawImage(DialogImageEdit.this.image, 0, 0, this);
                DialogImageEdit.this.load_flg = false;
                return;
            }
            if (DialogImageEdit.this.x1 != DialogImageEdit.this.x2 || DialogImageEdit.this.y1 != DialogImageEdit.this.y2) {
                DialogImageEdit.this.imageGraphics.setColor(DialogImageEdit.this.cc);
                if (DialogImageEdit.this.cc == bc) {
                    DialogImageEdit.this.imageGraphics.drawLine(DialogImageEdit.this.x1, DialogImageEdit.this.y1, DialogImageEdit.this.x2, DialogImageEdit.this.y2);
                    DialogImageEdit.this.imageGraphics.drawLine(DialogImageEdit.this.x1 - 1, DialogImageEdit.this.y1, DialogImageEdit.this.x2 - 1, DialogImageEdit.this.y2);
                    DialogImageEdit.this.imageGraphics.drawLine(DialogImageEdit.this.x1 + 1, DialogImageEdit.this.y1, DialogImageEdit.this.x2 + 1, DialogImageEdit.this.y2);
                    DialogImageEdit.this.imageGraphics.drawLine(DialogImageEdit.this.x1, DialogImageEdit.this.y1 - 1, DialogImageEdit.this.x2, DialogImageEdit.this.y2 - 1);
                    DialogImageEdit.this.imageGraphics.drawLine(DialogImageEdit.this.x1, DialogImageEdit.this.y1 + 1, DialogImageEdit.this.x2, DialogImageEdit.this.y2 + 1);
                } else {
                    DialogImageEdit.this.imageGraphics.drawLine(DialogImageEdit.this.x1, DialogImageEdit.this.y1, DialogImageEdit.this.x2, DialogImageEdit.this.y2);
                }
                g.drawImage(DialogImageEdit.this.image, 0, 0, this);
            }
        }
    }
}

