/*
 * Decompiled with CFR 0.152.
 */
package com.sun.medialib.codec.jpeg;

import com.sun.medialib.mlib.Constants;
import com.sun.medialib.mlib.mediaLibImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class PPM
implements Constants {
    public static void write(OutputStream outputStream, mediaLibImage mediaLibImage2) throws IOException {
        block11: {
            int n;
            int n2;
            int n3;
            int n4;
            block9: {
                byte[] byArray;
                block10: {
                    n4 = mediaLibImage2.getWidth();
                    n3 = mediaLibImage2.getHeight();
                    n2 = mediaLibImage2.getStride();
                    n = mediaLibImage2.getOffset();
                    if (mediaLibImage2.getType() != 1) break block9;
                    byArray = mediaLibImage2.getByteData();
                    if (mediaLibImage2.getChannels() != 1) break block10;
                    PPM.writeString(outputStream, 5, n4, n3, 255);
                    int n5 = 0;
                    while (n5 < n3) {
                        outputStream.write(byArray, n, n4);
                        ++n5;
                        n += n2;
                    }
                    break block11;
                }
                if (mediaLibImage2.getChannels() != 3) break block11;
                PPM.writeString(outputStream, 6, n4, n3, 255);
                int n6 = 0;
                while (n6 < n3) {
                    outputStream.write(byArray, n, 3 * n4);
                    ++n6;
                    n += n2;
                }
                break block11;
            }
            short[] sArray = mediaLibImage2.getShortData();
            if (mediaLibImage2.getChannels() == 1) {
                PPM.writeString(outputStream, 5, n4, n3, 4095);
                int n7 = 0;
                while (n7 < n3) {
                    int n8 = 0;
                    while (n8 < n4) {
                        PPM.writeShort(outputStream, sArray[n8 + n]);
                        ++n8;
                    }
                    ++n7;
                    n += n2;
                }
            } else if (mediaLibImage2.getChannels() == 3) {
                PPM.writeString(outputStream, 6, n4, n3, 4095);
                int n9 = 0;
                while (n9 < n3) {
                    int n10 = 0;
                    while (n10 < 3 * n4) {
                        PPM.writeShort(outputStream, sArray[n10 + n]);
                        ++n10;
                    }
                    ++n9;
                    n += n2;
                }
            }
        }
    }

    public static mediaLibImage read4JPEG(InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[4];
        PPM.getPPMHeader(inputStream, nArray);
        n = nArray[0];
        n2 = nArray[1];
        n3 = nArray[2];
        n4 = nArray[3];
        if (n4 == 255) {
            if (n == 5) {
                int n6 = n2 + 7 & 0xFFFFFFF8;
                int n7 = n3 + 7 & 0xFFFFFFF8;
                byte[] byArray = new byte[n6 * n7];
                mediaLibImage mediaLibImage2 = new mediaLibImage(1, 1, n2, n3, n6, 0, (Object)byArray);
                int n8 = 0;
                while (n8 < n3) {
                    inputStream.read(byArray, n5, n2);
                    ++n8;
                    n5 += n6;
                }
                return mediaLibImage2;
            }
            if (n == 6) {
                int n9;
                int n10 = 3 * (n2 + 15 & 0xFFFFFFF0);
                int n11 = 1 + (n3 + 15 & 0xFFFFFFF0);
                byte[] byArray = new byte[n10 * n11];
                mediaLibImage mediaLibImage3 = new mediaLibImage(1, 3, n2, n3, n10, 0, (Object)byArray);
                int n12 = 0;
                while (n12 < n3) {
                    inputStream.read(byArray, n5, 3 * n2);
                    n9 = 3 * n2;
                    while (n9 < n10) {
                        byArray[n5 + n9] = byArray[n5 + 3 * n2 - 3];
                        byArray[n5 + n9 + 1] = byArray[n5 + 3 * n2 - 2];
                        byArray[n5 + n9 + 2] = byArray[n5 + 3 * n2 - 1];
                        n9 += 3;
                    }
                    ++n12;
                    n5 += n10;
                }
                int n13 = n5 - n10;
                while (n12 < n11) {
                    n9 = 0;
                    while (n9 < n10) {
                        byArray[n5 + n9] = byArray[n13 + n9];
                        ++n9;
                    }
                    ++n12;
                    n5 += n10;
                }
                return mediaLibImage3;
            }
            return null;
        }
        if (n == 5) {
            int n14 = n2 + 7 & 0xFFFFFFF8;
            int n15 = n3 + 7 & 0xFFFFFFF8;
            short[] sArray = new short[n14 * n15];
            mediaLibImage mediaLibImage4 = new mediaLibImage(2, 1, n2, n3, n14, 0, (Object)sArray);
            int n16 = 0;
            while (n16 < n3) {
                int n17 = 0;
                while (n17 < n2) {
                    sArray[n5 + n17] = PPM.getShort(inputStream);
                    ++n17;
                }
                ++n16;
                n5 += n14;
            }
            return mediaLibImage4;
        }
        if (n == 6) {
            int n18;
            int n19 = 3 * (n2 + 15 & 0xFFFFFFF0);
            int n20 = 1 + (n3 + 15 & 0xFFFFFFF0);
            short[] sArray = new short[n19 * n20];
            mediaLibImage mediaLibImage5 = new mediaLibImage(2, 3, n2, n3, n19, 0, (Object)sArray);
            int n21 = 0;
            while (n21 < n3) {
                n18 = 0;
                while (n18 < 3 * n2) {
                    sArray[n5 + n18] = PPM.getShort(inputStream);
                    ++n18;
                }
                n18 = 3 * n2;
                while (n18 < n19) {
                    sArray[n5 + n18] = sArray[n5 + 3 * n2 - 3];
                    sArray[n5 + n18 + 1] = sArray[n5 + 3 * n2 - 2];
                    sArray[n5 + n18 + 2] = sArray[n5 + 3 * n2 - 1];
                    n18 += 3;
                }
                ++n21;
                n5 += n19;
            }
            int n22 = n5 - n19;
            while (n21 < n20) {
                n18 = 0;
                while (n18 < n19) {
                    sArray[n5 + n18] = sArray[n22 + n18];
                    ++n18;
                }
                ++n21;
                n5 += n19;
            }
            return mediaLibImage5;
        }
        return null;
    }

    private static void writeNumber(OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[255];
        int n2 = 0;
        while (n > 9 && n2 < 254) {
            byArray[n2] = (byte)(48 + n % 10);
            n /= 10;
            ++n2;
        }
        byArray[n2] = (byte)(48 + n % 10);
        while (n2 >= 0) {
            outputStream.write(byArray[n2]);
            --n2;
        }
    }

    private static void writeString(OutputStream outputStream, int n, int n2, int n3, int n4) throws IOException {
        outputStream.write(80);
        outputStream.write(48 + n);
        outputStream.write(10);
        PPM.writeNumber(outputStream, n2);
        outputStream.write(32);
        PPM.writeNumber(outputStream, n3);
        outputStream.write(10);
        PPM.writeNumber(outputStream, n4);
        outputStream.write(10);
    }

    private static void writeShort(OutputStream outputStream, short s) throws IOException {
        short s2 = s;
        int n = s >> 8;
        outputStream.write(s2);
        outputStream.write(n);
    }

    private static int getC(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == 35) {
            while ((n = inputStream.read()) != 10 && n != -1) {
            }
        }
        return n;
    }

    private static short getShort(InputStream inputStream) throws IOException {
        short s = 0;
        int n = inputStream.read() & 0xFF;
        int n2 = inputStream.read();
        s = (short)(n2 << 8 | n);
        return s;
    }

    private static int getInt(InputStream inputStream) throws IOException {
        int n;
        int n2 = 0;
        while ((n = PPM.getC(inputStream)) == 32 || n == 9 || n == 10 || n == 13) {
        }
        if (n < 48 || n > 57) {
            return n2;
        }
        n2 = n - 48;
        while ((n = PPM.getC(inputStream)) >= 48 && n <= 57) {
            n2 *= 10;
            n2 += n - 48;
        }
        return n2;
    }

    private static void getPPMHeader(InputStream inputStream, int[] nArray) throws IOException {
        int n = PPM.getC(inputStream);
        if (n != 80) {
            return;
        }
        nArray[0] = PPM.getInt(inputStream);
        nArray[1] = PPM.getInt(inputStream);
        nArray[2] = PPM.getInt(inputStream);
        nArray[3] = PPM.getInt(inputStream);
        if ((nArray[1] | nArray[2] | nArray[3]) == 0) {
            nArray[0] = 0;
        }
    }
}

