/*
 * Decompiled with CFR 0.152.
 */
package v1;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import v1.Error;
import v1.Main;
import v1.NoValueNameException;
import v1.RelationOverDoublePair;

public class Parameter
implements Comparable<Parameter> {
    String name;
    List<String> value_name = new LinkedList<String>();
    int id1;
    int id2;

    Parameter(String name) {
        this.name = name;
    }

    void addName(String name) {
        this.value_name.add(name);
    }

    void check() {
        if (this.value_name.size() <= 0 || this.value_name.size() > 63) {
            Error.printError(Main.language == Main.Language.JP ? "\u6c34\u6e96\u6570\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059" : "Invalid number of values");
        }
    }

    List<Integer> getID(String str) throws NoValueNameException {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        int i = 0;
        while (i < this.value_name.size()) {
            if (this.value_name.get(i).equals(str)) {
                ids.add(i);
            }
            ++i;
        }
        if (ids.size() == 0) {
            throw new NoValueNameException();
        }
        return ids;
    }

    List<Integer> getID(double number) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        int i = 0;
        while (i < this.value_name.size()) {
            try {
                double level = Double.parseDouble(this.value_name.get(i));
                if (level == number) {
                    ids.add(i);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
        return ids;
    }

    List<Integer> getID(double number, RelationOverDoublePair com) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        int i = 0;
        while (i < this.value_name.size()) {
            try {
                double level = Double.parseDouble(this.value_name.get(i));
                if (com.hasRelation(level, number)) {
                    ids.add(i);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
        return ids;
    }

    @Override
    public int compareTo(Parameter other) {
        return Integer.compare(this.value_name.size(), other.value_name.size());
    }
}

