/*
 * Decompiled with CFR 0.152.
 */
package v1;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import v1.InputFileData;
import v1.Main;
import v1.Parameter;
import v1.Testcase;

public class Outputer {
    BufferedWriter writer;

    Outputer(String filename) {
        this.writer = this.openFile(filename);
    }

    private BufferedWriter openFile(String filename) {
        BufferedWriter writer = null;
        if (filename == null) {
            return new BufferedWriter(new OutputStreamWriter(System.out));
        }
        try {
            writer = new BufferedWriter(new FileWriter(filename));
        }
        catch (IOException e) {
            System.err.print(Main.language == Main.Language.JP ? "\u51fa\u529b\u30d5\u30a1\u30a4\u30eb" + filename + "\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\uff0e" : "Cannot create output file " + filename);
            System.exit(1);
        }
        return writer;
    }

    void outputResult(List<Testcase> testSet, InputFileData inputfiledata, int randomSeed, String modelFile, String seedFile, String outputFile, int strength, int numOfIterations) {
        inputfiledata.parameterList.assignID2();
        Collections.sort(inputfiledata.parameterList, new Comparator<Parameter>(){

            @Override
            public int compare(Parameter arg0, Parameter arg1) {
                return arg0.id1 - arg1.id1;
            }
        });
        try {
            String firstline = "#SUCCESS," + randomSeed + "," + "i" + "," + (modelFile == null ? "" : modelFile) + "," + "s" + "," + (seedFile == null ? "" : seedFile) + "," + "o" + "," + (outputFile == null ? "" : outputFile) + "," + "c" + "," + (strength < 0 ? "all" : Integer.valueOf(strength)) + "," + "random" + "," + randomSeed + "," + "repeat" + "," + numOfIterations + "\n";
            this.writer.write(firstline);
            int i = 0;
            while (i < inputfiledata.parameterList.size()) {
                if (i > 0) {
                    this.writer.write(",");
                }
                this.writer.write(((Parameter)inputfiledata.parameterList.get((int)i)).name);
                ++i;
            }
            this.writer.write("\n");
            for (Testcase test : testSet) {
                test.print(this.writer, inputfiledata.parameterList);
            }
            this.writer.close();
        }
        catch (IOException e) {
            System.err.print("Cannot write the file");
        }
    }

    public void outputResult(List<Testcase> testSet, InputFileData inputfiledata, String modelFile, String outputFile) {
        try {
            String firstline = "#SUCCESS,0,i," + (modelFile == null ? "" : modelFile) + "," + "s" + "," + "," + "o" + "," + (outputFile == null ? "" : outputFile) + "," + "c" + "," + "all" + "," + "random" + "," + 0 + "," + "repeat" + "," + 1 + "\n";
            this.writer.write(firstline);
            int i = 0;
            while (i < inputfiledata.parameterList.size()) {
                if (i > 0) {
                    this.writer.write(",");
                }
                this.writer.write(((Parameter)inputfiledata.parameterList.get((int)i)).name);
                ++i;
            }
            this.writer.write("\n");
            for (Testcase test : testSet) {
                test.print(this.writer, inputfiledata);
            }
            this.writer.close();
        }
        catch (IOException e) {
            System.err.print("Cannot write the file");
        }
    }
}

