/*
 * Decompiled with CFR 0.152.
 */
package v1;

import java.util.ArrayList;
import java.util.List;
import v1.CombinationGenerator;
import v1.ConstraintHandler;
import v1.Error;
import v1.GList;
import v1.Generator;
import v1.Main;
import v1.OutOfMaxNumOfTestcasesException;
import v1.ParameterModel;
import v1.Testcase;

public class IPOG
extends Generator {
    protected byte[][] matrix;
    protected int strength;
    protected boolean[][] bitmap;
    protected int numOfRows;

    IPOG(ParameterModel parametermodel, GList groupList, ConstraintHandler constrainthandler, List<Testcase> seed, long randomseed, int strength) {
        super(parametermodel, groupList, constrainthandler, seed, randomseed);
        this.strength = strength;
        this.matrix = new byte[65532][parametermodel.size];
        int i = 0;
        while (i < 65532) {
            int j = 0;
            while (j < parametermodel.size) {
                this.matrix[i][j] = -1;
                ++j;
            }
            ++i;
        }
    }

    @Override
    List<Testcase> generate() throws OutOfMaxNumOfTestcasesException {
        this.buildFirstColumns();
        ArrayList<Testcase> res = new ArrayList<Testcase>();
        int factorID = this.strength;
        while (factorID < this.parametermodel.size) {
            this.initializeBitmap(factorID);
            this.horizontalExtention(factorID);
            this.verticalExtention(factorID);
            ++factorID;
        }
        if (Main.randstar == Main.Randstar.OFF) {
            this.fillInStars();
        }
        int i = 0;
        while (i < this.numOfRows) {
            Testcase test = new Testcase(this.parametermodel.size);
            int j = 0;
            while (j < this.parametermodel.size) {
                test.set(j, this.matrix[i][j]);
                ++j;
            }
            res.add(test);
            if (res.size() > 65532) {
                throw new OutOfMaxNumOfTestcasesException();
            }
            ++i;
        }
        return res;
    }

    private void fillInStars() {
        Testcase onerow = new Testcase(this.parametermodel.size);
        int row = 0;
        while (row < this.numOfRows) {
            onerow.quantify();
            int column = 0;
            while (column < this.parametermodel.size) {
                onerow.set(column, this.matrix[row][column]);
                ++column;
            }
            column = 0;
            while (column < this.parametermodel.size) {
                if (this.matrix[row][column] < 0) {
                    byte range = this.parametermodel.range[column];
                    byte basevalue = (byte)this.rnd.nextInt(range);
                    byte i = 0;
                    while (i < range) {
                        byte value = (byte)((basevalue + i) % range);
                        onerow.set(column, value);
                        if (this.constrainthandler.isPossible(onerow)) {
                            this.matrix[row][column] = value;
                            break;
                        }
                        onerow.set(column, (byte)-1);
                        i = (byte)(i + 1);
                    }
                    if (this.matrix[row][column] < 0) {
                        System.err.println("error");
                    }
                }
                ++column;
            }
            ++row;
        }
    }

    private void initializeBitmap(int factorID) {
        this.bitmap = new boolean[CombinationGenerator.getTotalNumber(factorID, this.strength - 1)][];
        CombinationGenerator cg = new CombinationGenerator(factorID, this.strength - 1);
        do {
            int numOfTuples = this.parametermodel.range[factorID];
            int i = 0;
            while (i < this.strength - 1) {
                numOfTuples *= this.parametermodel.range[cg.c[i]];
                ++i;
            }
            this.bitmap[cg.getID()] = new boolean[numOfTuples];
        } while (cg.visitNext());
    }

    private void verticalExtention(int factor) {
        CombinationGenerator cg = new CombinationGenerator(factor, this.strength - 1);
        do {
            int[] bases = new int[this.strength - 1];
            bases = this.getBases(cg.c, this.strength - 1, factor);
            int i = 0;
            while (i < this.bitmap[cg.getID()].length) {
                if (!this.bitmap[cg.getID()][i]) {
                    int[] tuple = this.getTupleFromID(i, bases);
                    Testcase tmp = new Testcase(this.parametermodel.size);
                    tmp.quantify();
                    int j = 0;
                    while (j < this.strength - 1) {
                        tmp.set(cg.c[j], (byte)tuple[j]);
                        ++j;
                    }
                    tmp.set(factor, (byte)tuple[this.strength - 1]);
                    boolean isValid = this.constrainthandler.isPossible(tmp);
                    if (isValid) {
                        this.addTuple(tuple, cg, factor);
                    }
                    this.bitmap[cg.getID()][i] = true;
                }
                ++i;
            }
        } while (cg.visitNext());
    }

    private void addTuple(int[] tuple, CombinationGenerator cg, int factor) {
        int row = 0;
        while (row <= 65532) {
            block14: {
                if (row >= 65532) {
                    Error.printError(Main.language == Main.Language.JP ? "\u4e0a\u965065532\u3092\u8d85\u3048\u308b\u30c6\u30b9\u30c8\u30b1\u30fc\u30b9\u304c\u5fc5\u8981\u3067\u3059" : "The number of test cases exceeds the upper bound 65532");
                }
                if (this.matrix[row][factor] < 0 || (byte)tuple[this.strength - 1] == this.matrix[row][factor]) {
                    int i = tuple.length - 2;
                    while (i >= 0) {
                        if (this.matrix[row][cg.c[i]] < 0 || (byte)tuple[i] == this.matrix[row][cg.c[i]]) {
                            --i;
                            continue;
                        }
                        break block14;
                    }
                    Testcase tmp = new Testcase(this.parametermodel.size);
                    tmp.quantify();
                    int j = 0;
                    while (j < this.strength - 1) {
                        tmp.set(cg.c[j], (byte)tuple[j]);
                        ++j;
                    }
                    tmp.set(factor, (byte)tuple[this.strength - 1]);
                    j = 0;
                    while (j < factor) {
                        if (tmp.get(j) < 0) {
                            tmp.set(j, this.matrix[row][j]);
                        }
                        ++j;
                    }
                    if (this.constrainthandler.isPossible(tmp)) {
                        this.matrix[row][factor] = (byte)tuple[this.strength - 1];
                        assert (tuple[this.strength - 1] < this.parametermodel.range[factor]);
                        int i2 = tuple.length - 2;
                        while (i2 >= 0) {
                            this.matrix[row][cg.c[i2]] = (byte)tuple[i2];
                            assert (tuple[i2] < this.parametermodel.range[cg.c[i2]]);
                            --i2;
                        }
                        if (row >= this.numOfRows) {
                            assert (row == this.numOfRows);
                            this.numOfRows = row + 1;
                        }
                        return;
                    }
                }
            }
            ++row;
        }
        Error.printError("Exceeds the limit");
    }

    private void horizontalExtention(int factor) {
        int[] occurrence = new int[this.parametermodel.range[factor]];
        int row = 0;
        while (row < this.numOfRows) {
            byte v;
            boolean[] validity = new boolean[this.parametermodel.range[factor]];
            Testcase tmptest = new Testcase(this.parametermodel.size);
            tmptest.quantify();
            int column = 0;
            while (column < factor) {
                tmptest.set(column, this.matrix[row][column]);
                ++column;
            }
            byte v2 = 0;
            while (v2 < this.parametermodel.range[factor]) {
                tmptest.set(factor, v2);
                validity[v2] = this.constrainthandler.isPossible(tmptest);
                v2 = (byte)(v2 + 1);
            }
            int[] count = new int[this.parametermodel.range[factor]];
            CombinationGenerator cg = new CombinationGenerator(factor, this.strength - 1);
            boolean isNotLastComb = true;
            while (isNotLastComb) {
                int id = 0;
                int multiplier = this.parametermodel.range[factor];
                boolean isDontcareContained = false;
                int i = this.strength - 2;
                while (i >= 0) {
                    if (this.matrix[row][cg.c[i]] < 0) {
                        isDontcareContained = true;
                        break;
                    }
                    id += this.matrix[row][cg.c[i]] * multiplier;
                    multiplier *= this.parametermodel.range[cg.c[i]];
                    --i;
                }
                if (isDontcareContained) {
                    isNotLastComb = cg.visitNext();
                    continue;
                }
                v = 0;
                while (v < this.parametermodel.range[factor]) {
                    if (!validity[v]) {
                        count[v] = -1;
                    } else if (!this.bitmap[cg.getID()][id + v]) {
                        byte by = v;
                        count[by] = count[by] + 1;
                    }
                    v = (byte)(v + 1);
                }
                isNotLastComb = cg.visitNext();
            }
            byte maxv = -1;
            int max = -1;
            int min_occurrence = 0;
            v = 0;
            int i = 0;
            while (i < this.parametermodel.range[factor]) {
                if (count[v] > max && validity[v] || count[v] == max && validity[v] && occurrence[v] < min_occurrence) {
                    max = count[v];
                    maxv = v;
                    min_occurrence = occurrence[v];
                }
                ++v;
                ++i;
            }
            if (max > 0) {
                this.matrix[row][factor] = maxv;
                assert (maxv < this.parametermodel.range[factor]);
                byte by = maxv;
                occurrence[by] = occurrence[by] + 1;
                cg.initialize();
                cg = new CombinationGenerator(factor, this.strength - 1);
                isNotLastComb = true;
                while (isNotLastComb) {
                    int id = 0;
                    int multiplier = this.parametermodel.range[factor];
                    boolean isDontcareContained = false;
                    int i2 = this.strength - 2;
                    while (i2 >= 0) {
                        if (this.matrix[row][cg.c[i2]] < 0) {
                            isDontcareContained = true;
                            break;
                        }
                        id += this.matrix[row][cg.c[i2]] * multiplier;
                        multiplier *= this.parametermodel.range[cg.c[i2]];
                        --i2;
                    }
                    if (isDontcareContained) {
                        isNotLastComb = cg.visitNext();
                        continue;
                    }
                    this.bitmap[cg.getID()][id += this.matrix[row][factor]] = true;
                    isNotLastComb = cg.visitNext();
                }
            }
            ++row;
        }
    }

    protected void buildFirstColumns() throws OutOfMaxNumOfTestcasesException {
        int numOfCombinations = 1;
        int row = 0;
        int i = 0;
        while (i < this.strength) {
            numOfCombinations *= this.parametermodel.range[i];
            ++i;
        }
        Testcase tmptest = new Testcase(this.parametermodel.size);
        tmptest.quantify();
        int i2 = 0;
        while (i2 < this.strength) {
            tmptest.set(i2, (byte)0);
            ++i2;
        }
        if (this.constrainthandler.isPossible(tmptest)) {
            int j = 0;
            while (j < this.strength) {
                this.matrix[row][j] = tmptest.get(j);
                ++j;
            }
            ++row;
        }
        i2 = 1;
        while (i2 < numOfCombinations) {
            tmptest = tmptest.makeClone();
            int j = this.strength - 1;
            while (j >= 0) {
                if (tmptest.get(j) + 1 < this.parametermodel.range[j]) {
                    tmptest.set(j, (byte)(tmptest.get(j) + 1));
                    break;
                }
                tmptest.set(j, (byte)0);
                --j;
            }
            if (this.constrainthandler.isPossible(tmptest)) {
                if (row + 1 > 65532) {
                    Error.printError(Main.language == Main.Language.JP ? "\u7279\u5b9a\u56e0\u5b50\u306e\u5168\u7db2\u7f85\u306b\u4e0a\u965065532\u3092\u8d85\u3048\u308b\u30c6\u30b9\u30c8\u30b1\u30fc\u30b9\u304c\u5fc5\u8981\u3067\u3059" : "The number of test cases exceeds the upper bound 65532");
                }
                j = 0;
                while (j < this.strength) {
                    this.matrix[row][j] = tmptest.get(j);
                    assert (tmptest.get(j) < this.parametermodel.range[j]);
                    ++j;
                }
                ++row;
            }
            ++i2;
        }
        this.numOfRows = row;
    }

    private int[] getBases(int[] c, int size, int factor) {
        int base = this.parametermodel.range[factor];
        int[] bases = new int[size];
        int i = size - 1;
        while (i >= 0) {
            bases[i] = base;
            base *= this.parametermodel.range[c[i]];
            --i;
        }
        return bases;
    }

    private int[] getTupleFromID(int id, int[] bases) {
        int[] tuple = new int[bases.length + 1];
        int i = 0;
        while (i < bases.length) {
            tuple[i] = id / bases[i];
            id %= bases[i];
            ++i;
        }
        tuple[bases.length] = id;
        return tuple;
    }
}

