// This file implements the IPropertyStoreCapabilities Interface and Gateway for Python.
// Generated by makegw.py
#include "PythonCOM.h"
#include "propsys.h"
#include "PyIPropertyStoreCapabilities.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIPropertyStoreCapabilities::PyIPropertyStoreCapabilities(IUnknown *pdisp):
	PyIUnknown(pdisp)
{
	ob_type = &type;
}

PyIPropertyStoreCapabilities::~PyIPropertyStoreCapabilities()
{
}

/* static */ IPropertyStoreCapabilities *PyIPropertyStoreCapabilities::GetI(PyObject *self)
{
	return (IPropertyStoreCapabilities *)PyIUnknown::GetI(self);
}

// @pymethod boolean|PyIPropertyStoreCapabilities|IsPropertyWritable|Asks provider if a property can be editted.
PyObject *PyIPropertyStoreCapabilities::IsPropertyWritable(PyObject *self, PyObject *args)
{
	IPropertyStoreCapabilities *pIPSC = GetI(self);
	if ( pIPSC == NULL )
		return NULL;
	PROPERTYKEY key;
	// @pyparm <o PyPROPERTYKEY>|key||Property identifier
	if ( !PyArg_ParseTuple(args, "O&:IsPropertyWritable", PyWinObject_AsPROPERTYKEY, &key))
		return NULL;
	HRESULT hr;
	PY_INTERFACE_PRECALL;
	hr = pIPSC->IsPropertyWritable(key);
	PY_INTERFACE_POSTCALL;
	return PyBool_FromLong(hr == S_OK);
}

// @object PyIPropertyStoreCapabilities|Property providers use this interface to indicate whether properties are writeable. 
static struct PyMethodDef PyIPropertyStoreCapabilities_methods[] =
{
	{ "IsPropertyWritable", PyIPropertyStoreCapabilities::IsPropertyWritable, 1 }, // @pymeth IsPropertyWritable|Asks provider if a property can be editted.
	{ NULL }
};

PyComTypeObject PyIPropertyStoreCapabilities::type("PyIPropertyStoreCapabilities",
		&PyIUnknown::type,
		sizeof(PyIPropertyStoreCapabilities),
		PyIPropertyStoreCapabilities_methods,
		GET_PYCOM_CTOR(PyIPropertyStoreCapabilities));
// ---------------------------------------------------
//
// Gateway Implementation
STDMETHODIMP PyGPropertyStoreCapabilities::IsPropertyWritable(REFPROPERTYKEY key)
{
	PY_GATEWAY_METHOD;
	PyObject *obkey = PyWinObject_FromPROPERTYKEY(key);
	if (obkey==NULL) return MAKE_PYCOM_GATEWAY_FAILURE_CODE("IsPropertyWritable");
	HRESULT hr=InvokeViaPolicy("IsPropertyWritable", NULL, "(O)", obkey);
	Py_DECREF(obkey);
	return hr;
}

