// This file implements the IBackgroundCopyJob3 Interface for Python.
// Generated by makegw.py

#include "bits_pch.h"
#include "PyIBackgroundCopyJob2.h"
#include "PyIBackgroundCopyJob3.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIBackgroundCopyJob3::PyIBackgroundCopyJob3(IUnknown *pdisp):
	PyIBackgroundCopyJob2(pdisp)
{
	ob_type = &type;
}

PyIBackgroundCopyJob3::~PyIBackgroundCopyJob3()
{
}

/* static */ IBackgroundCopyJob3 *PyIBackgroundCopyJob3::GetI(PyObject *self)
{
	return (IBackgroundCopyJob3 *)PyIBackgroundCopyJob2::GetI(self);
}

// @pymethod |PyIBackgroundCopyJob3|ReplaceRemotePrefix|Description of ReplaceRemotePrefix.
PyObject *PyIBackgroundCopyJob3::ReplaceRemotePrefix(PyObject *self, PyObject *args)
{
	IBackgroundCopyJob3 *pIBCJ3 = GetI(self);
	if ( pIBCJ3 == NULL )
		return NULL;
	// @pyparm <o unicode>|OldPrefix||Description for OldPrefix
	// @pyparm <o unicode>|NewPrefix||Description for NewPrefix
	PyObject *obOldPrefix;
	PyObject *obNewPrefix;
	LPWSTR OldPrefix;
	LPWSTR NewPrefix;
	if ( !PyArg_ParseTuple(args, "OO:ReplaceRemotePrefix", &obOldPrefix, &obNewPrefix) )
		return NULL;
	BOOL bPythonIsHappy = TRUE;
	if (bPythonIsHappy && !PyWinObject_AsBstr(obOldPrefix, &OldPrefix)) bPythonIsHappy = FALSE;
	if (bPythonIsHappy && !PyWinObject_AsBstr(obNewPrefix, &NewPrefix)) bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) return NULL;
	HRESULT hr;
	PY_INTERFACE_PRECALL;
	hr = pIBCJ3->ReplaceRemotePrefix( OldPrefix, NewPrefix );
	SysFreeString(OldPrefix);
	SysFreeString(NewPrefix);
	PY_INTERFACE_POSTCALL;
	if ( FAILED(hr) )
		return PyCom_BuildPyException(hr, pIBCJ3, IID_IBackgroundCopyJob3 );
	return PyInt_FromLong(hr);
}

// @pymethod |PyIBackgroundCopyJob3|AddFileWithRanges|Description of AddFileWithRanges.
PyObject *PyIBackgroundCopyJob3::AddFileWithRanges(PyObject *self, PyObject *args)
{
	IBackgroundCopyJob3 *pIBCJ3 = GetI(self);
	if ( pIBCJ3 == NULL )
		return NULL;
	// @pyparm <o unicode>|RemoteUrl||Description for RemoteUrl
	// @pyparm <o unicode>|LocalName||Description for LocalName
	BG_FILE_RANGE *Ranges;
	PyObject *obRanges;
	// @pyparm <o PyBG_FILE_RANGE>|Ranges||Description for Ranges
	PyObject *obRemoteUrl;
	PyObject *obLocalName;
	LPWSTR RemoteUrl;
	LPWSTR LocalName;
	if ( !PyArg_ParseTuple(args, "OOO:AddFileWithRanges", &obRemoteUrl, &obLocalName, &obRanges) )
		return NULL;
	DWORD RangeCount;
	BOOL bPythonIsHappy = TRUE;
	if (bPythonIsHappy && !PyWinObject_AsBstr(obRemoteUrl, &RemoteUrl)) bPythonIsHappy = FALSE;
	if (bPythonIsHappy && !PyWinObject_AsBstr(obLocalName, &LocalName)) bPythonIsHappy = FALSE;
	if (bPythonIsHappy && !PyObject_AsBG_FILE_RANGE_LIST( obRanges, &RangeCount, &Ranges )) bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) return NULL;
	HRESULT hr;
	PY_INTERFACE_PRECALL;
	hr = pIBCJ3->AddFileWithRanges( RemoteUrl, LocalName, RangeCount, Ranges );
	SysFreeString(RemoteUrl);
	SysFreeString(LocalName);
	PyObject_FreeBG_FILE_RANGE_LIST(RangeCount, Ranges);
	PY_INTERFACE_POSTCALL;
	if ( FAILED(hr) )
		return PyCom_BuildPyException(hr, pIBCJ3, IID_IBackgroundCopyJob3 );
	return PyInt_FromLong(hr);
}

// @pymethod |PyIBackgroundCopyJob3|SetFileACLFlags|Description of SetFileACLFlags.
PyObject *PyIBackgroundCopyJob3::SetFileACLFlags(PyObject *self, PyObject *args)
{
	IBackgroundCopyJob3 *pIBCJ3 = GetI(self);
	if ( pIBCJ3 == NULL )
		return NULL;
	// @pyparm int|Flags||Description for Flags
	DWORD Flags;
	if ( !PyArg_ParseTuple(args, "l:SetFileACLFlags", &Flags) )
		return NULL;
	HRESULT hr;
	PY_INTERFACE_PRECALL;
	hr = pIBCJ3->SetFileACLFlags( Flags );
	PY_INTERFACE_POSTCALL;
	if ( FAILED(hr) )
		return PyCom_BuildPyException(hr, pIBCJ3, IID_IBackgroundCopyJob3 );
	return PyInt_FromLong(hr);
}

// @pymethod |PyIBackgroundCopyJob3|GetFileACLFlags|Description of GetFileACLFlags.
PyObject *PyIBackgroundCopyJob3::GetFileACLFlags(PyObject *self, PyObject *args)
{
	IBackgroundCopyJob3 *pIBCJ3 = GetI(self);
	if ( pIBCJ3 == NULL )
		return NULL;
	if ( !PyArg_ParseTuple(args, ":GetFileACLFlags") )
		return NULL;
	HRESULT hr;
	DWORD Flags;
	PY_INTERFACE_PRECALL;
	hr = pIBCJ3->GetFileACLFlags( &Flags );
	PY_INTERFACE_POSTCALL;
	if ( FAILED(hr) )
		return PyCom_BuildPyException(hr, pIBCJ3, IID_IBackgroundCopyJob3 );
	return PyLong_FromUnsignedLongLong(Flags);
}

// @object PyIBackgroundCopyJob3|Description of the interface
static struct PyMethodDef PyIBackgroundCopyJob3_methods[] =
{
	{ "ReplaceRemotePrefix", PyIBackgroundCopyJob3::ReplaceRemotePrefix, 1 }, // @pymeth ReplaceRemotePrefix|Description of ReplaceRemotePrefix
	{ "AddFileWithRanges", PyIBackgroundCopyJob3::AddFileWithRanges, 1 }, // @pymeth AddFileWithRanges|Description of AddFileWithRanges
	{ "SetFileACLFlags", PyIBackgroundCopyJob3::SetFileACLFlags, 1 }, // @pymeth SetFileACLFlags|Description of SetFileACLFlags
	{ "GetFileACLFlags", PyIBackgroundCopyJob3::GetFileACLFlags, 1 }, // @pymeth GetFileACLFlags|Description of GetFileACLFlags
	{ NULL }
};

PyComTypeObject PyIBackgroundCopyJob3::type("PyIBackgroundCopyJob3",
		&PyIBackgroundCopyJob2::type,
		sizeof(PyIBackgroundCopyJob3),
		PyIBackgroundCopyJob3_methods,
		GET_PYCOM_CTOR(PyIBackgroundCopyJob3));
