package com.sample;

import static org.junit.Assert.*;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

import javax.json.Json;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JsonConverterTest {
	TestUtil util = TestUtil.getInstance();

	@Before
	public void before() {
	}

	@After
	public void after() {
	}

	@Test
	public void testConvert001() throws IOException {
		File path = util.getDir();
		// 入力値
		File input = new File(path, "input.csv");
		// 出力値
		File output = new File(path, "output.json");
		// 期待値のデータ
		File expected = new File(path, "expected_output.json");
		// 期待値のデータから改行、空白を除去
		File tmp = new File(path, "tmp.json");

		// JSONの比較の為の一時ファイルを作成
		createTmpJson(expected, tmp);
		// テスト実行
		execute(input, output);
		// 結果の比較
		assertTrue("JSONの比較", util.compare(tmp.toPath(), output.toPath()));
	}

	private void execute(File input, File output) throws IOException, FileNotFoundException {
		FileWriter w = new FileWriter(output);
		JsonConverter conv = new JsonConverter(Json.createGenerator(w));
		Reader r = new FileReader(input);
		conv.convert(r);
		w.close();
	}

	private void createTmpJson(File input, File output) throws IOException {
		BufferedReader br = new BufferedReader(new FileReader(input));
		FileWriter w = new FileWriter(output);
		try {
			StringBuilder sb = new StringBuilder();
			String line;
			while ((line = br.readLine()) != null) {
				line = line.replaceAll("[\\s\\t]+", "");
				sb.append(line);
			}
			w.write(sb.toString());
		} finally {
			br.close();
			w.close();
		}
	}
}
