package com.sample;

import java.io.*;

import javax.json.Json;
import javax.json.stream.JsonGenerator;

/**
 * 前提条件：(1)CSVは、キー値でソートされている。(2)キー値が一致するレコードは、存在しない。
 * サンプル：sample()のファイルパスを修正する事。
 */
public class JsonConverter {
	/**
	 * 以下の値をCSV, JSONの形式に合わせて修正する
	 */
	/** id項目の数 */
	private static final int DEPTH_MAX = 3;
	/** CSVの最大カラム数 */
	private static final int COLUMN_MAX = 8;
	/** CSVのid項目の位置(0始まり) */
	private static final int[] KEY_COLS = { 1, 3, 6, };
	/** JSONの項目名(CSVの項目の位置に対応(0始まり)) */
	private static final String[] NAMES = { "", "id", "name1", "id", "name2", "name3", "id", "name4", };
	/** JSONの配列要素の項目名 */
	private static final String ARRAY_NAME = "attachment";
	/**
	 * CSVのカラム位置とJSONの階層の対応
	 * 
	 * 例) COLUMNS = { { 1, 2 }, { 3, 4, 5 }, { 6, 7 }, }; { 1, 2 }は、CSVの1,
	 * 2カラムは、階層0に出力。 { 3, 4, 5 }は、CSVの3, 4, 5カラムは、階層0に出力。 { 6, 7 }は、CSVの6,
	 * 7カラムは、階層0に出力。
	 */
	private static final int[][] COLUMNS = { { 1, 2 }, { 3, 4, 5 }, { 6, 7 }, };

	/** CSVのキー値を保持 */
	private PrevData pd = new PrevData(DEPTH_MAX);
	/** CSVのカレント行のキー値を保持 */
	private String[] ids = new String[DEPTH_MAX];
	/** CSVのカレント行の値を保(毎回newする事も可能だが性能を優先した) */
	private String[] cols = new String[COLUMN_MAX];
	/** 何階層目まで表示したかを保持(CSV最終行の処理の為に必要) */
	private int end;
	/** JSONジェネレータ */
	private JsonGenerator gen;

	public JsonConverter(JsonGenerator gen) {
		this.gen = gen;
	}

	public void convert(Reader r) throws IOException {
		BufferedReader br = new BufferedReader(r);
		try {
			int status = 1;

			// TODO
			// データ行が0の場合、javax.json.stream.JsonGenerationExceptionが発生する
			String line;
			while ((line = br.readLine()) != null) {
				String[] cols = parseCSV(line);
				// TODO
				// 要素数が1以上かをチェック
				String col0 = cols[0];

				switch (status) {
				case 1:
					// 先頭行
					if (!"1".equals(col0)) {
						// TODO
						throw new RuntimeException();
					}
					execHeader(cols);
					status = 2;
					break;
				case 2:
					if (!"2".equals(col0) && !"8".equals(col0)) {
						// TODO
						throw new RuntimeException();
					}
					if ("2".equals(col0)) {
						// データ行
						copyIds(cols);
						execBody(ids, cols);
					} else {
						// 最終行
						execFooter(cols);
						status = 8;
					}
					break;
				case 8:
					// 最終行の後には、データは無い
					// TODO
					throw new RuntimeException();
				}
			}
			if (status != 8) {
				// 最終行で終わっていない
				// TODO
				throw new RuntimeException();
			}
		} finally {
			br.close();
		}
	}

	/**
	 * キー値をコピー
	 */
	private void copyIds(String[] cols) {
		for (int i = 0; i < ids.length; i++) {
			int pos = KEY_COLS[i];
			ids[i] = cols[pos];
		}
	}

	/**
	 * CSVのパース 常に最大項目数になるようにカラム数を調整(COLUMN_MAXにする)
	 */
	private String[] parseCSV(String line) {
		String[] c = line.split(",");
		// TODO 必須項目チェック
		// TODO COLUMN_MAXを超えるデータは無視(チェックが必要なら追加する事)

		int i;
		for (i = 0; i < c.length; i++) {
			cols[i] = c[i];
		}
		for (; i < cols.length; i++) {
			cols[i] = "";
		}
		return cols;
	}

	/**
	 * データ行の処理
	 */
	private void execBody(String[] ids, String[] cols) {
		// 一行目の読み込みか
		boolean isFirst = pd.isFirst();
		// 何階層目まで表示したかを保持
		int prevEnd = pd.getEnd();
		// 何階層目のキー値が前回行のキー値と異なっているか(1始まり)
		int level = pd.compare(ids);
		// 何階層目まで表示したかを保持
		end = pd.getEnd();

		if (level == 0) {
			// TODO
			// キー重複(全ての階層のキー値が等しい)
			throw new RuntimeException();
		}
		if (!isFirst) {
			// int count = ids.length - level + 1;
			int count = prevEnd - level;
			// 末端の階層は子が存在しない為、writeStartArrayの呼び出しが1回少ない
			gen.writeEnd();

			// 出力するべき階層まで、階層を上げていく
			for (int i = 0; i < count; i++) {
				gen.writeEnd();
				gen.writeEnd();
			}
		}

		// for (int i = level - 1; i < ids.length; i++) {
		for (int i = level - 1; i < end; i++) {
			int[] pos = COLUMNS[i];
			gen.writeStartObject();
			for (int j = 0; j < pos.length; j++) {
				int p = pos[j];
				// 項目名: "項目値"
				gen.write(NAMES[p], cols[p]);
			}
			// 末端の階層は子が存在しない為、writeStartArrayを呼ばない
			if (i < end - 1) {
				gen.writeStartArray(ARRAY_NAME);
			}
		}
	}

	/**
	 * 先頭行の処理
	 */
	private void execHeader(String[] cols) {
		gen.writeStartObject(); // start object A
		gen.write("START", "スタート");
		gen.writeStartArray("dep"); // start array A
	}

	/**
	 * 最終行の処理
	 */
	private void execFooter(String[] cols) {
		// int count = DEPTH_MAX;
		int count = end - 1;
		// 末端の階層は子が存在しない為、writeStartArrayの呼び出しが1回少ない
		gen.writeEnd();
		for (int i = 0; i < count; i++) {
			gen.writeEnd();
			gen.writeEnd();
		}
		gen.writeEnd(); // end array A
		gen.writeEnd(); // end object A

		gen.flush();
	}

	public static void main(String[] args) throws IOException {
		// TODO 文字コード
		StringWriter w = new StringWriter();
		JsonConverter conv = new JsonConverter(Json.createGenerator(w));
		// JsonConverter conv = new JsonConverter(new MyJsonGenerator()); // デバッグ用
		sample(conv);
		w.close();
		System.out.println(w.toString());
	}

	private static void sample(JsonConverter conv) throws IOException {
		String input = "/Users/konishiyuji/tmp/b/input.csv";
		Reader r = new FileReader(new File(input));
		conv.convert(r);
	}
}
